<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require_once('vendor/bshaffer/oauth2-server-php/src/OAuth2/Autoloader.php');

class Appdirectapi extends CI_Controller {
	
	public $oauth_server ;
	
	/*
	public $appDirectUrl = "https://testvfuk.appdirect.com/" ;
	
	public $inboundClientId 	   = "VmIIttgRm2" ;
	public $inboundClientSecret    = "dAz8NqepUtr6m6ktLVo4" ;
	*/
	
	public $appDirectUrl = "https://marketplace.vodafone.co.uk/" ;
	
	public $inboundClientId 	   = "y0ijPcC26r" ;
	public $inboundClientSecret    = "960a7da0CcD12VPqLUyH" ;
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->library('curl');
		$this->load->model('users') ;
		
		if( $_SERVER['HTTP_HOST'] == 'localhost' )  //local
		{
				$dsn      = 'mysql:dbname=orbis;host=localhost';
				$username = 'root';
				$password = 'root';
		} else {

				$dsn      = 'mysql:dbname=orbis;host=prod-orbis-portal.ckymzexx1qhn.eu-west-2.rds.amazonaws.com';
				$username = 'orbis';
				$password = '}uhpSDktS7G~R`9P';
		}
		
		OAuth2\Autoloader::register();

		// $dsn is the Data Source Name for your database, for exmaple "mysql:dbname=my_oauth2_db;host=localhost"
		$storage = new OAuth2\Storage\Pdo(array('dsn' => $dsn, 'username' => $username, 'password' => $password));

		// Pass a storage object or array of storage objects to the OAuth2 server class
		$this->oauth_server = new OAuth2\Server($storage);

		// Add the "Client Credentials" grant type (it is the simplest of the grant types)
		$this->oauth_server->addGrantType(new OAuth2\GrantType\ClientCredentials($storage));

		// Add the "Authorization Code" grant type (this is where the oauth magic happens)
		$this->oauth_server->addGrantType(new OAuth2\GrantType\AuthorizationCode($storage));

	}
	
	public function response($response, $statusCode, $statusText = null ) {
		
		$protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
		
		header('content-type:application/json');
		header($protocol . ' ' . $statusCode . ' ' . $statusText);
		
		echo json_encode($response) ;
	
	}
	
	
	function token() {
		
		$response = $this->oauth_server->handleTokenRequest(OAuth2\Request::createFromGlobals())->send();
		
	}
	
	
	function createSubscription() {
		
		
		
		//$request = print_r($_REQUEST, TRUE) ;
		
		//~ $request1 = print_r($_POST, TRUE) ;
		//~ $request2 = print_r($_GET, TRUE) ;
		// $fp = fopen('/var/www/html/orbis/assets/bulkuploadfile/create-request.php', 'a');//opens file in append mode  
		//fwrite($fp, $request.PHP_EOL);  
		//fwrite($fp, $request1.PHP_EOL);  
		//fwrite($fp, $request2.PHP_EOL);  
		//fwrite($fp, 'appending data'.PHP_EOL);  
		
		
		$response   = "" ;
		$statusCode = "" ;
		$statusText = "" ;
		
		if (!$this->oauth_server->verifyResourceRequest(OAuth2\Request::createFromGlobals())) {
			
			// if token not found or token is expired or any other error related to token
			// $this->oauth_server->getResponse()->send();
			
			
			$response   = [ 
							"success"   => "false",
							"errorCode" => "UNAUTHORIZED",
							"message"   => "Invalid token"
			] ;
			$statusCode = 401 ;
			$statusText = "Unauthorized" ;
			
			
		} else {
			
			
			$eventUrl = $this->input->get('eventUrl') ;
			
			if ( $eventUrl ) {
				
				//fwrite($fp, $eventUrl.PHP_EOL);
				
				$host = $this->appDirectUrl."oauth2/token" ;
				$username = $this->inboundClientId  ;
				$password = $this->inboundClientSecret ;
				
				$ch = curl_init($host);
				//curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
				//curl_setopt($ch, CURLOPT_HEADER, 1);
				curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
				curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password);
				curl_setopt($ch, CURLOPT_TIMEOUT, 30);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials&scope=ROLE_APPLICATION");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				$return = curl_exec($ch);
				
				
				if($return === false)
				{
					$curlError =  'Curl error: ' . curl_error($ch);
					
					$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Curl error for token."
					] ;
					$statusCode = 200 ;
					$statusText = "Ok" ;
					
					$this->response($response, $statusCode , $statusText);
					
					exit;
					
				}          
				
				/***catch curl error and status code***/
				$errors = curl_error($ch);  
				$returnCode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
				/***catch curl error and status code***/
				
				curl_close($ch);
				
				$return = json_decode($return); 
				
				
				if ( isset($return->access_token)  && $return->access_token ) {
				
				
					$bearerToken =  $return->access_token ;
					
					//fwrite($fp, $bearerToken.PHP_EOL);
					
					$headers = array(
						'Content-Type: application/json',
						sprintf('Authorization: Bearer %s', $bearerToken)
					);

					$curl = curl_init($eventUrl);
					
					curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

					$result = curl_exec($curl) ;
					
					if($result === false)
					{
						$curlErrorEvent =  'Curl error: ' . curl_error($curl);
						
						$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Curl error for Event Url."
						] ;
						$statusCode = 200 ;
						$statusText = "Ok" ;
						
						$this->response($response, $statusCode , $statusText);
						
						exit;
					
					}  
					 
					/***catch curl error and status code***/
					$errorsEvent 	 = curl_error($curl);  
					$returnCodeEvent = (int)curl_getinfo($curl, CURLINFO_HTTP_CODE);
					/***catch curl error and status code***/
				
					curl_close($curl);
					
					/***XML to array conversion***/
					
					$new = simplexml_load_string($result); 
  
					// Convert into json 
					$con = json_encode($new); 
					  
					// Convert into associative array 
					$xmlToArray = json_decode($con, true); 
					
					
					/***XML to array conversion***/
					
					if( isset($xmlToArray['code']) && ( $xmlToArray['code'] == "Gone" ||  $xmlToArray['code'] == "Not Found") ) {
					
						$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => ( isset($xmlToArray['message']) ? $xmlToArray['message'] : 'Event token already consumed.')
						] ;
						$statusCode = 200 ;
						$statusText = "Ok" ;
						
						$this->response($response, $statusCode , $statusText);
						
						exit;
					
					
					}
					
					if ( $xmlToArray && isset($xmlToArray['type']) && $xmlToArray['type'] == "SUBSCRIPTION_ORDER"  )
					{
						/***prepare the data to inser to database***/
						
						$accountIdentifier = md5(uniqid(mt_rand(), true)) ;
						
						$data['account_identifier']  		= $accountIdentifier ;
						$data['subscription_type'] 			= ( isset($xmlToArray['type']) ? $xmlToArray['type'] : '' ) ;
						$data['marketplace_baseUrl']		= ( isset($xmlToArray['marketplace']['baseUrl']) ? $xmlToArray['marketplace']['baseUrl'] : '' ) ;
						$data['marketplace_partner'] 		= ( isset($xmlToArray['marketplace']['partner']) ? $xmlToArray['marketplace']['partner'] : '' ) ;
						$data['flag'] 				 		= ( isset($xmlToArray['flag']) ? $xmlToArray['flag'] : '' ) ;
						$data['creator_email'] 			    = ( isset($xmlToArray['creator']['email']) ? $xmlToArray['creator']['email'] : '' ) ;
						$data['creator_firstName'] 	 		= ( isset($xmlToArray['creator']['firstName']) ? $xmlToArray['creator']['firstName'] : '' ) ;
						$data['creator_lastName'] 	 		= ( isset($xmlToArray['creator']['lastName']) ? $xmlToArray['creator']['lastName'] : '' ) ;
						$data['creator_openId'] 	  	    = ( isset($xmlToArray['creator']['openId']) ? $xmlToArray['creator']['openId'] : '' ) ;
						$data['creator_uuid'] 		        = ( isset($xmlToArray['creator']['uuid']) ? $xmlToArray['creator']['uuid'] : '' ) ;
						$data['payload_company_country']    = ( isset($xmlToArray['payload']['company']['country']) ? $xmlToArray['payload']['company']['country'] : '' ) ;
						$data['payload_company_externalId'] = ( isset($xmlToArray['payload']['company']['externalId']) ? $xmlToArray['payload']['company']['externalId'] : '' ) ;
						$data['payload_company_name'] 		= ( isset($xmlToArray['payload']['company']['name']) ? $xmlToArray['payload']['company']['name'] : '' ) ;
						$data['payload_company_uuid'] 		= ( isset($xmlToArray['payload']['company']['uuid']) ? $xmlToArray['payload']['company']['uuid'] : '' ) ;
						$data['order_editionCode'] 			= ( isset($xmlToArray['payload']['order']['editionCode']) ? $xmlToArray['payload']['order']['editionCode'] : '' ) ;
						$data['order_pricingDuration']		 = ( isset($xmlToArray['payload']['order']['pricingDuration']) ? $xmlToArray['payload']['order']['pricingDuration'] : '' ) ;
						$data['order_freeTrial_active']		 = ( isset($xmlToArray['payload']['order']['freeTrial']['active']) ? $xmlToArray['payload']['order']['freeTrial']['active'] : '' ) ;
						$data['payload_order_discountCode']		 = ( isset($xmlToArray['payload']['order']['discountCode']) ? $xmlToArray['payload']['order']['discountCode'] : '' ) ;
						
						
						
						if ( isset($xmlToArray['payload']['order']['item']) ) {
						
							$payloadOrderItems = ( isset($xmlToArray['payload']['order']['item']) ? $xmlToArray['payload']['order']['item'] : '' ) ;
							
							/*if ( $payloadOrderItems && is_array($payloadOrderItems) ) {
							
								$data['payload_order_item'] = json_encode($payloadOrderItems) ;
							
							}*/
							
							if (isset($payloadOrderItems['quantity']) && $payloadOrderItems['quantity']) {
								$data['payload_order_item'] = $payloadOrderItems['quantity'] ;
							} elseif (isset($payloadOrderItems[0]['quantity']) && $payloadOrderItems[0]['quantity']) {
								$data['payload_order_item'] = $payloadOrderItems[0]['quantity'] ;
							} else {
								$data['payload_order_item'] = "-" ;
							}
							
							
						} elseif( isset($xmlToArray['payload']['order']['items']) ) {
						
							$payloadOrderItems = ( isset($xmlToArray['payload']['order']['items']) ? $xmlToArray['payload']['order']['items'] : '' ) ;
							
							/*if ( $payloadOrderItems && is_array($payloadOrderItems) ) {
							
								$data['payload_order_item'] = json_encode($payloadOrderItems) ;
							
							}*/
							
							if (isset($payloadOrderItems['quantity']) && $payloadOrderItems['quantity']) {
								$data['payload_order_item'] = $payloadOrderItems['quantity'] ;
							} elseif (isset($payloadOrderItems[0]['quantity']) && $payloadOrderItems[0]['quantity']) {
								$data['payload_order_item'] = $payloadOrderItems[0]['quantity'] ;
							} else {
								$data['payload_order_item'] = "-" ;
							}
							
							
						}
						
						
						$data['subscription_status']		 = 'active' ;
						
						
						/***Set Billing Info***/
						
						
						if ( isset( $xmlToArray['payload']['configuration']['entry'] ) && $xmlToArray['payload']['configuration']['entry'] ) {

									foreach( $xmlToArray['payload']['configuration']['entry'] as $prepareBillingData) {

										if ( $prepareBillingData['key'] == "addressLine1_building") {
											
											$data['billing_address_line1'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "addressLine2_streetName") {
											
											$data['billing_address_line2'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "addressLine3_locality") {
											
											$data['billing_address_line3'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "phoneNumber") {
											
											$data['billing_phone_number'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "city") {
											
											$data['billing_city'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "postCode") {
											
											$data['billing_postCode'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "state") {
											
											$data['billing_state'] = $prepareBillingData['value'] ;
										}

									}




						 }
						/***Set Billing Info***/
						
						
						/***prepare the data to inser to database***/
						
						$insertData = $this->users->createSubscriptionVodafoneMarketPlace($data) ;
						
						
						if ( $insertData ) {
							//fwrite($fp, "Id = " . $insertData.PHP_EOL);  
							
							$response   = [ 
								"success"   		=> "true",
								"accountIdentifier" => $accountIdentifier,
								"message"   		=> "Subscription created."
							] ;
							
							$statusCode = 200 ;
							$statusText = "Ok" ;
							
						} else {
							$response   = [ 
								"success"   => "false",
								"errorCode" => "UNKNOWN_ERROR",
								"message"   => "Data not inserted in database."
							] ;
							
							$statusCode = 500 ;
							$statusText = "Internal Server Error" ;
						}
						
						
					} else {
						$response   = [ 
							"success"   => "false",
							"errorCode" => "INVALID_RESPONSE",
							"message"   => ""
						] ;
						$statusCode = 400 ;
						$statusText = "Bad Request" ;
					}
					
					
				} else {
					
					$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Token from Appdirect not found."
					] ;
					$statusCode = 200 ;
					$statusText = "Ok" ;
					
				}
				
				
				//~ fwrite($fp, "Errors = " . print_r($errorsEvent, TRUE).PHP_EOL);  
				//~ //fwrite($fp, "Result = " . print_r($result, true).PHP_EOL);  
				//~ fwrite($fp, "Result = " . $result .PHP_EOL);  
				//~ fwrite($fp, "ResultNew = " . print_r($xmlToArray, true).PHP_EOL);  
				//~ fwrite($fp, "Return Code = " . $returnCodeEvent.PHP_EOL);  
			} else {
				
			    $response   = [ 
							"success"   => "false",
							"errorCode" => "INVALID_RESPONSE",
							"message"   => "Event URL not found"
				] ;
				$statusCode = 422 ;
				$statusText = "Unprocessable Entity" ;
			}
			
			
		}
		//~ fwrite($fp, $text.PHP_EOL);  
		//~ fclose($fp); 
		$this->response($response, $statusCode , $statusText);
	}
	
	
	function changeSubscription() {
		
		
		
		//$request = print_r($_REQUEST, TRUE) ;
		
		//~ $request1 = print_r($_POST, TRUE) ;
		//~ $request2 = print_r($_GET, TRUE) ;
		// $fp = fopen('/var/www/html/orbis/assets/bulkuploadfile/modification-request.php', 'a');//opens file in append mode  
		//fwrite($fp, $request.PHP_EOL);  
		//fwrite($fp, $request1.PHP_EOL);  
		//fwrite($fp, $request2.PHP_EOL);  
		//fwrite($fp, 'appending data'.PHP_EOL);  
		
		
		$response   = "" ;
		$statusCode = "" ;
		$statusText = "" ;
		
		if (!$this->oauth_server->verifyResourceRequest(OAuth2\Request::createFromGlobals())) {
			
			// if token not found or token is expired or any other error related to token
			// $this->oauth_server->getResponse()->send();
			
			
			$response   = [ 
							"success"   => "false",
							"errorCode" => "UNAUTHORIZED",
							"message"   => "Invalid token"
			] ;
			$statusCode = 401 ;
			$statusText = "Unauthorized" ;
			
			
		} else {
			
			
			$eventUrl = $this->input->get('eventUrl') ;
			
			if ( $eventUrl ) {
				
				//fwrite($fp, $eventUrl.PHP_EOL);
				
				$host = $this->appDirectUrl."oauth2/token" ;
				$username = $this->inboundClientId  ;
				$password = $this->inboundClientSecret ;
				
				$ch = curl_init($host);
				//curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
				//curl_setopt($ch, CURLOPT_HEADER, 1);
				curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
				curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password);
				curl_setopt($ch, CURLOPT_TIMEOUT, 30);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials&scope=ROLE_APPLICATION");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				$return = curl_exec($ch);
				
				
				if($return === false)
				{
					$curlError =  'Curl error: ' . curl_error($ch);
					
					$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Curl error for token."
					] ;
					$statusCode = 200 ;
					$statusText = "Ok" ;
					
					$this->response($response, $statusCode , $statusText);
					
					exit;
					
				}          
				
				/***catch curl error and status code***/
				$errors = curl_error($ch);  
				$returnCode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
				/***catch curl error and status code***/
				
				curl_close($ch);
				
				$return = json_decode($return); 
				
				
				if ( isset($return->access_token)  && $return->access_token ) {
				
				
					$bearerToken =  $return->access_token ;
					
					//fwrite($fp, $bearerToken.PHP_EOL);
					
					$headers = array(
						'Content-Type: application/json',
						sprintf('Authorization: Bearer %s', $bearerToken)
					);

					$curl = curl_init($eventUrl);
					
					curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

					$result = curl_exec($curl) ;
					
					if($result === false)
					{
						$curlErrorEvent =  'Curl error: ' . curl_error($curl);
						
						$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Curl error for Event Url."
						] ;
						$statusCode = 200 ;
						$statusText = "Ok" ;
						
						$this->response($response, $statusCode , $statusText);
						
						exit;
					
					}  
					 
					/***catch curl error and status code***/
					$errorsEvent 	 = curl_error($curl);  
					$returnCodeEvent = (int)curl_getinfo($curl, CURLINFO_HTTP_CODE);
					/***catch curl error and status code***/
				
					curl_close($curl);
					
					/***XML to array conversion***/
					
					$new = simplexml_load_string($result); 
  
					// Convert into json 
					$con = json_encode($new); 
					  
					// Convert into associative array 
					$xmlToArray = json_decode($con, true); 
					
					
					/***XML to array conversion***/
					
					if( isset($xmlToArray['code']) && ( $xmlToArray['code'] == "Gone" ||  $xmlToArray['code'] == "Not Found") ) {
					
						$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => ( isset($xmlToArray['message']) ? $xmlToArray['message'] : 'Event token already consumed.')
						] ;
						$statusCode = 200 ;
						$statusText = "Ok" ;
						
						$this->response($response, $statusCode , $statusText);
						
						exit;
					
					
					}
					
					if ( $xmlToArray && isset($xmlToArray['type']) && $xmlToArray['type'] == "SUBSCRIPTION_CHANGE" &&  isset($xmlToArray['payload']['account']['accountIdentifier']) && $xmlToArray['payload']['account']['accountIdentifier'] )
					{
						/***prepare the data to inser to database***/
						
						$accountIdentifier 					= $xmlToArray['payload']['account']['accountIdentifier'] ;
						
						$getData							= $this->users->checkFromAccountIdentifier($accountIdentifier) ;
						
						
						if ( !$getData ) {
							$response   = [ 
								"success"   => "false",
								"errorCode" => "UNKNOWN_ERROR",
								"message"   => "Account Identifier not found"
							] ;
							$statusCode = 404 ;
							$statusText = "Ok" ;
							
							$this->response($response, $statusCode , $statusText);
						
							exit;
						} 
						
						$data['vodafone_market_place_id']  	= $getData['id'] ;
						$data['account_identifier']  		= $accountIdentifier ;
						$data['account_identifier_status'] 	= ( isset($xmlToArray['payload']['account']['status']) ? $xmlToArray['payload']['account']['status'] : '' ) ;
						$data['subscription_type'] 			= ( isset($xmlToArray['type']) ? $xmlToArray['type'] : '' ) ;
						$data['marketplace_baseUrl']		= ( isset($xmlToArray['marketplace']['baseUrl']) ? $xmlToArray['marketplace']['baseUrl'] : '' ) ;
						$data['marketplace_partner'] 		= ( isset($xmlToArray['marketplace']['partner']) ? $xmlToArray['marketplace']['partner'] : '' ) ;
						$data['flag'] 				 		= ( isset($xmlToArray['flag']) ? $xmlToArray['flag'] : '' ) ;
						$data['creator_email'] 			    = ( isset($xmlToArray['creator']['email']) ? $xmlToArray['creator']['email'] : '' ) ;
						$data['creator_firstName'] 	 		= ( isset($xmlToArray['creator']['firstName']) ? $xmlToArray['creator']['firstName'] : '' ) ;
						$data['creator_lastName'] 	 		= ( isset($xmlToArray['creator']['lastName']) ? $xmlToArray['creator']['lastName'] : '' ) ;
						$data['creator_openId'] 	  	    = ( isset($xmlToArray['creator']['openId']) ? $xmlToArray['creator']['openId'] : '' ) ;
						$data['creator_uuid'] 		        = ( isset($xmlToArray['creator']['uuid']) ? $xmlToArray['creator']['uuid'] : '' ) ;
						$data['order_editionCode'] 			= ( isset($xmlToArray['payload']['order']['editionCode']) ? $xmlToArray['payload']['order']['editionCode'] : '' ) ;
						$data['order_pricingDuration']		 = ( isset($xmlToArray['payload']['order']['pricingDuration']) ? $xmlToArray['payload']['order']['pricingDuration'] : '' ) ;
						$data['order_freeTrial_active']		 = ( isset($xmlToArray['payload']['order']['freeTrial']['active']) ? $xmlToArray['payload']['order']['freeTrial']['active'] : '' ) ;
						$data['payload_order_discountCode']	 = ( isset($xmlToArray['payload']['order']['discountCode']) ? $xmlToArray['payload']['order']['discountCode'] : '' ) ;
						
						
						$data['payload_company_name']	 = ( isset( $getData['payload_company_name'] ) ? $getData['payload_company_name'] : '' ) ;
						
						
						if ( isset($xmlToArray['payload']['order']['item']) ) {
						
							$payloadOrderItems = ( isset($xmlToArray['payload']['order']['item']) ? $xmlToArray['payload']['order']['item'] : '' ) ;
							
							/*if ( $payloadOrderItems && is_array($payloadOrderItems) ) {
							
								$data['payload_order_item'] = json_encode($payloadOrderItems) ;
							
							}*/
							
							if (isset($payloadOrderItems['quantity']) && $payloadOrderItems['quantity']) {
								$data['payload_order_item'] = $payloadOrderItems['quantity'] ;
							} elseif (isset($payloadOrderItems[0]['quantity']) && $payloadOrderItems[0]['quantity']) {
								$data['payload_order_item'] = $payloadOrderItems[0]['quantity'] ;
							} else {
								$data['payload_order_item'] = "-" ;
							}
							
						} elseif( isset($xmlToArray['payload']['order']['items']) ) {
						
							$payloadOrderItems = ( isset($xmlToArray['payload']['order']['items']) ? $xmlToArray['payload']['order']['items'] : '' ) ;
							
							/*if ( $payloadOrderItems && is_array($payloadOrderItems) ) {
							
								$data['payload_order_item'] = json_encode($payloadOrderItems) ;
							
							}*/
							
							
							if (isset($payloadOrderItems['quantity']) && $payloadOrderItems['quantity']) {
								$data['payload_order_item'] = $payloadOrderItems['quantity'] ;
							} elseif (isset($payloadOrderItems[0]['quantity']) && $payloadOrderItems[0]['quantity']) {
								$data['payload_order_item'] = $payloadOrderItems[0]['quantity'] ;
							} else {
								$data['payload_order_item'] = "-" ;
							}
							
						}
						
						
						$data['subscription_status']		 = 'active' ;
						
						/***Set Billing Info***/
						
						
						if ( isset( $xmlToArray['payload']['configuration']['entry'] ) && $xmlToArray['payload']['configuration']['entry'] ) {

									foreach( $xmlToArray['payload']['configuration']['entry'] as $prepareBillingData) {

										if ( $prepareBillingData['key'] == "addressLine1_building") {
											
											$data['billing_address_line1'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "addressLine2_streetName") {
											
											$data['billing_address_line2'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "addressLine3_locality") {
											
											$data['billing_address_line3'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "phoneNumber") {
											
											$data['billing_phone_number'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "city") {
											
											$data['billing_city'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "postCode") {
											
											$data['billing_postCode'] = $prepareBillingData['value'] ;
										}
										
										if ( $prepareBillingData['key'] == "state") {
											
											$data['billing_state'] = $prepareBillingData['value'] ;
										}

									}




						 }
						/***Set Billing Info***/
						
						/***prepare the data to inser to database***/
						
						$insertData = $this->users->modifySubscriptionVodafoneMarketPlace($data) ;
						
						
						if ( $insertData ) {
							//fwrite($fp, "Id = " . $insertData.PHP_EOL);  
							
							$response   = [ 
								"success"   		=> "true",
								"message"   		=> "Subscription modified."
							] ;
							
							$statusCode = 200 ;
							$statusText = "Ok" ;
							
						} else {
							$response   = [ 
								"success"   => "false",
								"errorCode" => "UNKNOWN_ERROR",
								"message"   => "Data not inserted in database."
							] ;
							
							$statusCode = 500 ;
							$statusText = "Internal Server Error" ;
						}
						
						
					} else {
						$response   = [ 
							"success"   => "false",
							"errorCode" => "INVALID_RESPONSE",
							"message"   => ""
						] ;
						$statusCode = 400 ;
						$statusText = "Bad Request" ;
					}
					
					
				} else {
					
					$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Token from Appdirect not found."
					] ;
					$statusCode = 200 ;
					$statusText = "Ok" ;
					
				}
				
				
				//~ fwrite($fp, "Errors = " . print_r($errorsEvent, TRUE).PHP_EOL);  
				//~ //fwrite($fp, "Result = " . print_r($result, true).PHP_EOL);  
				//~ fwrite($fp, "Result = " . $result .PHP_EOL);  
				//~ fwrite($fp, "ResultNew = " . print_r($xmlToArray, true).PHP_EOL);  
				//~ fwrite($fp, "Return Code = " . $returnCodeEvent.PHP_EOL);  
			} else {
				
			    $response   = [ 
							"success"   => "false",
							"errorCode" => "INVALID_RESPONSE",
							"message"   => "Event URL not found"
				] ;
				$statusCode = 422 ;
				$statusText = "Unprocessable Entity" ;
			}
			
			
		}
		//~ fwrite($fp, $text.PHP_EOL);  
		//~ fclose($fp); 
		$this->response($response, $statusCode , $statusText);
	}
	
	function cancelSubscription() {
		
		
		
		//$request = print_r($_REQUEST, TRUE) ;
		
		//~ $request1 = print_r($_POST, TRUE) ;
		//~ $request2 = print_r($_GET, TRUE) ;
		// $fp = fopen('/var/www/html/orbis/assets/bulkuploadfile/cancel-request.php', 'a');//opens file in append mode  
		//fwrite($fp, $request.PHP_EOL);  
		//fwrite($fp, $request1.PHP_EOL);  
		//fwrite($fp, $request2.PHP_EOL);  
		//fwrite($fp, 'appending data'.PHP_EOL);  
		
		
		$response   = "" ;
		$statusCode = "" ;
		$statusText = "" ;
		
		if (!$this->oauth_server->verifyResourceRequest(OAuth2\Request::createFromGlobals())) {
			
			// if token not found or token is expired or any other error related to token
			// $this->oauth_server->getResponse()->send();
			
			
			$response   = [ 
							"success"   => "false",
							"errorCode" => "UNAUTHORIZED",
							"message"   => "Invalid token"
			] ;
			$statusCode = 401 ;
			$statusText = "Unauthorized" ;
			
			
		} else {
			
			
			$eventUrl = $this->input->get('eventUrl') ;
			
			if ( $eventUrl ) {
				
				//fwrite($fp, $eventUrl.PHP_EOL);
				
				$host = $this->appDirectUrl."oauth2/token" ;
				$username = $this->inboundClientId  ;
				$password = $this->inboundClientSecret ;
				
				$ch = curl_init($host);
				//curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
				//curl_setopt($ch, CURLOPT_HEADER, 1);
				curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
				curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password);
				curl_setopt($ch, CURLOPT_TIMEOUT, 30);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials&scope=ROLE_APPLICATION");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				$return = curl_exec($ch);
				
				
				if($return === false)
				{
					$curlError =  'Curl error: ' . curl_error($ch);
					
					$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Curl error for token."
					] ;
					$statusCode = 200 ;
					$statusText = "Ok" ;
					
					$this->response($response, $statusCode , $statusText);
					
					exit;
					
				}          
				
				/***catch curl error and status code***/
				$errors = curl_error($ch);  
				$returnCode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
				/***catch curl error and status code***/
				
				curl_close($ch);
				
				$return = json_decode($return); 
				
				
				if ( isset($return->access_token)  && $return->access_token ) {
				
				
					$bearerToken =  $return->access_token ;
					
					//fwrite($fp, $bearerToken.PHP_EOL);
					
					$headers = array(
						'Content-Type: application/json',
						sprintf('Authorization: Bearer %s', $bearerToken)
					);

					$curl = curl_init($eventUrl);
					
					curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

					$result = curl_exec($curl) ;
					
					if($result === false)
					{
						$curlErrorEvent =  'Curl error: ' . curl_error($curl);
						
						$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Curl error for Event Url."
						] ;
						$statusCode = 200 ;
						$statusText = "Ok" ;
						
						$this->response($response, $statusCode , $statusText);
						
						exit;
					
					}  
					 
					/***catch curl error and status code***/
					$errorsEvent 	 = curl_error($curl);  
					$returnCodeEvent = (int)curl_getinfo($curl, CURLINFO_HTTP_CODE);
					/***catch curl error and status code***/
				
					curl_close($curl);
					
					/***XML to array conversion***/
					
					$new = simplexml_load_string($result); 
  
					// Convert into json 
					$con = json_encode($new); 
					  
					// Convert into associative array 
					$xmlToArray = json_decode($con, true); 
					
					
					/***XML to array conversion***/
					
					if( isset($xmlToArray['code']) && ( $xmlToArray['code'] == "Gone" ||  $xmlToArray['code'] == "Not Found") ) {
					
						$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => ( isset($xmlToArray['message']) ? $xmlToArray['message'] : 'Event token already consumed.')
						] ;
						$statusCode = 200 ;
						$statusText = "Ok" ;
						
						$this->response($response, $statusCode , $statusText);
						
						exit;
					
					
					}
					
					if ( $xmlToArray && isset($xmlToArray['type']) && $xmlToArray['type'] == "SUBSCRIPTION_CANCEL" &&  isset($xmlToArray['payload']['account']['accountIdentifier']) && $xmlToArray['payload']['account']['accountIdentifier'] )
					{
						/***prepare the data to inser to database***/
						
						$accountIdentifier 					= $xmlToArray['payload']['account']['accountIdentifier'] ;
						
						$getData							= $this->users->checkFromAccountIdentifier($accountIdentifier) ;
						
						
						if ( !$getData ) {
							$response   = [ 
								"success"   => "false",
								"errorCode" => "UNKNOWN_ERROR",
								"message"   => "Account Identifier not found"
							] ;
							$statusCode = 404 ;
							$statusText = "Ok" ;
							
							$this->response($response, $statusCode , $statusText);
						
							exit;
						} 
						
						$data['vodafone_market_place_id']  	= $getData['id'] ;
						$data['account_identifier']  		= $accountIdentifier ;
						$data['account_identifier_status'] 	= ( isset($xmlToArray['payload']['account']['status']) ? $xmlToArray['payload']['account']['status'] : '' ) ;
						$data['subscription_type'] 			= ( isset($xmlToArray['type']) ? $xmlToArray['type'] : '' ) ;
						$data['marketplace_baseUrl']		= ( isset($xmlToArray['marketplace']['baseUrl']) ? $xmlToArray['marketplace']['baseUrl'] : '' ) ;
						$data['marketplace_partner'] 		= ( isset($xmlToArray['marketplace']['partner']) ? $xmlToArray['marketplace']['partner'] : '' ) ;
						$data['flag'] 				 		= ( isset($xmlToArray['flag']) ? $xmlToArray['flag'] : '' ) ;
						$data['creator_email'] 			    = ( isset($xmlToArray['creator']['email']) ? $xmlToArray['creator']['email'] : '' ) ;
						$data['creator_firstName'] 	 		= ( isset($xmlToArray['creator']['firstName']) ? $xmlToArray['creator']['firstName'] : '' ) ;
						$data['creator_lastName'] 	 		= ( isset($xmlToArray['creator']['lastName']) ? $xmlToArray['creator']['lastName'] : '' ) ;
						$data['creator_openId'] 	  	    = ( isset($xmlToArray['creator']['openId']) ? $xmlToArray['creator']['openId'] : '' ) ;
						$data['creator_uuid'] 		        = ( isset($xmlToArray['creator']['uuid']) ? $xmlToArray['creator']['uuid'] : '' ) ;
						/*
						$data['order_editionCode'] 			= ( isset($xmlToArray['payload']['order']['editionCode']) ? $xmlToArray['payload']['order']['editionCode'] : '' ) ;
						$data['order_pricingDuration']		 = ( isset($xmlToArray['payload']['order']['pricingDuration']) ? $xmlToArray['payload']['order']['pricingDuration'] : '' ) ;
						$data['order_freeTrial_active']		 = ( isset($xmlToArray['payload']['order']['freeTrial']['active']) ? $xmlToArray['payload']['order']['freeTrial']['active'] : '' ) ;
						$data['payload_order_discountCode']	 = ( isset($xmlToArray['payload']['order']['discountCode']) ? $xmlToArray['payload']['order']['discountCode'] : '' ) ;
						
						
						
						if ( isset($xmlToArray['payload']['order']['item']) ) {
						
							$payloadOrderItems = ( isset($xmlToArray['payload']['order']['item']) ? $xmlToArray['payload']['order']['item'] : '' ) ;
							
							if ( $payloadOrderItems && is_array($payloadOrderItems) ) {
							
								$data['payload_order_item'] = json_encode($payloadOrderItems) ;
							
							}
							
						} elseif( isset($xmlToArray['payload']['order']['items']) ) {
						
							$payloadOrderItems = ( isset($xmlToArray['payload']['order']['items']) ? $xmlToArray['payload']['order']['items'] : '' ) ;
							
							if ( $payloadOrderItems && is_array($payloadOrderItems) ) {
							
								$data['payload_order_item'] = json_encode($payloadOrderItems) ;
							
							}
						}
						*/
						
						$data['subscription_status']		 = 'inactive' ;
						
						/***New code to insert the data not coming in payload***/
						
						$data['payload_company_name']	 = ( isset( $getData['payload_company_name'] ) ? $getData['payload_company_name'] : '' ) ;
						
						$getPreviousOrderModifications  = $this->users->getPreviousOrderModifications($accountIdentifier) ;
	
						if ($getPreviousOrderModifications) {
							$getData = $getPreviousOrderModifications ;
						} 
						
						$data['order_editionCode'] 	   = ( isset( $getData['order_editionCode'] ) ? $getData['order_editionCode'] : '' ) ;
						$data['order_pricingDuration'] = ( isset( $getData['order_pricingDuration'] ) ? $getData['order_pricingDuration'] : '' ) ;
						$data['order_freeTrial_active'] = ( isset( $getData['order_freeTrial_active'] ) ? $getData['order_freeTrial_active'] : '' ) ;
						$data['payload_order_discountCode'] 	   = ( isset( $getData['payload_order_discountCode'] ) ? $getData['payload_order_discountCode'] : '' ) ;
						$data['payload_order_item'] 	   = ( isset( $getData['payload_order_item'] ) ? $getData['payload_order_item'] : '' ) ;
						
						
						$data['billing_address_line1'] 	   = ( isset( $getData['billing_address_line1'] ) ? $getData['billing_address_line1'] : '' ) ;
						
						$data['billing_address_line2'] 	   = ( isset( $getData['billing_address_line2'] ) ? $getData['billing_address_line2'] : '' ) ;
						
						$data['billing_address_line3'] 	   = ( isset( $getData['billing_address_line3'] ) ? $getData['billing_address_line3'] : '' ) ;
						
						$data['billing_phone_number'] 	   = ( isset( $getData['billing_phone_number'] ) ? $getData['billing_phone_number'] : '' ) ;
						
						$data['billing_city'] 	   = ( isset( $getData['billing_city'] ) ? $getData['billing_city'] : '' ) ;
						
						$data['billing_postCode'] 	   = ( isset( $getData['billing_postCode'] ) ? $getData['billing_postCode'] : '' ) ;
						
						$data['billing_state'] 	   = ( isset( $getData['billing_state'] ) ? $getData['billing_state'] : '' ) ;
						
						
						
						
						/***New code to insert the data not coming in payload***/
						
						/***prepare the data to inser to database***/
						
						$insertData = $this->users->modifySubscriptionVodafoneMarketPlace($data) ;
						
						
						if ( $insertData ) {
							//fwrite($fp, "Id = " . $insertData.PHP_EOL);  
							
							$response   = [ 
								"success"   		=> "true",
								"message"   		=> "Subscription canceled."
							] ;
							
							$statusCode = 200 ;
							$statusText = "Ok" ;
							
						} else {
							$response   = [ 
								"success"   => "false",
								"errorCode" => "UNKNOWN_ERROR",
								"message"   => "Data not inserted in database."
							] ;
							
							$statusCode = 500 ;
							$statusText = "Internal Server Error" ;
						}
						
						
					} else {
						$response   = [ 
							"success"   => "false",
							"errorCode" => "INVALID_RESPONSE",
							"message"   => ""
						] ;
						$statusCode = 400 ;
						$statusText = "Bad Request" ;
					}
					
					
				} else {
					
					$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Token from Appdirect not found."
					] ;
					$statusCode = 200 ;
					$statusText = "Ok" ;
					
				}
				
				
				//~ fwrite($fp, "Errors = " . print_r($errorsEvent, TRUE).PHP_EOL);  
				//~ //fwrite($fp, "Result = " . print_r($result, true).PHP_EOL);  
				//~ fwrite($fp, "Result = " . $result .PHP_EOL);  
				//~ fwrite($fp, "ResultNew = " . print_r($xmlToArray, true).PHP_EOL);  
				//~ fwrite($fp, "Return Code = " . $returnCodeEvent.PHP_EOL);  
			} else {
				
			    $response   = [ 
							"success"   => "false",
							"errorCode" => "INVALID_RESPONSE",
							"message"   => "Event URL not found"
				] ;
				$statusCode = 422 ;
				$statusText = "Unprocessable Entity" ;
			}
			
			
		}
		//~ fwrite($fp, $text.PHP_EOL);  
		//~ fclose($fp); 
		$this->response($response, $statusCode , $statusText);
	}
	
	function noticeSubscription() {
		
		
		
		//$request = print_r($_REQUEST, TRUE) ;
		
		//~ $request1 = print_r($_POST, TRUE) ;
		//~ $request2 = print_r($_GET, TRUE) ;
		// $fp = fopen('/var/www/html/orbis/assets/bulkuploadfile/notice-request.php', 'a');//opens file in append mode  
		//fwrite($fp, $request.PHP_EOL);  
		//fwrite($fp, $request1.PHP_EOL);  
		//fwrite($fp, $request2.PHP_EOL);  
		//fwrite($fp, 'appending data'.PHP_EOL);  
		
		
		$response   = "" ;
		$statusCode = "" ;
		$statusText = "" ;
		
		if (!$this->oauth_server->verifyResourceRequest(OAuth2\Request::createFromGlobals())) {
			
			// if token not found or token is expired or any other error related to token
			// $this->oauth_server->getResponse()->send();
			
			
			$response   = [ 
							"success"   => "false",
							"errorCode" => "UNAUTHORIZED",
							"message"   => "Invalid token"
			] ;
			$statusCode = 401 ;
			$statusText = "Unauthorized" ;
			
			
		} else {
			
			
			$eventUrl = $this->input->get('eventUrl') ;
			
			if ( $eventUrl ) {
				
				//fwrite($fp, $eventUrl.PHP_EOL);
				
				$host = $this->appDirectUrl."oauth2/token" ;
				$username = $this->inboundClientId  ;
				$password = $this->inboundClientSecret ;
				
				$ch = curl_init($host);
				//curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
				//curl_setopt($ch, CURLOPT_HEADER, 1);
				curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
				curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password);
				curl_setopt($ch, CURLOPT_TIMEOUT, 30);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials&scope=ROLE_APPLICATION");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				$return = curl_exec($ch);
				
				
				if($return === false)
				{
					$curlError =  'Curl error: ' . curl_error($ch);
					
					$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Curl error for token."
					] ;
					$statusCode = 200 ;
					$statusText = "Ok" ;
					
					$this->response($response, $statusCode , $statusText);
					
					exit;
					
				}          
				
				/***catch curl error and status code***/
				$errors = curl_error($ch);  
				$returnCode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
				/***catch curl error and status code***/
				
				curl_close($ch);
				
				$return = json_decode($return); 
				
				
				if ( isset($return->access_token)  && $return->access_token ) {
				
				
					$bearerToken =  $return->access_token ;
					
					//fwrite($fp, $bearerToken.PHP_EOL);
					
					$headers = array(
						'Content-Type: application/json',
						sprintf('Authorization: Bearer %s', $bearerToken)
					);

					$curl = curl_init($eventUrl);
					
					curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

					$result = curl_exec($curl) ;
					
					if($result === false)
					{
						$curlErrorEvent =  'Curl error: ' . curl_error($curl);
						
						$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Curl error for Event Url."
						] ;
						$statusCode = 200 ;
						$statusText = "Ok" ;
						
						$this->response($response, $statusCode , $statusText);
						
						exit;
					
					}  
					 
					/***catch curl error and status code***/
					$errorsEvent 	 = curl_error($curl);  
					$returnCodeEvent = (int)curl_getinfo($curl, CURLINFO_HTTP_CODE);
					/***catch curl error and status code***/
				
					curl_close($curl);
					
					/***XML to array conversion***/
					
					$new = simplexml_load_string($result); 
  
					// Convert into json 
					$con = json_encode($new); 
					  
					// Convert into associative array 
					$xmlToArray = json_decode($con, true); 
					
					
					/***XML to array conversion***/
					
					if( isset($xmlToArray['code']) && ( $xmlToArray['code'] == "Gone" ||  $xmlToArray['code'] == "Not Found") ) {
					
						$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => ( isset($xmlToArray['message']) ? $xmlToArray['message'] : 'Event token already consumed.')
						] ;
						$statusCode = 200 ;
						$statusText = "Ok" ;
						
						$this->response($response, $statusCode , $statusText);
						
						exit;
					
					
					}
					
					if ( $xmlToArray && isset($xmlToArray['type']) && $xmlToArray['type'] == "SUBSCRIPTION_NOTICE" &&  isset($xmlToArray['payload']['account']['accountIdentifier']) && $xmlToArray['payload']['account']['accountIdentifier'] )
					{
						/***prepare the data to inser to database***/
						
						$accountIdentifier 					= $xmlToArray['payload']['account']['accountIdentifier'] ;
						
						$getData							= $this->users->checkFromAccountIdentifier($accountIdentifier) ;
						
						
						if ( !$getData ) {
							$response   = [ 
								"success"   => "false",
								"errorCode" => "UNKNOWN_ERROR",
								"message"   => "Account Identifier not found"
							] ;
							$statusCode = 404 ;
							$statusText = "Ok" ;
							
							$this->response($response, $statusCode , $statusText);
						
							exit;
						} 
						
						$data['vodafone_market_place_id']  	= $getData['id'] ;
						$data['account_identifier']  		= $accountIdentifier ;
						$data['account_identifier_status'] 	= ( isset($xmlToArray['payload']['account']['status']) ? $xmlToArray['payload']['account']['status'] : '' ) ;
						$data['subscription_type'] 			= ( isset($xmlToArray['type']) ? $xmlToArray['type'] : '' ) ;
						$data['marketplace_baseUrl']		= ( isset($xmlToArray['marketplace']['baseUrl']) ? $xmlToArray['marketplace']['baseUrl'] : '' ) ;
						$data['marketplace_partner'] 		= ( isset($xmlToArray['marketplace']['partner']) ? $xmlToArray['marketplace']['partner'] : '' ) ;
						$data['flag'] 				 		= ( isset($xmlToArray['flag']) ? $xmlToArray['flag'] : '' ) ;
						/* 
						 
						$data['creator_email'] 			    = ( isset($xmlToArray['creator']['email']) ? $xmlToArray['creator']['email'] : '' ) ;
						$data['creator_firstName'] 	 		= ( isset($xmlToArray['creator']['firstName']) ? $xmlToArray['creator']['firstName'] : '' ) ;
						$data['creator_lastName'] 	 		= ( isset($xmlToArray['creator']['lastName']) ? $xmlToArray['creator']['lastName'] : '' ) ;
						$data['creator_openId'] 	  	    = ( isset($xmlToArray['creator']['openId']) ? $xmlToArray['creator']['openId'] : '' ) ;
						$data['creator_uuid'] 		        = ( isset($xmlToArray['creator']['uuid']) ? $xmlToArray['creator']['uuid'] : '' ) ;
						$data['order_editionCode'] 			= ( isset($xmlToArray['payload']['order']['editionCode']) ? $xmlToArray['payload']['order']['editionCode'] : '' ) ;
						$data['order_pricingDuration']		 = ( isset($xmlToArray['payload']['order']['pricingDuration']) ? $xmlToArray['payload']['order']['pricingDuration'] : '' ) ;
						$data['order_freeTrial_active']		 = ( isset($xmlToArray['payload']['order']['freeTrial']['active']) ? $xmlToArray['payload']['order']['freeTrial']['active'] : '' ) ;
						$data['payload_order_discountCode']	 = ( isset($xmlToArray['payload']['order']['discountCode']) ? $xmlToArray['payload']['order']['discountCode'] : '' ) ;
						
						
						
						if ( isset($xmlToArray['payload']['order']['item']) ) {
						
							$payloadOrderItems = ( isset($xmlToArray['payload']['order']['item']) ? $xmlToArray['payload']['order']['item'] : '' ) ;
							
							if ( $payloadOrderItems && is_array($payloadOrderItems) ) {
							
								$data['payload_order_item'] = json_encode($payloadOrderItems) ;
							
							}
							
						} elseif( isset($xmlToArray['payload']['order']['items']) ) {
						
							$payloadOrderItems = ( isset($xmlToArray['payload']['order']['items']) ? $xmlToArray['payload']['order']['items'] : '' ) ;
							
							if ( $payloadOrderItems && is_array($payloadOrderItems) ) {
							
								$data['payload_order_item'] = json_encode($payloadOrderItems) ;
							
							}
						}
						*/
						
						$data['payload_notice_type']		 = ( isset($xmlToArray['payload']['notice']['type']) ? $xmlToArray['payload']['notice']['type'] : '' ) ;
						
						$data['subscription_status']		 = 'active' ;
						
						/***New code to insert the data not coming in payload***/
						
						$data['payload_company_name']	 = ( isset( $getData['payload_company_name'] ) ? $getData['payload_company_name'] : '' ) ;
						
						$getPreviousOrderModifications  = $this->users->getPreviousOrderModifications($accountIdentifier) ;
	
						if ($getPreviousOrderModifications) {
							$getData = $getPreviousOrderModifications ;
						} 
						
						$data['order_editionCode'] 	   = ( isset( $getData['order_editionCode'] ) ? $getData['order_editionCode'] : '' ) ;
						$data['order_pricingDuration'] = ( isset( $getData['order_pricingDuration'] ) ? $getData['order_pricingDuration'] : '' ) ;
						$data['order_freeTrial_active'] = ( isset( $getData['order_freeTrial_active'] ) ? $getData['order_freeTrial_active'] : '' ) ;
						$data['payload_order_discountCode'] 	   = ( isset( $getData['payload_order_discountCode'] ) ? $getData['payload_order_discountCode'] : '' ) ;
						$data['payload_order_item'] 	   = ( isset( $getData['payload_order_item'] ) ? $getData['payload_order_item'] : '' ) ;
						
						
						$data['creator_email'] 	   	   = ( isset( $getData['creator_email'] ) ? $getData['creator_email'] : '' ) ;
						$data['creator_firstName'] 	   = ( isset( $getData['creator_firstName'] ) ? $getData['creator_firstName'] : '' ) ;
						$data['creator_lastName'] 	   = ( isset( $getData['creator_lastName'] ) ? $getData['creator_lastName'] : '' ) ;
						$data['creator_openId'] 	   = ( isset( $getData['creator_openId'] ) ? $getData['creator_openId'] : '' ) ;
						$data['creator_uuid'] 	  	   = ( isset( $getData['creator_uuid'] ) ? $getData['creator_uuid'] : '' ) ;
						
						
						$data['billing_address_line1'] 	   = ( isset( $getData['billing_address_line1'] ) ? $getData['billing_address_line1'] : '' ) ;
						
						$data['billing_address_line2'] 	   = ( isset( $getData['billing_address_line2'] ) ? $getData['billing_address_line2'] : '' ) ;
						
						$data['billing_address_line3'] 	   = ( isset( $getData['billing_address_line3'] ) ? $getData['billing_address_line3'] : '' ) ;
						
						$data['billing_phone_number'] 	   = ( isset( $getData['billing_phone_number'] ) ? $getData['billing_phone_number'] : '' ) ;
						
						$data['billing_city'] 	   = ( isset( $getData['billing_city'] ) ? $getData['billing_city'] : '' ) ;
						
						$data['billing_postCode'] 	   = ( isset( $getData['billing_postCode'] ) ? $getData['billing_postCode'] : '' ) ;
						
						$data['billing_state'] 	   = ( isset( $getData['billing_state'] ) ? $getData['billing_state'] : '' ) ; 
						
						
						/***New code to insert the data not coming in payload***/
						
						
						
						
						
						/***prepare the data to inser to database***/
						
						$insertData = $this->users->modifySubscriptionVodafoneMarketPlace($data) ;
						
						
						if ( $insertData ) {
							//fwrite($fp, "Id = " . $insertData.PHP_EOL);  
							
							$response   = [ 
								"success"   		=> "true",
								"message"   		=> "Subscription canceled."
							] ;
							
							$statusCode = 200 ;
							$statusText = "Ok" ;
							
						} else {
							$response   = [ 
								"success"   => "false",
								"errorCode" => "UNKNOWN_ERROR",
								"message"   => "Data not inserted in database."
							] ;
							
							$statusCode = 500 ;
							$statusText = "Internal Server Error" ;
						}
						
						
					} else {
						$response   = [ 
							"success"   => "false",
							"errorCode" => "INVALID_RESPONSE",
							"message"   => ""
						] ;
						$statusCode = 400 ;
						$statusText = "Bad Request" ;
					}
					
					
				} else {
					
					$response   = [ 
							"success"   => "false",
							"errorCode" => "UNKNOWN_ERROR",
							"message"   => "Token from Appdirect not found."
					] ;
					$statusCode = 200 ;
					$statusText = "Ok" ;
					
				}
				
				
				//~ fwrite($fp, "Errors = " . print_r($errorsEvent, TRUE).PHP_EOL);  
				//~ //fwrite($fp, "Result = " . print_r($result, true).PHP_EOL);  
				//~ fwrite($fp, "Result = " . $result .PHP_EOL);  
				//~ fwrite($fp, "ResultNew = " . print_r($xmlToArray, true).PHP_EOL);  
				//~ fwrite($fp, "Return Code = " . $returnCodeEvent.PHP_EOL);  
			} else {
				
			    $response   = [ 
							"success"   => "false",
							"errorCode" => "INVALID_RESPONSE",
							"message"   => "Event URL not found"
				] ;
				$statusCode = 422 ;
				$statusText = "Unprocessable Entity" ;
			}
			
			
		}
		//~ fwrite($fp, $text.PHP_EOL);  
		//~ fclose($fp); 
		$this->response($response, $statusCode , $statusText);
	}
	
}
