<?php

Class Users extends CI_Model
{
	public $username;
	public $password;
	public $number;
	public $device_id;
	public $device_token;
	public $device_type;
	public $ref;
	public $ref_id;
	public $lat;
	public $long;
	public $token;
	public $status;
	public $otp;
	public $app_type;
	public $imei_no;
	//public $serial_number;
	public $carrier;
	public $model;
	public $version;
	public $app_version;
	public $app_name;

	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->mysql = $this->load->database('mysql',true);

	}


	function get_login_asm()
	{
		$this->odbc = $this->load->database('odbc',true);
		return $this->odbc->query("select * from CREATEAPPLOGIN('".$this->number."','".$this->otp."')")->result_array();
	}

	function get_login()
	{
		$query_mysql =  $this->mysql->select('*')->from('operators')->where([ 'number' => trim($this->number) ])->get()->first_row('array');
		if(  $query_mysql['ref']!="" )
		{
			return $this->mysql->select('ref,lindex, loginname,fullname, accesslevel,number,imei_no, otp, is_verified, lastin, lastout, custref, depot,type, logintype, costcentre , contractarea, office, emailaddress, createdate, termsagree')->from('operators')->where([ 'number' => trim($this->number)])->get()->first_row('array');
		}
	}

	// Update OTP
	function update_otp()
	{
		$data['otp'] = $this->otp;
		$this->mysql->where('ref', $this->ref);
		$this->mysql->update('operators', $data);
	}


	function verified_otp_asm()
	{
		$this->odbc = $this->load->database('odbc',true);
		return $this->odbc->query("select * from VERIFYAPPUSER('".$this->number."', '".$this->device_type."', '".$this->device_token."', '".$this->device_id."', '".$this->otp."', '".$this->app_type."') ")->result_array();
	}

	function verified_otp()
	{
		$get_result = $this->mysql->select('ref')->from('operators')->where([ 'number' => trim($this->number), 'otp' => $this->otp ])->get()->first_row('array');
		if( $get_result['ref'] )
		{
			$data['device_token'] = $this->device_token;
			$data['device_type'] = $this->device_type;
			$data['is_verified'] = '1';
			$data['lastin'] = date( 'Y-m-d H:i:s' );
			$this->mysql->where('ref', $get_result['ref'])->update('operators', $data);
		}

		return $get_result;
	}

	// update token of logged in user
	function update_user_token()
	{
		$data['token'] = $this->token;
		$data['lastin'] = date( 'Y-m-d H:i:s' );
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);
	}
	//ravi work starts : Also added imei variable at the top
	function update_user_device_token_type_imei()
	{
		$data['device_token'] 				= $this->device_token;
		$data['device_type'] 				= $this->device_type;
		$data['imei_no'] 					= $this->imei_no;
		$data['device_id'] 					= $this->device_id;
		//$data['serial_number_phone'] 		= $this->serial_number;
		$data['carrier'] 					= $this->carrier;
		$data['model'] 					    = $this->model;
		$data['version'] 					= $this->version;
		$data['app_version'] 				= $this->app_version;
		$data['app_name'] 					= $this->app_name;
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);
	}

	function logout_user()
	{
		$data['token'] = "";
		$data['device_token'] = "";
		$data['lastout'] = date('Y-m-d H:i:s');
		$data['otp'] = "0";
		$data['is_verified'] = "0";
		$this->mysql->where('number', $this->number);
		return $this->mysql->update('operators', $data);

	}

	function updateAppSettingsGetConfiguration($uniqueId, $number, $data){
		
		$checkDataExists  =  $this->mysql->select('uniqueId')->from('get_configuration')->where([ 'handset_number' => $number, 'uniqueId' =>  $uniqueId])->count_all_results() ;
	
		if ($checkDataExists > 0) {
			return $this->mysql->where([ 'handset_number' => $number, 'uniqueId' =>  $uniqueId])->update( 'get_configuration', $data );
		} else {
			return false;
		}
			
	}
	
	function get_user_template_settings($phoneNumber)
	{
		$query_mysql =  $this->mysql->select('*')->from('user_template_settings')->where([ 'phone' => trim($phoneNumber) ])->get()->first_row('array');
		$data = '' ;
		if ($query_mysql) {
			if ($query_mysql['template_id']) {
				$data =  $this->mysql->select('*')->from('ota_device_settings')->where([ 'id' => trim($query_mysql['template_id']) ])->get()->first_row('array');
			}
		}
		return $data ;
	}
	
	// To save the applied template settings

	function saveUserTemplateSettings($templateId, $phone, $gps_pos_criteria, $loginName, $deviceInfo) {
		
		$data = [] ;
		$query_mysql =  $this->mysql->select('*')->from('user_template_settings')->where([ 'phone' => trim($phone) ])->get()->first_row('array');
		
		if ($query_mysql) { // update if number already exists
			$data['template_id'] 	  =  $templateId;
			$data['gps_pos_criteria'] =  $gps_pos_criteria;
			$data['loginname'] 		  =  $loginName;
			$response = $this->mysql->where( 'phone', trim($phone) )->update( 'user_template_settings', $data );
			
			$response = $this->mysql->where( 'user_template_settings_id', trim($query_mysql['id']) )->update( 'iosDeviceInfo_user_template_settings', $deviceInfo );
		} else { // insert if number not exists
			$data['template_id'] 		=  $templateId;
			$data['phone'] 		 		=  $phone;
			$data['gps_pos_criteria'] 	=  $gps_pos_criteria;
			$data['loginname'] 			=  $loginName;
			$response = $this->mysql->insert('user_template_settings',$data);
			$insert_id = $this->mysql->insert_id();
			$deviceInfo['user_template_settings_id'] = $insert_id ;
			$response  = $this->mysql->insert('iosDeviceInfo_user_template_settings',$deviceInfo);
		}

		return $response ;
	}
	
	
	
	
	
    public function get_user_sent_notifications_by_title($phone) {
		$query = $this->mysql->select('t1.*, t2.id as compose_id, t2.from_message, t2.message, t2.title')
				->from('broadcast_message_user_details as t1')
				->join(' compose_message_details as t2', 't2.id = t1.compose_message_id')
				->where(['t1.phone' => $phone, 't1.delete_status' => '0'])
				->where("(t1.fcm_status='delivered' OR t1.fcm_status='read')")
				->order_by('t1.sent_at', 'desc')
				->limit(20, 0)
				->get()
				->result_array();
				
		return $query ;
	}
	
	public function get_message_body($message_compose_id, $message_broadcast_id) {
		 $data['read_status']  =  '1';
		 $data['fcm_status']  =   'read';
		 $this->mysql->where('id',  $message_broadcast_id)->update( 'broadcast_message_user_details', $data );
		
		$query_mysql =  $this->mysql->select('*')->from('compose_message_details')->where([ 'id' => trim($message_compose_id) ])->get()->first_row('array');
		return $query_mysql ;
	}
	
	public function delete_user_notifications($type, $column) {
		$data['delete_status']  =   '1' ;
		if ($type == "all") {
			$deleteStatus =  $this->mysql->where('phone',$column)->update('broadcast_message_user_details', $data);
		} else {
			$deleteStatus =  $this->mysql->where('id',$column)->update('broadcast_message_user_details', $data);
		}
		
		return $deleteStatus ; 
	}
	public function get_status_unread_messages_login($phone) {
			$query = $this->mysql->select('t1.*')
				->from('broadcast_message_user_details as t1')
				->where(['t1.phone' => $phone, 't1.delete_status' => '0', 't1.fcm_status' => 'delivered'])
				->order_by('t1.sent_at', 'desc')
				->limit(20, 0)
				->count_all_results() ;
				
			return $query ;
	}
	
	
	public function saveInfoHomesafeGeofnece($data) {
		
		$checkUser =  $this->mysql->select('id')->from('homesafe_geofencing_user_details')->where([ 'serial_number' => trim($data['serial_number']) ])->get()->first_row('array');

			if($checkUser) {
				return $this->mysql->where( 'id', $checkUser['id'] )->update( 'homesafe_geofencing_user_details', $data );
			} else {
				return $this->mysql->insert('homesafe_geofencing_user_details',$data);
			}
	}
	
	
	public function deleteHomesafeGeofnece($serialNumber) {
		return $this->mysql->where('serial_number',$serialNumber)->delete('homesafe_geofencing_user_details');
	}
	
	
	function get_user_geofence_settings($serialNumber)
	{
		return $this->mysql->select('*')->from('homesafe_geofencing_user_details')->where([ 'serial_number' => trim($serialNumber) ])->get()->first_row('array');
	}
	
	public function checkUserAddedForGeofence($serialNumber) {
		return $this->mysql->select('*')->from('users_added_for_geofencing')->where([ 'serial_number' => trim($serialNumber) ])->get()->first_row('array');
	}
	
	
	// ravi work ends


	function user_logout()
	{
		$data['token'] = " ";
		$data['lastout'] = date('Y-m-d H:i:s');
		$data['otp'] = "0";
		$data['is_verified'] = "0";
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);

	}

	function update_location()
	{
		$data['ref_id'] = $this->ref_id;
		$data['lat'] = $this->lat;
		$data['long'] = $this->long;
		$data['status'] = $this->status;
		$data['create_date'] = date('Y-m-d h:i:s');
		$this->mysql->insert('location', $data);
		return $insert_id = $this->mysql->insert_id();
	}


	function get_detail(){
		$this->odbc = $this->load->database('odbc',true);
		return $this->odbc->query("select * from WEB_GETALARMCONTACTS(000010)")->result_array();
	}

	function escalation(){
		$this->testasm = $this->load->database('test',true);
		$query = $this->testasm->query("select * from EXPORT_PORTAL_NUMBERS2")->result_array();
		debug($query );
		echo "Total rows: ".count($query);
		for( $i=0; $i<count($query); $i++ ){
			$data['ref'] = $query[$i]['PROPERTYREF'];
			$data['number	'] = $query[$i]['PHONENUMBER'];
			$data['loginname'] = $query[$i]['FORENAME'];
			$data['fullname'] = $query[$i]['FORENAME'];
			$data['surname	'] = $query[$i]['SURNAME'];
			$this->mysql->insert( 'export_portal_numbers' ,$data );
		}
		if( $this->mysql->insert_id() > 0 ){
			echo "<br>Database Synced";
		}
	}

	function get_operator_lindex($number){
		$query = $this->mysql->select('ref')->from('export_portal_numbers')->where('number',$number)->get();
		foreach( $query->result_array() as $row )
		{
			return $row['ref'];
		}
	}

	function escalation_detail($lindex){
		//$this->testasm = $this->load->database('test',true);
		$this->odbc = $this->load->database('odbc',true);
		return $this->odbc->query("select * from WEB_GETALARMCONTACTS(".$lindex.")")->result_array();
	}

	// function get_operator_lindex($lindex){
	// 	return $query = $this->mysql->select('*')->from('export_portal_numbers')->where('ref',$lindex)->get()->first_row('array');
	// }

	function get_phone_number($lindex)
	{
		return $this->mysql->select('*')->from('export_portal_numbers')->where('ref', $lindex)->get()->first_row();
	}

	function get_operator_detail($lindex)
	{
		return $this->mysql->select('*')->from('operators')->where('lindex', $lindex)->get()->first_row();
		echo $this->mysql->last_query();
	}

}
