$(document).ready(function() {

	var table = $('#datatable')
    .DataTable({
		"processing": true,
		"serverSide": true,
		//"ajax": "ajax.php",
		"ajax": {
			"type" : 'post',
			"url": base_url + "systems/getOTATemplateSetttingsNew",
		},
		"pageLength": 10,
		"bLengthChange": false,
		"ordering": false,
		language: {
				search: "",
				searchPlaceholder: "Search"
		},
		"columnDefs": [
			{ className: "firstColumn", "targets": [0] },
			{ className: "secondColumn", "targets": [1] },
			{ className: "thirdColumn", "targets": [2] }
		]
	});

	//check box functionality
	//to check/uncheck all
	$(document).on('click', "#checkUncheckALL", function() {

		if( $(this).prop('checked') == true ) {
			$('.__checkBoxTemplateListing').prop('checked', true);
			$("#__deleteBulkTemplates").addClass('canDelete');
		} else {
			$('.__checkBoxTemplateListing').prop('checked', false);
			$("#__deleteBulkTemplates").removeClass('canDelete');
		}

	});
	//to check/uncheck all

	//click on single check box
	$(document).on('click', ".__checkBoxTemplateListing", function() {

		$('#checkUncheckALL').prop('checked', false);
		var buttonClass = false ;
		$('input[type=checkbox][class=__checkBoxTemplateListing]:checked').each(function (index) {
			buttonClass = true ;
		})
		if (buttonClass) {
				$("#__deleteBulkTemplates").addClass('canDelete');
		} else {
			 $("#__deleteBulkTemplates").removeClass('canDelete');
		}

	});
	//click on single check box

	//click on delete button

	$(document).on("click", "#__deleteBulkTemplates", function() {
		var idString = '' ;
		$('input[type=checkbox][class=__checkBoxTemplateListing]:checked').each(function (index) {
			if( $(this).prop('checked') == true ) {
				var id = $(this).attr('id');
				if (index == 0) {
					idString += id ;
				} else {
					idString += ',' + id ;
				}
			}
		});

		if (idString != ""){
			swal({
				  title: "Are you sure?",
				  text: "You are about to delete the selected settings. Please confirm.",
				  icon: "warning",
				  buttons: true,
				  dangerMode: true,
			})
			.then(function(result) {
				  if (result) {
						$(".__Loader").css('display', 'block') ;
						$.ajax({
								  url: base_url + 'systems/deleteBulkTemplates' ,
								  type: 'post',
								  dataType: 'json',
								  data: { multipleIds: idString },
								  success:function(response){
									  $(".__Loader").css('display', 'none') ;
									  swal({
											  text: "Temaplates deleted successfully",
											  icon: "success",
											  button: "OK"
										})
										$('#checkUncheckALL').prop('checked', false);
										$("#__deleteBulkTemplates").removeClass('canDelete');
										$('#datatable').DataTable().draw();

								  }, error: function (jqXHR, exception) {
									   $(".__Loader").css('display', 'none') ;
										swal({
											  text: "Network error, please try again later.",
											  icon: "warning",
											  button: "CONTINUE"
										}) ;
								  }
						});
					}
			})
		} else {
			swal({
				  text: "Please check templates to delete.",
				  icon: "warning",
				  button: "CONTINUE"
			}) ;
		}

	});

	//click on delete button


	//check box functionality


	$(document).on('click', "#datatable #__allTemplatesListing .___Addcustomerlink", function() {

		var templateId = $(this).closest('tr').find(".__checkBoxTemplateListing").attr('id') ;
		$("#templateIdForActions").val(templateId);
		$('#CostCentreList').val('0');
		$(".ADDnotification").css('display', 'none') ;
		$("#ADDcostcentreMOdal").modal('show') ;
		return false;

	});

	//on change of costcentre select box

	$(document).on('change', "#CostCentreList", function() {
		var currentValue = $(this).val();
		var currentName  = $('#CostCentreList').find(':selected').data('costcentre');
		if (currentValue != 0 ){
			$("#selectedLevel").text(currentName) ;
			$(".ADDnotification").css('display', 'inline') ;
		} else {
			$(".ADDnotification").css('display', 'none') ;
		}
	});

	//on change of costcentre select box


	//on click of apply button to associate the cost centre

	$(document).on('click', "#__submitFilterOptions", function() {
		var costCentreId 	= $("#CostCentreList").val();
		var costCentreName  = $('#CostCentreList').find(':selected').data('costcentre');
		var templateId   	= $("#templateIdForActions").val();
		if (costCentreId != 0 ){
			$(".__Loader").css('display', 'block') ;
			$.ajax({
					  url: base_url + 'systems/updateAssociatedOTATemplateSettings' ,
					  type: 'post',
					  dataType: 'json',
					  data: { costCentreId: costCentreId, costCentreName: costCentreName, templateId: templateId },
					  success:function(response){
						  $(".__Loader").css('display', 'none') ;
						  swal({
								  text: "Temaplate associated successfully",
								  icon: "success",
								  button: "OK"
							})
							$('#datatable').DataTable().draw( false );
							$("#ADDcostcentreMOdal").modal('hide') ;

					  }, error: function (jqXHR, exception) {
						   $(".__Loader").css('display', 'none') ;
							swal({
								  text: "Network error, please try again later.",
								  icon: "warning",
								  button: "CONTINUE"
							}) ;
							$("#ADDcostcentreMOdal").modal('hide') ;
					  }
			});

		} else {
			alert("Please select the cost centre") ;
		}
	});

	//on click of apply button to associate the cost centre

	$(document).on('click', "#datatable #__allTemplatesListing tr", function(e) {
		if (!$(e.target).hasClass('__checkBoxTemplateListing')) {
			var templateId = $(this).closest('tr').find(".__checkBoxTemplateListing").attr('id') ;
			$("#templateIdForActions").val(templateId);
			getOTATemplateSettings(templateId) ;
		}

	});

	$(document).on('click', '.dontDoAnything', function() {
		return false;
	});

	// To change the on-off label for check boxes
	$(document).on('click', '.switchery', function() {
		var closest =$(this).closest('div').find('.__currentStatus');
		if(closest.val() == 'Access allowed' || closest.val() == 'Restricted') {
			if ( closest.val() == "Access allowed") {
				closest.val('Restricted') ;
			} else {
				closest.val('Access allowed') ;
			}
		} else {

			if ( closest.val() == "Off") {
				closest.val('On') ;
			} else {
				closest.val('Off') ;
			}
		}
		//For escalation
		var getAttrName = $(this).prev().attr('name') ;

		if ( getAttrName == "escalation_status" && closest.val() == "Access allowed") {
			$(closest).prev().text("Allowed") ;
		} else {
			$(closest).prev().text(closest.val()) ;
		}
	});
	// To change the on-off label for check boxes




	$(document).on("click", "#__resetUpdateSettings", function() {
		var templateId = $("#templateIdForActions").val();
		if (templateId) {
			getOTATemplateSettings(templateId) ;
		  }
	});


	// Update the data in database for template settings
	$(document).on('click', '#__submitOTADeviceSetings', function() {
		$(".__Loader").css('display', 'block') ;
		var minmandowntimerminutes  = $("#minmandowntimerminutes").val();
		var minmandowntimerseconds  = $("#minmandowntimerseconds").val();
		var maxmandowntimerminutes  = $("#maxmandowntimerminutes").val();
		var maxmandowntimerseconds  = $("#maxmandowntimerseconds").val();
		var minambertimerhours 		= $("#minambertimerhours").val();
		var minambertimerminutes 	= $("#minambertimerminutes").val();
		var maxambertimerhours  	= $("#maxambertimerhours").val();
		var gpsfrequencyupdate  	= $("#gpsfrequencyupdate").val();
		var gpsposcriteria  		= $("#gpsposcriteria").val();
		var templateId 				= $('#templateIdForActions').val() ;
		var coorrdinatesRefreshRate = $("#coorrdinatesRefreshRate").val();
		var ambertimerprealertminutes  = $("#ambertimerprealertminutes").val();
		var ambertimerprealertseconds  = $("#ambertimerprealertseconds").val();


		var maxambertimerminutes  	= $("#maxambertimerminutes").val();

		if (parseInt(minmandowntimerminutes) >= parseInt(maxmandowntimerminutes)) {
			$("#__errorName").text("Maximum man down timer minutes can't be less then Minimim man down timer minutes.");
			$('#__errorName').removeClass('dontShow');
			$(".__Loader").css('display', 'none') ;
			$('html, body').animate({
					scrollTop: $("#pushConfiguration").offset().top
			}, 1000);
			
		} else if(parseInt((minambertimerhours * 3600)) + parseInt((minambertimerminutes * 60)) < parseInt((ambertimerprealertminutes * 60)) + parseInt(ambertimerprealertseconds)) {
			$("#__errorName").text("Minimim amber timer can't be less then Amber Timer Pre - alerts.");
			$('#__errorName').removeClass('dontShow');
			$(".__Loader").css('display', 'none') ;
			$('html, body').animate({
					scrollTop: $("#pushConfiguration").offset().top
			}, 1000);
			
		} else if(parseInt((minambertimerhours * 60) + minambertimerminutes) >= parseInt((maxambertimerhours * 60) + maxambertimerminutes)) {
			$("#__errorName").text("Maximum amber timer  can't be less then Minimim amber timer.");
			$('#__errorName').removeClass('dontShow');
			$(".__Loader").css('display', 'none') ;
			$('html, body').animate({
					scrollTop: $("#pushConfiguration").offset().top
			}, 1000);
			
		} else  {
			$('#__errorName').addClass('dontShow');
					if( $('input:checkbox[name="sipStatus"]').prop('checked') == true ) {
						var sipStatus =  1 ;
					} else {
						var sipStatus =  0 ;
					}

					if( $('input:checkbox[name="triggersos"]').prop('checked') == true ) {
						var triggersos =  1 ;
					} else {
						var triggersos =  0 ;
					}

					var triggersoslevel  = $('#triggersoslevel').val() ;

					if( $('input:checkbox[name="ripalarm"]').prop('checked') == true ) {
						var ripalarm =  1 ;
					} else {
						var ripalarm =  0 ;
					}

					if( $('input:checkbox[name="falldetect"]').prop('checked') == true ) {
						var falldetect =  1 ;
					} else {
						var falldetect =  0 ;
					}

					var fallsenstivity  = $('#fallsenstivity').val() ;

					if( $('input:checkbox[name="mandownalert"]').prop('checked') == true ) {
						var mandownalert =  1 ;
					} else {
						var mandownalert =  0 ;
					}

					var mandowntimer  = $('#mandowntimer').val() ;

					if( $('input:checkbox[name="settings"]').prop('checked') == true ) {
						var settings =  1 ;
					} else {
						var settings =  0 ;
					}


					if( $('input:checkbox[name="escalation_status"]').prop('checked') == true ) {
						var escalation_status =  1 ;
					} else {
						var escalation_status =  0 ;
					}


					if( $('input:checkbox[name="sms"]').prop('checked') == true ) {
						var sms =  1 ;
					} else {
						var sms =  0 ;
					}

					if( $('input:checkbox[name="fingerprint_scanner"]').prop('checked') == true ) {
						var fingerprint_scanner =  1 ;
					} else {
						var fingerprint_scanner =  0 ;
					}

					if( $('input:checkbox[name="calendar"]').prop('checked') == true ) {
						var calendar =  1 ;
					} else {
						var calendar =  0 ;
					}

					if( $('input:checkbox[name="activity_based_locations"]').prop('checked') == true ) {
						var activity_based_locations =  1 ;
					} else {
						var activity_based_locations =  0 ;
					}


					$.ajax({
						  url: base_url + 'systems/updateOTATemplateSettings' ,
						  type: 'post',
						  dataType: 'json',
						  data: { sipStatus: sipStatus, triggersos: triggersos, triggersoslevel: triggersoslevel, ripalarm: ripalarm, falldetect: falldetect, fallsenstivity: fallsenstivity, minmandowntimerminutes: minmandowntimerminutes, minmandowntimerseconds: minmandowntimerseconds, maxmandowntimerminutes: maxmandowntimerminutes, maxmandowntimerseconds: maxmandowntimerseconds, minambertimerhours: minambertimerhours, minambertimerminutes: minambertimerminutes, maxambertimerhours: maxambertimerhours, maxambertimerminutes: maxambertimerminutes, gpsfrequencyupdate: gpsfrequencyupdate, templateId: templateId, settings: settings, gpsposcriteria: gpsposcriteria, 'sms': sms, 'fingerprint_scanner': fingerprint_scanner, 'calendar': calendar, activity_based_locations: activity_based_locations, coorrdinatesRefreshRate:coorrdinatesRefreshRate, escalation_status:escalation_status, ambertimerprealertminutes:ambertimerprealertminutes, ambertimerprealertseconds:ambertimerprealertseconds },
						  success:function(response){
							   $(".__Loader").css('display', 'none') ;
							  //getOTATemplateSettings(templateId) ;
							  swal({
									  text: "Temaplate settings updated successfully",
									  icon: "success",
									  button: "OK"
								})

						  }, error: function (jqXHR, exception) {
							   $(".__Loader").css('display', 'none') ;
								swal({
									  text: "Network error, please try again later.",
									  icon: "warning",
									  button: "CONTINUE"
								}) ;
						  }
					  });

		}
	});

	// Update the data in database for template settings

	//Delete Template Settings

	$(document).on('click', '#__deleteTemplateSettings', function() {

		var templateId = $('#templateIdForActions').val() ;
		if (templateId) {
			swal({
				  title: "Are you sure?",
				  text: "You want to delete template settings",
				  icon: "warning",
				  buttons: true,
				  dangerMode: true,
			})
			.then(function(result) {
				  if (result) {
					    $(".__Loader").css('display', 'block') ;
						$.ajax({
						  url: base_url + 'systems/deleteOTATemplateSettings' ,
						  type: 'post',
						  dataType: 'json',
						  data: { templateId: templateId } ,
						  success:function(response){
							var templateId = '' ;
							swal({
									  text: "Temaplate deleted successfully",
									  icon: "success",
									  button: "OK"
							})

							$('#datatable').DataTable().draw( false );
							$(".__Loader").css('display', 'none') ;
						  }
					  });

					  $("#OTAModal").modal('hide') ;
				   }
			 })
		  }
	});

	//Delete Template Settings

	//to change the select GPS Position Update Frequency based on GPS Positioning Criteria

			$(document).on("change", "#gpsposcriteria", function() {
			var currentValue = $(this).val();
			if(currentValue == 3 || currentValue == 4) {
				
				var selectHtml  = "" ;
				
				$("#_disabletextgps").removeClass('_disabletext') ;
				$("#gpsfrequencyupdate").removeAttr("disabled") ;
				
				if (currentValue == 3) {
					$("#__showHideActivityBasedLocation").hide() ;
					for (i = 1; i <= 60; i++) { 
						selectHtml += '<option value="' + i + '">' + i + ' Min</option>' ;
					}
				}
				
				if (currentValue == 4) {
					$("#__showHideActivityBasedLocation").show() ;
					for (i = 1; i <= 60; i++) { 
						selectHtml += '<option value="' + i + '">' + i + ' Min</option>' ;
					}
				}
				
				
				$("#gpsfrequencyupdate").html(selectHtml) ;
				
				//$("#gpsfrequencyupdate").val("1");
				//$('#gpsfrequencyupdate option[value="0"]').remove();
				//$('#gpsfrequencyupdate option[value="0"]').attr("disabled","disabled");
			} else {
				$("#__showHideActivityBasedLocation").hide() ;
				$("#_disabletextgps").addClass('_disabletext') ;
				$("#gpsfrequencyupdate").html("<option value='0' selected='selected'>0 Min</option>");
				//$('#gpsfrequencyupdate option[value="0"]').remove();
				//$("#gpsfrequencyupdate").prepend("<option value='0' selected='selected'>0 Min</option>");
				//$("#gpsfrequencyupdate").val("0");
				$("#gpsfrequencyupdate").attr('disabled','disabled');
			}
		});

	//to change the select GPS Position Update Frequency GPS Positioning Criteria


})


//To get the OTA push notifications template settings data function

function getOTATemplateSettings(templateId) {
	$(".__Loader").css('display', 'block') ;
	$.ajax({
		  url: base_url + 'systems/getSingleTemplateData' ,
		  type: 'post',
		  dataType: 'json',
		  data: { templateId: templateId } ,
		  success:function(response){
			  var otaTemplateData = '' ;
			  var switchElements = false ;
			  if ( response.error == 0 ) {

				  for( var k=0; k<response.data.length; k++ )
                  {

						var switchElements = true ;

						//SIP CALLING
						otaTemplateData +='<tr><<td><img class="_icon_ota __lowopacity" src="'+ base_url +'img/otaicon/call.png" alt=""> <span class="__lowopacity">SIP Calling</span> <span class="__ComingSoon">(Coming Soon)</span></td><td class="text-left"><div class="form-group  __lowopacity" data-toggle="tooltip" data-placement="top" title="SIP Calling is currently unavailable"><span class="__addpointerevent">' ;

						if (response.data[k].sip_call == 0) {
							otaTemplateData +='<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery" name="sipStatus" /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Off</label><input type="hidden" value="Off" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery" name="sipStatus" checked/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">On</label><input type="hidden" value="On" class="__currentStatus" />';
						}

						otaTemplateData += '</span></div></td></tr>' ;
						//SIP CALLING

						//TRIGGER SOS with press level
						 otaTemplateData +='<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/power.png" alt="">Trigger SOS<span class="__ComingSoon">(Not available in IOS devices)</span></td><td class="text-left"><div class="form-group">' ;

                         if (response.data[k].trigger_sos == 0) {
							otaTemplateData +='<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test1" name="triggersos"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Off</label><input type="hidden" value="Off" class="__currentStatus" />';
						} else{
							otaTemplateData +='<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test1" name="triggersos" checked /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">On</label><input type="hidden" value="On" class="__currentStatus" />';
						}
                        otaTemplateData += '</div><span class="float-right modelselectlabel"><label style="margin-top: -2px;" class="font-medium-6 text-bold-600 mr-1 float-left">Level<span class="_newtooltip" data-toggle="tooltip" data-placement="top" title="Having the level set to low will require more presses of the on/off button compared to if the level is set to high." data-original-title=""><i class="fa fa-info-circle"></i></span></label><select id="triggersoslevel" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="" data-original-title="" title=""><option value="1"' + (response.data[k].sos_press_level == 1 ? 'selected' : '' )   + '>Low</option><option value="2" ' + (response.data[k].sos_press_level == 2 ? 'selected' : '' )   + '>High</option></select></span></td></tr>';


						//TRIGGER SOS with press level

						//RIP ALARM

						otaTemplateData += '<tr><td><img class="_icon_ota __lowopacity" style="padding-top: 5px!important" src="'+ base_url +'img/otaicon/jack.png" alt=""><span class="__lowopacity">RIP Alarm </span><span class="__ComingSoon">(Coming Soon)</span></td><td class="text-left"><div class="__lowopacity form-group" data-toggle="tooltip" data-placement="top" title="RIP Alarm is currently unavailable"><span class="__addpointerevent"  style="margin-top: 6px;">';

                        if (response.data[k].rip_alarm == 0) {
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test2" name="ripalarm"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Off</label><input type="hidden" value="Off" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test2" name="ripalarm" checked /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">On</label><input type="hidden" value="On" class="__currentStatus" />';
						}

                        otaTemplateData += '</span></div></td></tr>';
                        //RIP ALARM

                        //Fall detect with senstivity

                        otaTemplateData += '<tr style="display:none"><td>Fall Detect</td><td class="text-center"><div class="form-group">';

                        if (response.data[k].fall_detect == 0) {
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test3" name="falldetect"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Off</label><input type="hidden" value="Off" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test3" name="falldetect" checked /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">On</label><input type="hidden" value="On" class="__currentStatus" />';
						}

                        otaTemplateData += '</div><span class="float-right modelselectlabel"><label class="font-medium-6 text-bold-600 mr-1 float-left">Sensitivity<span class="" data-toggle="tooltip" data-placement="top" title="" data-original-title=" High sensitivity will trigger Fall Detect Alarm on slightest of fall. Low sensitivity will trigger Alarm only if an intensive fall is detected."><i class="fa fa-info-circle"></i></span></label><select id="fallsenstivity" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="" data-original-title="" title="" aria-describedby="tooltip132516"><option value="1" ' + (response.data[k].fall_detect_senstivity == 1 ? 'selected' : '' )   + '>1 (Low)</option><option value="2" ' + (response.data[k].fall_detect_senstivity == 2 ? 'selected' : '' )   + '>2</option><option value="3" ' + (response.data[k].fall_detect_senstivity == 3 ? 'selected' : '' )   + '>3</option><option value="4" ' + (response.data[k].fall_detect_senstivity == 4 ? 'selected' : '' )   + '>4</option><option value="5" ' + (response.data[k].fall_detect_senstivity == 5 ? 'selected' : '' )   + '>5 (High)</option></select></span></td></tr>';

                        //Fall detect with senstivity

                        // Min MAN DOWN TIMER

						otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/min.png" alt="">Min Man Down Timer</td><td class="text-center"><div class="form-group"><select id="minmandowntimerminutes" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">' ;
						 for (var i = 1; i<=60; i++) {
								otaTemplateData += '<option value="' + i + '"' + (response.data[k].min_man_down_timer_minutes == i ? 'selected' : '' )  + ' >' + i + ' Min</option>' ;
						 }
                         otaTemplateData += '</select></div><div class="form-group"><select id="minmandowntimerseconds" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">';
                         for (var i = 0; i<60; i++) {
								otaTemplateData += '<option value="' + i + '"' + (response.data[k].min_man_down_timer_seconds == i ? 'selected' : '' )  + ' >' + i + ' Sec</option>' ;
						 }

						otaTemplateData += '</select></div></td></tr>' ;

                        // Min MAN DOWN TIMER

                        //Max Mandown Timer


                        otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/max.png" alt="">Max Man Down Timer</td><td class="text-center"><div class="form-group"><select id="maxmandowntimerminutes" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">';
                         for (var i = 1; i<=60; i++) {
								otaTemplateData += '<option value="' + i + '"' + (response.data[k].max_man_down_timer_minutes == i ? 'selected' : '' )  + ' >' + i + ' Min</option>' ;
						 }
                        otaTemplateData += '</select></div><div class="form-group"><select id="maxmandowntimerseconds" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">' ;
                        for (var i = 0; i<60; i++) {
								otaTemplateData += '<option value="' + i + '"' + (response.data[k].max_man_down_timer_seconds == i ? 'selected' : '' )  + ' >' + i + ' Sec</option>' ;
						 }
                       otaTemplateData += '</select></div></td></tr>';

                       // Max Mandown Timer

					   
					   //Amber Timer Pre Alerts
					   
					    otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/amber_timer_pre_alerts.png" alt="">Amber Timer Pre - alerts<span class="__ComingSoon">(Only applicable to Android App v1.1.0)</span></td><td class="text-center"><div class="form-group"><select id="ambertimerprealertminutes" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">';
                         for (var i = 1; i<=60; i++) {
								otaTemplateData += '<option value="' + i + '"' + (response.data[k].amber_timer_pre_alert_minutes == i ? 'selected' : '' )  + ' >' + i + ' Min</option>' ;
						 }
                        otaTemplateData += '</select></div><div class="form-group"><select id="ambertimerprealertseconds" name="priority" class="form-control ml-1" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">' ;
                        for (var i = 0; i<60; i++) {
								otaTemplateData += '<option value="' + i + '"' + (response.data[k].amber_timer_pre_alert_seconds == i ? 'selected' : '' )  + ' >' + i + ' Sec</option>' ;
						 }
                       otaTemplateData += '</select></div></td></tr>';
					   
					   
					   
					   //Amber Timer Pre Alerts
					   
					   
					   
                       //Min Amber Timer
                       otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/min.png" alt=""> Min Amber Timer</td><td class="text-center"><div class="form-group"><select id="minambertimerhours" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">';
						for (var i = 0; i<=12; i++) {
							otaTemplateData += '<option value="' + i + '"' + (response.data[k].min_amber_timer_hours == i ? 'selected' : '' )  + ' >' + i + ' Hour</option>' ;
						}

                       otaTemplateData += '</select></div><div class="form-group"><select id="minambertimerminutes" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">';
						for (var i = 0; i<60; i++) {
							otaTemplateData += '<option value="' + i + '"' + (response.data[k].min_amber_timer_minutes == i ? 'selected' : '' )  + ' >' + i + ' Min</option>' ;
						}
                       otaTemplateData += ' </select></div> </td></tr>' ;
                       //Min Amber Timer

                       //Max Amber Timer
						otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/max.png" alt=""> Max Amber Timer</td><td class="text-center"><div class="form-group"><select id="maxambertimerhours" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">';
                        for (var i = 0; i<=12; i++) {
							otaTemplateData += '<option value="' + i + '"' + (response.data[k].max_amber_timer_hours == i ? 'selected' : '' )  + ' >' + i + ' Hour</option>' ;
						}
                        otaTemplateData += '</select></div><div class="form-group"><select id="maxambertimerminutes" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308">';
                        for (var i = 0; i<60; i++) {
							otaTemplateData += '<option value="' + i + '"' + (response.data[k].max_amber_timer_minutes == i ? 'selected' : '' )  + ' >' + i + ' Min</option>' ;
						}
                        otaTemplateData += '</select></div></td></tr>';

                       //Max Amber Timer

					   //GPS Position Criteria
					    var toDisableGPSFrequency = '' ;
					    var classFrequency = '' ;
					   if (response.data[k].gps_pos_criteria == 1 || response.data[k].gps_pos_criteria == 2) {
							toDisableGPSFrequency = 'disabled' ;
							classFrequency = '_disabletext' ;
						}
						
						if (response.data[k].gps_pos_criteria != 4 ) {
							var showHideActivity  = "hideActivityText";
						} else {
							var showHideActivity  = "";
						}
						
					    otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/navigation.png" alt=""> GPS Positioning Criteria </td><td class="text-center"><div class="form-group"><select id="gpsposcriteria" name="gpsposcriteria" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308"><option value="1" ' + (response.data[k].gps_pos_criteria == "1" ? 'selected' : '' )  + '>Alarm Activation Only</option><option value="2" ' + (response.data[k].gps_pos_criteria == "2" ? 'selected' : '' )  + '>All Signals But No Timer</option><option value="3" ' + (response.data[k].gps_pos_criteria == "3" ? 'selected' : '' )  + '>All Signals And Timer</option><option value="4" ' + (response.data[k].gps_pos_criteria == "4" ? 'selected' : '' )  + '>Activity Based Locations</option></select><span class="__ComingSoonRight '+showHideActivity+'" id = "__showHideActivityBasedLocation">(Only applicable to Android App v1.1.0)</span></div></td></tr>';

					   //GPS Position Criteria

                       //GPS Frequency

                       otaTemplateData += '<tr><td><span id="_disabletextgps" class="'+classFrequency+'"> <img class="_icon_ota" src="'+ base_url +'img/otaicon/timer.png" alt="">GPS Position Update Frequency </span></td><td class="text-center"><div class="form-group"><select id="gpsfrequencyupdate" name="priority" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308"' + toDisableGPSFrequency + '>';
					
					   //~ for (var i = 0; i<60; i++) {
							//~ otaTemplateData += '<option value="' + i + '"' + (response.data[k].gps_update_frequ_minutes == i ? 'selected' : '' )  + ' >' + i + ' Min</option>' ;
						//~ }
						
						if (response.data[k].gps_pos_criteria == 3) {
						
							for (i = 1; i <= 60; i++) { 
								otaTemplateData += '<option value="' + i + '" ' + (response.data[k].gps_update_frequ_minutes == i ? 'selected' : '' )  + '>' + i + ' Min</option>' ;
							}
						} else if (response.data[k].gps_pos_criteria  == 4) {
						
							for (i = 1; i <= 60; i++) { 
								otaTemplateData += '<option value="' + i + '" ' + (response.data[k].gps_update_frequ_minutes == i ? 'selected' : '' )  + '>' + i + ' Min</option>' ;
							}
						} else {
								otaTemplateData += '<option value="0" selected="selected">0 Min</option>' ;
						}
						
						
                        otaTemplateData += '</select></div></td></tr>' ;

                       //GPS Frequency


						//Coordinates Refresh Rate

					    otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/gps_icon.png" alt=""> Coordinates Refresh Rate <span class="__ComingSoon">(Only applicable to Android App v1.1.0)</span></td><td class="text-center"><div class="form-group"><select id="coorrdinatesRefreshRate" name="coorrdinatesRefreshRate" class="form-control" data-toggle="tooltip" data-trigger="hover" data-placement="top" data-title="Timer" data-original-title="" title="" aria-describedby="tooltip547308"><option value="30" ' + (response.data[k].coorrdinates_refresh_rate == "30" ? 'selected' : '' )  + '>30 Sec</option><option value="35" ' + (response.data[k].coorrdinates_refresh_rate == "35" ? 'selected' : '' )  + '>35 Sec</option> <option value="40" ' + (response.data[k].coorrdinates_refresh_rate == "40" ? 'selected' : '' )  + '>40 Sec</option><option value="45" ' + (response.data[k].coorrdinates_refresh_rate == "45" ? 'selected' : '' )  + '>45 Sec</option> <option value="50" ' + (response.data[k].coorrdinates_refresh_rate == "50" ? 'selected' : '' )  + '>50 Sec</option> <option value="55" ' + (response.data[k].coorrdinates_refresh_rate == "55" ? 'selected' : '' )  + '>55 Sec</option><option value="60" ' + (response.data[k].coorrdinates_refresh_rate == "60" ? 'selected' : '' )  + '>60 Sec</option><option value="65" ' + (response.data[k].coorrdinates_refresh_rate == "65" ? 'selected' : '' )  + '>65 Sec</option><option value="70" ' + (response.data[k].coorrdinates_refresh_rate == "70" ? 'selected' : '' )  + '>70 Sec</option><option value="75" ' + (response.data[k].coorrdinates_refresh_rate == "75" ? 'selected' : '' )  + '>75 Sec</option><option value="80" ' + (response.data[k].coorrdinates_refresh_rate == "80" ? 'selected' : '' )  + '>80 Sec</option><option value="85" ' + (response.data[k].coorrdinates_refresh_rate == "85" ? 'selected' : '' )  + '>85 Sec</option><option value="90" ' + (response.data[k].coorrdinates_refresh_rate == "90" ? 'selected' : '' )  + '>90 Sec</option></select></div></td></tr>';

					   //Coordinates Refresh Rate

                       //Settings
						otaTemplateData +='<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/login.png" alt="">Allow Users to Access Settings</td><td class="text-left"><div class="form-group" style="padding-top: 7px;">' ;

						if (response.data[k].settings == 0) {
							otaTemplateData +='<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test4" name="settings"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Restricted</label><input type="hidden" value="Restricted" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test4" name="settings" checked/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Access allowed</label><input type="hidden" value="Access allowed" class="__currentStatus" />';
						}

						otaTemplateData += '</div></td></tr>' ;
						//Settings

						//Create/Update and Delete escalations

						otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/createUpdate.png" alt=""><span style="float:left; width: 205px;">Create / Update and Delete Escalations</span></td><td class="text-center" style="vertical-align: top!important;"><div class="form-group">';

                        if (response.data[k].escalation_status == 0) {
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test9" name="escalation_status"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Restricted</label><input type="hidden" value="Restricted" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test9" name="escalation_status" checked /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Access allowed</label><input type="hidden" value="Access allowed" class="__currentStatus" />';
						}

                        otaTemplateData += '</div></td></tr>';

                        //Create/Update and Delete escalations




						//SMS

						otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/email.png" alt="">SMS Signalling</td><td class="text-center"><div class="form-group" style="padding-top: 7px;">';

                        if (response.data[k].sms == 0) {
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test5" name="sms"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Off</label><input type="hidden" value="Off" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test5" name="sms" checked /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">On</label><input type="hidden" value="On" class="__currentStatus" />';
						}

                        otaTemplateData += '</div></td></tr>';
                        //SMS

						//Fingerprint Scanner

						otaTemplateData += '<tr><td><img class="_icon_ota" src="'+ base_url +'img/otaicon/evidence.png" alt="">Fingerprint Lock</td><td class="text-center"><div class="form-group" style="padding-top: 7px;">';

                        if (response.data[k].finger_print_lock == 0) {
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test6" name="fingerprint_scanner"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Off</label><input type="hidden" value="Off" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test6" name="fingerprint_scanner" checked /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">On</label><input type="hidden" value="On" class="__currentStatus" />';
						}

                        otaTemplateData += '</div></td></tr>';
                        //Fingerprint Scanner

						//Calendar

						otaTemplateData += '<tr><td><img class="_icon_ota __lowopacity" src="'+ base_url +'img/otaicon/calendar.png" alt=""><span class="__lowopacity">Calendar Integration</span><span class="__ComingSoon">(Coming Soon)</span></td><td class="text-center"><div class="form-group __lowopacity" data-toggle="tooltip" data-placement="top" title="Calendar Integration is currently unavailable" style="padding-top: 7px;"><span class="__addpointerevent">';

                        if (response.data[k].calendar == 0) {
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test7" name="calendar"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Off</label><input type="hidden" value="Off" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test7" name="calendar" checked /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">On</label><input type="hidden" value="On" class="__currentStatus" />';
						}

                        otaTemplateData += '</span></div></td></tr>';
                        //Calendar


                        //Activity Based Locations

						otaTemplateData += '<tr style="display:none"><td><img class="_icon_ota menwalkicon" src="'+ base_url +'img/otaicon/walk.png" alt="">Activity Based Locations</td><td class="text-center"><div class="form-group" style="padding-top: 7px;">';

                        if (response.data[k].activity_based_locations == 0) {
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test8" name="activity_based_locations"/><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">Off</label><input type="hidden" value="Off" class="__currentStatus" />';
						} else{
							otaTemplateData += '<input type="checkbox" id="switcherySize11" data-size="sm" class="switchery test8" name="activity_based_locations" checked /><label for="switcherySize11" class="font-medium-6 text-bold-600 ml-1 dontDoAnything">On</label><input type="hidden" value="On" class="__currentStatus" />';
						}

                        otaTemplateData += '</div></td></tr>';
                        //Activity Based Locations

				  }
				  $("#__otaTemplateSettingsData").html(otaTemplateData);
				  $("#__templateNameHeading").text('(' + response.data[0].device_settings_name + ')');
				  if (switchElements) {
					var elem = document.querySelector('.switchery');
					var init = new Switchery(elem);

					var elem1 = document.querySelector('.switchery.test1');
					var init1 = new Switchery(elem1);

					var elem2 = document.querySelector('.switchery.test2');
					var init2 = new Switchery(elem2);

					var elem3 = document.querySelector('.switchery.test3');
					var init3 = new Switchery(elem3);

					var elem4 = document.querySelector('.switchery.test4');
					var init4 = new Switchery(elem4);

					var elem5 = document.querySelector('.switchery.test5');
					var init5 = new Switchery(elem5);

					var elem6 = document.querySelector('.switchery.test6');
					var init6 = new Switchery(elem6);

					var elem7 = document.querySelector('.switchery.test7');
					var init7 = new Switchery(elem7);

					var elem8 = document.querySelector('.switchery.test8');
					var init8 = new Switchery(elem8);

					var elem9 = document.querySelector('.switchery.test9');
					var init9 = new Switchery(elem9);

				  }
				  $(".__Loader").css('display', 'none') ;
				  $("#hidedataTab").css('display', 'block') ;
				  $("#hideActionButtons").css('display', 'block') ;
				  $("#OTAModal").modal('show') ;

			  } else if(response.error == 1) {
				 $(".__Loader").css('display', 'none') ;
				 $("#hideActionButtons").css('display', 'none') ;
				 $("#__otaTemplateSettingsData").html('<tr><td>No Data Found</td></tr>');
				 $("#hidedataTab").css('display', 'block') ;
				 $("#OTAModal").modal('show') ;
			  }


		  }, error: function (jqXHR, exception) {
				 $(".__Loader").css('display', 'none') ;
				 swal({
						  text: "Network error, please try again later.",
						  icon: "warning",
						  button: "CONTINUE"
					}) ;
		  }
	 });
}

//To get the OTA push notifications template settings data function
