<?php

namespace uncanny_learndash_groups;


/**
 * Class Database
 * @package uncanny_learndash_groups
 */
class Database {
	public static $group_tbl = 'ulgm_group_details';
	public static $group_codes_tbl = 'ulgm_group_codes';

	/**
	 * Database constructor.
	 */
	function __construct() {
		if ( self::check_if_table_exists() ) {
			self::alter_db_table();
		}
	}

	/**
	 *
	 */
	public static function alter_db_table() {
		$previously_modified = get_option( 'ulgm_table_altered', 0 );
		if ( 0 === $previously_modified ) {
			global $wpdb;
			$results = $wpdb->get_var( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '{$wpdb->prefix}" . self::$group_codes_tbl . "' AND COLUMN_NAME = 'code_status' AND TABLE_SCHEMA = '" . DB_NAME . "'" );
			if ( ! $results ) {
				$wpdb->query( "ALTER TABLE {$wpdb->prefix}" . self::$group_codes_tbl . " ADD code_status VARCHAR(50) DEFAULT 'available'" );
			}
			update_option( 'ulgm_table_altered', 1 );
		}

		$previously_modified = get_option( 'ulgm_details_table_altered', 0 );
		if ( 0 === $previously_modified ) {
			global $wpdb;
			$results = $wpdb->get_var( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '{$wpdb->prefix}" . self::$group_tbl . "' AND COLUMN_NAME = 'ld_group_id' AND TABLE_SCHEMA = '" . DB_NAME . "'" );
			if ( ! $results ) {
				$wpdb->query( "ALTER TABLE {$wpdb->prefix}" . self::$group_tbl . " ADD ld_group_id bigint(20) DEFAULT 0" );
			}
			update_option( 'ulgm_details_table_altered', 1 );
		}

		$previously_modified = get_option( 'ulgm_codes_table_email_altered', 0 );
		if ( 0 === $previously_modified ) {
			global $wpdb;
			$results = $wpdb->get_var( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '{$wpdb->prefix}" . self::$group_codes_tbl . "' AND COLUMN_NAME = 'user_email'  AND TABLE_SCHEMA = '" . DB_NAME . "'" );
			if ( ! $results ) {
				$wpdb->query( "ALTER TABLE {$wpdb->prefix}" . self::$group_codes_tbl . " ADD user_email varchar(100)" );
			}
			update_option( 'ulgm_codes_table_email_altered', 1 );
		}
	}

	/**
	 * @return false|int
	 */
	public static function check_if_table_exists() {
		global $wpdb;
		$qry = "SHOW TABLES LIKE '{$wpdb->prefix}" . self::$group_tbl . "';";

		return $wpdb->query( $qry );
	}

	/**
	 *
	 */
	public static function reset_data() {
		global $wpdb;
		$wpdb->query( "TRUNCATE {$wpdb->prefix}" . self::$group_tbl );
		$wpdb->query( "TRUNCATE {$wpdb->prefix}" . self::$group_codes_tbl );
	}

	/**
	 *
	 */
	public static function drop_tables() {
		global $wpdb;
		$wpdb->query( "DROP TABLE {$wpdb->prefix}" . self::$group_tbl );
		$wpdb->query( "DROP TABLE {$wpdb->prefix}" . self::$group_codes_tbl );
	}

	/**
	 * @return null
	 */
	public static function create_tables() {
		if ( self::check_if_table_exists() ) {
			return null;
		}
		global $wpdb;
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE  {$wpdb->prefix}" . self::$group_tbl . "  (
		  			ID bigint(20) NOT NULL AUTO_INCREMENT,
					user_id bigint(20),
					order_id bigint(20),
					group_id bigint(20),
					group_name LONGTEXT,
					issue_date datetime NOT NULL,
					issue_count int(20),
					issue_max_count int(20),
					ld_group_id bigint(20) DEFAULT 0,
					used_code int(20) NOT NULL DEFAULT '0',
					PRIMARY KEY (ID)
		) $charset_collate;";

		dbDelta( $sql );

		$sql = "CREATE TABLE {$wpdb->prefix}" . self::$group_codes_tbl . " (
					ID bigint(20) NOT NULL AUTO_INCREMENT,
					group_id bigint(20),
					code LONGTEXT NOT NULL,
					used_date datetime,
					student_id bigint(20),
					user_email varchar(100),
					code_status VARCHAR(50) DEFAULT 'available',
					PRIMARY KEY (ID)
				) $charset_collate;";
		//Utilities::log( $sql, '$sql', true );
		dbDelta( $sql );

		update_option( 'ulgm_table_altered', 1 );

	}

	/**
	 * @param $attr
	 * @param $codes
	 *
	 * @return int
	 */
	public static function add_codes( $attr, $codes ) {
		if ( ! self::check_if_table_exists() ) {
			self::create_tables();
		}

		self::alter_db_table();

		global $wpdb;

		$now = current_time( 'mysql' );
		$wpdb->insert( $wpdb->prefix . self::$group_tbl,
			array(
				'user_id'         => $attr['user_id'],
				'order_id'        => $attr['order_id'],
				'ld_group_id'     => $attr['group_id'],
				'group_name'      => $attr['group_name'],
				'issue_date'      => $now,
				'issue_count'     => $attr['qty'],
				'issue_max_count' => $attr['qty'],
			),
			array(
				'%d',
				'%d',
				'%d',
				'%s',
				'%s',
				'%d',
				'%d',
			)
		);

		$code_group_id = $wpdb->insert_id;
		if ( count( $codes ) > 2500 ) {
			$chunks = array_chunk( $codes, 2500 );
			if ( $chunks ) {
				$add_codes = [];
				foreach ( $chunks as $chunk ) {
					if ( is_array( $chunk ) ) {
						foreach ( $chunk as $co ) {
							$add_codes[] = "(" . intval( $code_group_id ) . " ,'{$co}', 'available' )";
						}
					} else {
						$add_codes[] = "(" . intval( $code_group_id ) . " ,'{$chunk}')";
					}
				}
				if ( $add_codes ) {
					$q = "INSERT INTO {$wpdb->prefix}" . self::$group_codes_tbl . " (`group_id`, `code`, `code_status`) VALUES " . implode( ',', $add_codes );
					$wpdb->query( $q );
				}
			}
		} else {
			$add_codes = [];
			if ( $codes ) {
				foreach ( $codes as $k => $chunk ) {
					$add_codes[] = "(" . intval( $code_group_id ) . ",'{$chunk}', 'available' )";
				}
				if ( $add_codes ) {
					$q = "INSERT INTO {$wpdb->prefix}" . self::$group_codes_tbl . " (`group_id`, `code`, `code_status`) VALUES " . implode( ',', $add_codes );
					$wpdb->query( $q );
				}
			}
		}


		return $code_group_id;
	}

	/**
	 * @param $attr
	 * @param $codes
	 */
	public static function add_additional_codes( $attr, $codes ) {
		global $wpdb;
		self::alter_db_table();
		$code_group_id = $attr['code_group_id'];
		for ( $i = 0; $i < $attr['qty']; $i ++ ) {
			$wpdb->insert( $wpdb->prefix . self::$group_codes_tbl, array(
				'group_id'    => intval( $code_group_id ),
				'code'        => $codes[ $i ],
				'code_status' => 'available',
			) );
		}

		$wpdb->query( $wpdb->prepare( "UPDATE {$wpdb->prefix}" . SharedFunctions::$db_group_tbl . " SET issue_count = issue_count + %d, issue_max_count = issue_max_count + %d WHERE ID = %d", absint( $attr['qty'] ), absint( $attr['qty'] ), absint( $code_group_id ) ) );
	}

	/**
	 * @return int
	 */
	public static function get_random_order_number() {
		$order_id = rand( 99999, 999999 );
		//Confirm if the order is a duplicate number
		global $wpdb;
		$result = $wpdb->get_var( "SELECT order_id $wpdb->prefix" . self::$group_tbl . " WHERE order_id = $order_id" );
		//return new order id if not a duplicate
		if ( empty( $result ) ) {
			return (int) $order_id;
		}
		//return to function to get a new number
		self::get_random_order_number();
	}

}