<?php
/**
 * Plugin Name: Uncanny Continuing Education Credits
 * Description: Track CPD/CEU credits for your LearnDash courses.
 * Version: 3.0.4
 * Author: Uncanny Owl
 * Author URI: www.uncannyowl.com
 * Plugin URI: www.uncannyowl.com/uncanny-continuing-education-credits/
 * Text Domain: uncanny-ceu
 * Domain Path: /languages
 */


namespace uncanny_ceu;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class UncannyLearnDashGroupManagement
 * @package uncanny_learndash_group_management
 */
class InitializePlugin {

	/**
	 * The plugin name
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	private $plugin_name = 'Uncanny Continuing Education Credits';

	/**
	 * The plugin name acronym
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	private $plugin_prefix = 'ceu';

	/**
	 * The plugin version number
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	private $plugin_version = '3.0.4';

	/**
	 * The full path and filename
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	private $path_to_plugin_file = __FILE__;

	/**
	 * Allows the debugging scripts to initialize and log them in a file
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	private $log_debug_messages = false;

	/**
	 * The instance of the class
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      Object
	 */
	private static $instance = null;


	/**
	 * class constructor
	 */
	private function __construct() {

		if ( false === WP_DEBUG ) {
			error_reporting( 0 );
		}

		add_action( 'init', array( $this, 'uncanny_ceu_text_domain' ) );

		// Load Utilities
		$this->initialize_utilities();

		// Load Configuration
		$this->initialize_config();

		// Load the plugin files
		$this->boot_plugin();

	}

	/**
	 * Creates singleton instance of class
	 *
	 * @since 1.0.0
	 *
	 * @return InitializePlugin $instance The InitializePlugin Class
	 */
	public static function get_instance() {

		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Initialize Static singleton class that has shared function and variables that can be used anywhere in WP
	 *
	 * @since 1.0.0
	 */
	private function initialize_utilities() {

		include_once( dirname( __FILE__ ) . '/src/utilities.php' );
		Utilities::set_date_time_format();

	}

	/**
	 * Initialize Static singleton class that configures all constants, utilities variables and handles activation/deactivation
	 *
	 * @since 1.0.0
	 */
	private function initialize_config() {

		include_once( dirname( __FILE__ ) . '/src/config.php' );
		$config_instance = Config::get_instance();

		$plugin_name = apply_filters( $this->plugin_prefix . '_plugin_name', $this->plugin_name );

		$config_instance->configure_plugin_before_boot( $plugin_name, $this->plugin_prefix, $this->plugin_version, $this->path_to_plugin_file, $this->log_debug_messages );

	}

	/**
	 * Initialize Static singleton class auto loads all the files needed for the plugin to work
	 *
	 * @since 1.0.0
	 */
	private function boot_plugin() {
		// Add settings link on plugin page
		$uncanny_learndash_ceu_plugin_basename = plugin_basename( __FILE__ );

		add_filter( 'plugin_action_links_' . $uncanny_learndash_ceu_plugin_basename, array(
			$this,
			'uncanny_learndash_toolkit_pro_plugin_settings_link'
		) );

		include_once( dirname( __FILE__ ) . '/src/boot.php' );
		Boot::get_instance();

	}

	// Allow Translations to be loaded
	public function uncanny_ceu_text_domain() {
		load_plugin_textdomain( 'uncanny-ceu', false, basename( dirname( __FILE__ ) ) . '/languages/' );
	}

	/**
	 * @param $links
	 *
	 * @return mixed
	 */
	function uncanny_learndash_toolkit_pro_plugin_settings_link( $links ) {
		$settings_link = '<a href="' . admin_url( 'admin.php?page=uncanny-ceu-license' ) . '">' . __( 'Licensing', 'uncanny-ceu' ) . '</a>';
		array_unshift( $links, $settings_link );
		$settings_link = '<a href="' . admin_url( 'admin.php?page=uncanny-ceu' ) . '">' . __( 'Settings', 'uncanny-ceu' ) . '</a>';
		array_unshift( $links, $settings_link );

		return $links;
	}
}

// Let's run it
InitializePlugin::get_instance();