<?php

namespace uncanny_ceu;

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<div class="wrap">
    <div class="ucec ucec-report">
        <?php 

        // Add admin header and tabs
        $tab_active = 'uncanny-ceu-report';
        include Utilities::get_template( 'admin-header.php' );

        ?>

        <div class="ucec-report-toolbar">
            <div class="ucec-report-filters">
                <form method="GET">
                    <input type="hidden" value="<?php echo $_GET[ 'page' ]; ?>" name="page">

                    <div class="ucec-report-filter ucec-report-filter--dates">
                        <input type="hidden" name="start_date" id="ucec-date-range-custom-start" value="<?php echo $_GET[ 'start_date' ]; ?>">
                        <input type="hidden" name="end_date" id="ucec-date-range-custom-end" value="<?php echo $_GET[ 'end_date' ]; ?>">

                        <select name="date" id="ucec-date-range" class="ucec-report-select ucec-report-filter__select">
                            <?php echo BackendCourseReport::get_date_dropdown(); ?>
                        </select>
                    </div>
                    <div class="ucec-report-filter ucec-report-filter--users">
                        <select name="user" id="ucec-users" class="ucec-report-select ucec-report-filter__select">
                            <?php echo BackendCourseReport::get_users_dropdown(); ?>
                        </select>
                    </div>
                    <div class="ucec-report-filter ucec-report-filter--groups">
                        <select name="group" id="ucec-groups" class="ucec-report-select ucec-report-filter__select">
                            <?php echo BackendCourseReport::get_groups_dropdown(); ?>
                        </select>
                    </div>

                    <div class="ucec-report-filter ucec-report-filter--submit">
                        <button type="submit" class="ucec-btn ucec-btn--secondary">
                            <?php _e( 'Filter', 'uncanny-ceu' ); ?>
                        </button>
                    </div>
                </form>
            </div>
            <div class="ucec-report-actions">
                <div id="ucec-report-export-csv" class="ucec-btn ucec-btn--secondary">
                    <?php _e( 'Export CSV', 'uncanny-ceu' ); ?>
                </div>
            </div>
        </div>
            
        <div class="ucec-report-results">
            
            <?php if ( BackendCourseReport::$users_ceus ){ ?>

            <table id="ucec-course-report" class="ucec-report-results__table" data-csvfilename="<?php printf( '%s - %s', __( 'Course Report', 'uncanny-ceu' ), date( 'Y-m-j g i A' ) ); ?>">
                <thead class="ucec-report-results-table__thead">
                    <tr class="ucec-report-results-table__tr">
                        <th class="ucec-report-header-cell ucec-report-header-cell--user">
                            <?php _e( 'User', 'uncanny-ceu' ); ?>
                        </th>
                        <th class="ucec-report-header-cell ucec-report-header-cell--course">
                            <?php _e( 'Course', 'uncanny-ceu' ); ?>
                        </th>
                        <th class="ucec-report-header-cell ucec-report-header-cell--date">
                            <?php _e( 'Date', 'uncanny-ceu' ); ?>
                        </th>
                        <th class="ucec-report-header-cell ucec-report-header-cell--ceus-earned">
                            <?php echo get_option( 'credit_designation_label_plural', __( 'CEU', 'uncanny-ceu' ) ); ?>
                        </th>
                        <th class="ucec-report-header-cell ucec-report-header-cell--total">
                            <?php _e( 'Total', 'uncanny-ceu' ); ?>
                        </th>
                    </tr>
                </thead>
                <tbody class="ucec-report-results-table__tbody">
                    <?php foreach ( BackendCourseReport::$users_ceus as $entry ){ ?>

                        <tr class="ucec-report-results-table__tr">
                            <td class="ucec-report-body-cell ucec-report-body-cell--user">
                                <?php

                                /**
                                 * We're doing this so DataTables uses this when sorting instead of the avatar's URL
                                 */

                                ?>
                                <span class="ucec-report-datatables-hidden">
                                    <?php echo $entry[ 'first_name' ] . ' ' . $entry[ 'last_name' ]; ?>
                                </span>

                                <div class="ucec-report-cell-user">
                                    <div class="ucec-report-cell-user__avatar">
                                        <img src="<?php echo $entry[ 'avatar' ]; ?>" alt="<?php printf( __( "%s's avatar", 'uncanny-ceu' ), $entry[ 'first_name' ] ); ?>" class="ucec-report-cell-user__avatar-img">
                                    </div>
                                    <div class="ucec-report-cell-user__info">
                                        <div class="ucec-report-cell-user__name">
                                            <a href="<?php echo get_edit_user_link( $entry[ 'user_id' ] ); ?>" target="_blank" class="ucec-report-external-link"><?php echo $entry[ 'first_name' ]; ?> <?php echo $entry[ 'last_name' ]; ?></a>
                                        </div>
                                        <div class="ucec-report-cell-user__email">
                                            <?php echo $entry[ 'email' ]; ?>
                                        </div>
                                    </div>
                                </div>                                
                            </td>
                            <td class="ucec-report-body-cell ucec-report-body-cell--course">
                                <div class="ucec-report-cell-course">
                                    <a href="<?php echo get_the_permalink( $entry[ 'course_id' ] ); ?>" target="_blank" class="ucec-report-external-link"><?php echo $entry[ 'ceu_title' ]; ?></a>
                                </div>
                            </td>
                            <td class="ucec-report-body-cell ucec-report-body-cell--date">
                                 <?php

                                /**
                                 * We're doing this so DataTables uses this when sorting instead of the avatar's URL
                                 */

                                ?>
                                <span class="ucec-report-datatables-hidden">
                                    <?php echo $entry[ 'ceu_date' ]; ?>
                                </span>

                                <div class="ucec-report-cell-date-and-time">
                                    <div class="ucec-report-cell-date-and-time__date">
                                        <?php echo date( 'F d, Y ', $entry[ 'ceu_date' ] ); ?>
                                    </div>
                                    <div class="ucec-report-cell-date-and-time__time">
                                        <?php echo date( 'g:i A', $entry[ 'ceu_date' ] ); ?>
                                    </div>
                                </div>

                                
                            </td>
                            <td class="ucec-report-body-cell ucec-report-body-cell--ceus-earned">
                                <?php echo $entry[ 'ceu_earned' ]; ?>
                            </td>
                            <td class="ucec-report-body-cell ucec-report-body-cell--total">
                                <?php echo $entry[ 'total_ceus' ]; ?>
                            </td>
                        </tr>

                    <?php } ?>
                </tbody>
            </table>

            <?php } else { ?>

            <div class="ucec-report-results__no-results">
                <div class="ucec-report-results-no-results__icon"></div>
                <div class="ucec-report-results-no-results__text">
                    <?php _e( 'No Results', 'uncanny-ceu' ); ?>
                </div>
            </div>

            <?php } ?>
        </div>
    </div>
</div>