<?php

namespace uncanny_ceu;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class AdminMenu
 * @package uncanny_learndash_group_management
 */
class AdminPage {

	/**
	 * The name of the plugin
	 *     *
	 * @since    1.0.0
	 * @access   private
	 * @var      string
	 */
	private $root_path = 'ceu/v1/';

	/**
	 * An array of localized and filtered strings that are used in templates
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      array
	 */
	static $ulgm_management_admin_page = array();

	/**
	 * class constructor
	 */
	public function __construct() {

		/*
		   * If WP DEBUG is not on do NOT return any php warning, notices, and/or fatal errors.
		   * Well If it is a fatal error then this return is FUBAR anyway...
		   * We do this because some badly configured servers will return notices and warnings switch get prepended or appended to the rest response.
		   */
		if ( defined( 'WP_DEBUG' ) ) {
			if ( false === WP_DEBUG ) {
				error_reporting( 0 );
			}
		}

		// Setup menu and page options in admin
		if ( is_admin() ) {

			// Create Plugin admin menus, pages, and sub-pages
			add_action( 'admin_menu', array( $this, 'create_admin_area' ), 30 );

			include_once( Utilities::get_include( 'licensing.php' ) );

			// Create a new instance of EDD Liccensing
			$licensing = new Licensing();

			// Create sub-page for EDD licensing
			$licensing->page_name   = 'Licensing';
			$licensing->page_slug   = 'uncanny-ceu-license';
			$licensing->parent_slug = 'uncanny-ceu-report';
			$licensing->store_url   = 'https://www.uncannyowl.com/';
			$licensing->item_name   = 'Uncanny Continuing Education Credits';
			$licensing->author      = 'Uncanny Owl';
			$licensing->add_licensing();
		}

		//register api class to save settings
		add_action( 'rest_api_init', array( $this, 'register_routes' ) );

	}

	/**
	 * Create Plugin admin menus, pages, and sub-pages
	 *
	 * @since 1.0.0
	 */
	function create_admin_area() {

		$page_title = esc_html__( 'Uncanny CEUs', 'uncanny-learndash-group-management' );
		$menu_title = esc_html__( 'Uncanny CEUs', 'uncanny-learndash-group-management' );
		$capability = 'manage_options';
		$menu_slug  = 'uncanny-ceu';
		$function   = array( $this, 'options_output' );


		// Create a link the main page when the menu expands
		add_submenu_page( 'uncanny-ceu-report', __( 'Settings', 'uncanny-ceu' ), __( 'Settings', 'uncanny-ceu' ), $capability, $menu_slug, $function );

		// Enqueue page specific styles
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );


	}

	/**
	 * Create Theme Options page
	 *
	 * @since 1.0.0
	 */
	function options_output() {

		$this->localize_filter_globalize_text();

		include Utilities::get_template( 'admin-settings.php' );

	}

	/**
	 * Filter and localize all text, then set as global for use in template file
	 *
	 * @since 1.0.0
	 */
	function localize_filter_globalize_text() {

// Page message set by rest call (localized during rest call)
		if ( isset( $_GET['message'] ) ) {
			self::$ulgm_management_admin_page['text']['message'] = $_GET['message'];
		} else {
			self::$ulgm_management_admin_page['text']['message'] = '';
		}

// Credit Designation Label
		self::$ulgm_management_admin_page['text']['credit_designation_label'] = __( 'Credit Designation Label', 'uuncanny-ceu' );
		$credit_designation_label                                             = stripslashes( get_option( 'credit_designation_label', __( 'CEU', 'uncanny-ceu' ) ) );
		self::$ulgm_management_admin_page['credit_designation_label']         = $credit_designation_label;

// Credit Designation Label Plural
		self::$ulgm_management_admin_page['text']['credit_designation_label_plural'] = __( 'Credit Designation Label Plural', 'uncanny-ceu' );
		$credit_designation_label_plural                                             = stripslashes( get_option( 'credit_designation_label_plural', __( 'CEUs', 'uncanny-ceu' ) ) );
		self::$ulgm_management_admin_page['credit_designation_label_plural']         = $credit_designation_label_plural;

// Credit Rollover Date
		self::$ulgm_management_admin_page['text']['ceu_rollover_date'] = __( 'Credit Rollover Date (dd/mm)', 'uncanny-ceu' );
		$ceu_rollover_date                                             = get_option( 'ceu_rollover_date', '' );
		self::$ulgm_management_admin_page['ceu_rollover_date']         = $ceu_rollover_date;

		self::$ulgm_management_admin_page['text']['page_settings'] = __( 'General Settings', 'uncanny-ceu' );

		self::$ulgm_management_admin_page['text']['email_reminders'] = __( 'Email Reminder Settings', 'uncanny-ceu' );

		self::$ulgm_management_admin_page['text']['send_email_reminders'] = __( 'Send Email Reminders', 'uncanny-ceu' );
		$send_email_reminders                                             = get_option( 'send_email_reminders', 'off' );
		if ( 'on' === $send_email_reminders ) {
			self::$ulgm_management_admin_page['send_email_reminders'] = 'checked="checked"';
		} else {
			self::$ulgm_management_admin_page['send_email_reminders'] = '';
		}

		self::$ulgm_management_admin_page['text']['days_before_rollover_date_for_reminder'] = __( 'Days Before Rollover Date for Reminder', 'uncanny-ceu' );
		$days_before_rollover_date_for_reminder                                             = get_option( 'days_before_rollover_date_for_reminder', 0 );
		self::$ulgm_management_admin_page['days_before_rollover_date_for_reminder']         = $days_before_rollover_date_for_reminder;

		self::$ulgm_management_admin_page['text']['reminder_email_subject'] = __( 'Reminder Email Subject', 'uncanny-ceu' );
		$default_subject                                                    = __( 'You Have Not Earned Enough #ceu_plural', 'uncanny-ceu' );
		if ( empty( get_option( 'reminder_email_subject', '' ) ) ) {
			self::$ulgm_management_admin_page['reminder_email_subject'] = $default_subject;
		} else {
			self::$ulgm_management_admin_page['reminder_email_subject'] = stripslashes( get_option( 'reminder_email_subject', '' ) );
		}

		self::$ulgm_management_admin_page['text']['reminder_email_body'] = __( 'Reminder Email Body', 'uncanny-ceu' );
		$default_body                                                    = __( "Hi #first_name,\r\nThis is a friendly reminder that you must earn #credits_required #ceu_plural before #rollover_date. You currently have #earned_since_rollover #ceu_plural.", 'uncanny-ceu' );
		if ( empty( get_option( 'reminder_email_body', '' ) ) ) {
			self::$ulgm_management_admin_page['reminder_email_body'] = $default_body;
		} else {
			self::$ulgm_management_admin_page['reminder_email_body'] = stripslashes( get_option( 'reminder_email_body', '' ) );
		}

		self::$ulgm_management_admin_page['text']['save_changes'] = __( 'Save Changes', 'uncanny-learndash-group-management' );


		$default_subject = __( 'You earned a Certificate', 'uncanny-ceu' );
		if ( empty( get_option( 'uncanny-ceu-multiple-certs-subject', '' ) ) ) {
			self::$ulgm_management_admin_page['uncanny-ceu-multiple-certs-subject'] = $default_subject;
		} else {
			self::$ulgm_management_admin_page['uncanny-ceu-multiple-certs-subject'] = stripslashes( get_option( 'uncanny-ceu-multiple-certs-subject', '' ) );
		}

		$default_body = __( "Congratulations, you earned a certificate!\r\nYour certificate is attached to this email.", 'uncanny-ceu' );
		if ( empty( get_option( 'uncanny-ceu-multiple-certs-message', '' ) ) ) {
			self::$ulgm_management_admin_page['uncanny-ceu-multiple-certs-message'] = $default_body;
		} else {
			self::$ulgm_management_admin_page['uncanny-ceu-multiple-certs-message'] = stripslashes( get_option( 'uncanny-ceu-multiple-certs-message', '' ) );
		}

	}

	/**
	 * Load Scripts that are specific to the admin page
	 *
	 * @since 1.0
	 *
	 * @param string $hook Admin page being loaded
	 */
	function admin_scripts( $hook ) {

		/*
		* Only load styles if the page hook contains the pages slug
		*
		* Hook can be either the toplevel_page_{page_slug} if its a parent  page OR
		* it can be {parent_slug}_pag_{page_slug} if it is a sub page.
		* Lets just check if our page slug is in the hook.
		*/

// Target group management page
		if ( strpos( $hook, 'uncanny-ceu' ) !== false ) {
			wp_register_script( 'ucec-admin', Utilities::get_asset( 'backend', 'bundle.min.js' ), [
				'jquery',
				'jquery-ui-datepicker'
			], Utilities::get_version(), true );
			wp_register_style( 'ucec-admin', Utilities::get_asset( 'backend', 'bundle.min.css' ), [], Utilities::get_version() );

// API data
			$api_setup = array(
				'api'  => [
					'root'  => esc_url_raw( rest_url() . 'ceu/v1/' ),
					'nonce' => \wp_create_nonce( 'wp_rest' ),
				],
				'l10n' => [
					'report' => [
						'filter' => [
							'date' => [
								'saveButton'            => __( 'Set range', 'uncanny-ceu' ),
								'startFieldPlaceholder' => __( 'Start', 'uncanny-ceu' ),
								'endFieldPlaceholder'   => __( 'End', 'uncanny-ceu' ),
								'fieldTemplate'         => _x( '%1$s - %2$s', '%1$s and %2$s are dates', 'uncanny-ceu' ),
							]
						]
					]
				]
			);

			wp_localize_script( 'ucec-admin', 'UO_CEUs', $api_setup );

// Load wp date picker
			wp_enqueue_script( 'jquery-ui-datepicker' );

			wp_enqueue_script( 'ucec-admin' );
			wp_enqueue_style( 'ucec-admin' );
		}
	}

	/**
	 * Rest API Custom Endpoints
	 *
	 * @since 1.0
	 */
	function register_routes() {

		register_rest_route( $this->root_path, '/save_admin_settings', array(
			'methods'  => 'POST',
			'callback' => array( $this, 'save_admin_settings' )
		) );

	}

	/**
	 * Save email templates for user redemption email, user welcome email and group leader welcome email
	 * @since 1.0.0
	 *
	 */
	function save_admin_settings() {

// Actions permitted by the pi call (colleced from input element with name action )
		$permitted_actions = array( 'save-ceu-setting' );

// Was an action received, and is the actions allowed
		if ( isset( $_POST['action'] ) && in_array( $_POST['action'], $permitted_actions ) ) {

			$action = (string) $_POST['action'];

		} else {
			$action          = '';
			$data['message'] = __( 'Select an action.', 'uncanny-learndash-group-management' );
			wp_send_json_error( $data );
		}

// Does the current user have permission
		$permission = apply_filters( 'save_ceu_setting_update_permission', 'manage_options' );
		if ( ! current_user_can( $permission ) ) {
			$data['message'] = __( 'You do not have permission to save settings.', 'uncanny-learndash-group-management' );
			wp_send_json_error( $data );
		}

		if ( isset( $_POST['credit_designation_label'] ) ) {
			update_option( 'credit_designation_label', $_POST['credit_designation_label'] );
		}

		if ( isset( $_POST['credit_designation_label_plural'] ) ) {
			update_option( 'credit_designation_label_plural', $_POST['credit_designation_label_plural'] );
		}

		if ( isset( $_POST['ceu_rollover_date'] ) ) {
			update_option( 'ceu_rollover_date', $_POST['ceu_rollover_date'] );
		}

		if ( isset( $_POST['send_email_reminders'] ) ) {
			update_option( 'send_email_reminders', $_POST['send_email_reminders'] );
		} else {
			update_option( 'send_email_reminders', 'off' );
		}

		if ( isset( $_POST['days_before_rollover_date_for_reminder'] ) ) {
			update_option( 'days_before_rollover_date_for_reminder', $_POST['days_before_rollover_date_for_reminder'] );
		}

		if ( isset( $_POST['reminder_email_subject'] ) ) {
			if ( '' === $_POST['reminder_email_subject'] ) {
				delete_option( 'reminder_email_subject' );
			} else {
				update_option( 'reminder_email_subject', $_POST['reminder_email_subject'] );
			}

		}

		if ( isset( $_POST['reminder_email_body'] ) ) {
			if ( '' === $_POST['reminder_email_subject'] ) {
				delete_option( 'reminder_email_body' );
			} else {
				update_option( 'reminder_email_body', $_POST['reminder_email_body'] );
			}

		}

		$data['message'] = __( 'Settings have been saved.', 'uncanny-learndash-group-management' );
		wp_send_json_success( $data );

	}

}