(function ($){
	$(document).ready(function(){
		CourseReport.init();
	});

	var CourseReport = {
		$elements: {},

		init: function(){
			// Get main element
			this.$elements.container = $( '#uo-ucec-course-report' );
			this.$elements.table     = $( '#uo-ucec-course-report-table' );

			// Check if the element exists
			if ( this.$elements.table.length > 0 ){
				// Create DataTable
				this.dataTables();
			}
		},

		dataTables: function(){
			// Object reference
			let _this = this;

			// Create instance of DataTables
			this.$elements.table.DataTable({
				dom: 'tip',
				order: [ [ 0, 'asc' ] ],
				paging: false,
				columnDefs: [
					{
						orderable: false, 
						targets: 4,
					},
				],
				initComplete: function(){
					// Add ready class
					_this.$elements.container.addClass( 'ucec-report--datatables-ready' );

					// Bind export CSV button
					_this.bindExportCSV();
				}
			});
		},
	}
})(jQuery);