<div class="wrap">
    <h2>H5P xAPI Settings</h2>

    <h3>About</h3>
    <p>
        This plugin enables all 
        <a href="https://tincanapi.com/statements-101/" target="_blank">xAPI statements</a>
        generated by
        <a href="https://h5p.org/" target="_blank">H5P</a> to be stored in
        a remote <a href="http://www.adlnet.org/tla/lrs.html" target="_blank">LRS</a>, e.g.
        <a href="http://learninglocker.net/" target="_blank">Learning Locker</a> and
        <a href="https://lrs.adlnet.gov/xAPI/" target="_blank">ADL LRS</a>.
    </p>

    <h3>xAPI Endpoint Settings</h3>
    <p>
        The settings in this section specifies the URL and credentials when connecting to
        the LRS to store the statements.<br/><br/>
        If you want to disable this module, leave the <b>xAPI Endpoint URL</b> field blank.<br/><br/>

        The settings depend on the LRS you are using, please see below on how to find 
        this information depending on which LRS you are using.
        <ul>
            <li><strong>
                <a href="#" class="h5p-xapi-lrs-toggle" toggle="#h5p-xapi-ll-instructions">
                    Learning Locker
                </a>
            </strong></li>
            <div class="h5p-xapi-lrs-instructions" id="h5p-xapi-ll-instructions">
                <h4>Learning Locker</h4>
                <ul>
                    <li>First, you need to ensure you have an instance of Learning Locker
                        running online or locally.</li><br/>
                    <li>To set learning locker locally, follow the instructions 
                        <a href="http://docs.learninglocker.net/installation/">here</a>.</li><br/>
                    <li>If you haven't already, create an LRS in Learning Locker.</li><br/>
                    <li>Then from the LRS clients get the clints Endpoint url, username and password.</li><br/>
                    <li>The setting info should be something like on the screenshot below.</li><br/>
                    <img src="<?php echo plugin_dir_url(__FILE__); ?>images/sample-settings.png"/>
                </ul>
            </div>
            <li><strong>
                <a href="#" class="h5p-xapi-lrs-toggle" toggle="#h5p-xapi-adl-instructions">
                    ADL LRS
                </a>
            </strong></li>
            <div class="h5p-xapi-lrs-instructions" id="h5p-xapi-adl-instructions">
                <h4>ADL LRS</h4>
                <ul>
                    <li>You can can create a user for free at 
                    <a href="https://lrs.adlnet.gov/xAPI/" target="_blank">ADL LRS</a>.</li><br/>
                    <li>The username and password you enter below should be the same as you used
                        to sign up there.</li><br/>
                </ul>
            </div>
        </ul>

        <script>
            jQuery(document).ready(function(){
                jQuery(".h5p-xapi-lrs-toggle").click(function(){
                    jQuery(jQuery(this).attr("toggle")).toggle();
                    return false;
                });
            })
        </script>
    </p>
    <form method="post" action="options.php">
        <?php settings_fields( 'h5pxapi' ); ?>
        <?php do_settings_sections( 'h5pxapi' ); ?>
        <table class="form-table">
            <tr valign="top">
                <th scope="row">xAPI Endpoint URL</th>
                <td>
                    <input type="text" name="h5pxapi_endpoint_url" 
                        value="<?php echo esc_attr(get_option("h5pxapi_endpoint_url")); ?>" 
                        class="regular-text"/>
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">xAPI Username</th>
                <td>
                    <input type="text" name="h5pxapi_username" 
                        value="<?php echo esc_attr(get_option("h5pxapi_username")); ?>" 
                        class="regular-text"/>
                </td>
            </tr>

            <tr valign="top">
                <th scope="row">xAPI Password</th>
                <td>
                    <input type="text" name="h5pxapi_password" 
                        value="<?php echo esc_attr(get_option("h5pxapi_password")); ?>" 
                        class="regular-text"/>
                </td>
            </tr>
        </table>

        <?php submit_button(); ?>
    </form>
</div>