<?php
/**
 * Adds any widgets.
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || die();

/**
 * Class LD_ConvertKit_Widgets
 *
 * Adds any widgets.
 *
 * @since 1.0.0
 */
class LD_ConvertKit_Widgets {

	/**
	 * LD_ConvertKit_Widgets constructor.
	 *
	 * @since 1.0.0
	 */
	function __construct() {

		$this->require_necessities();

		add_action( 'widgets_init', array( $this, 'add_widgets' ) );
	}

	/**
	 * Requires necessary files.
	 *
	 * @since 1.0.0
	 * @access private
	 */
	private function require_necessities() {

		require_once 'class-ld-convertkit-widget-subscriber-form.php';
	}

	/**
	 * Adds widgets.
	 *
	 * @since 1.0.0
	 * @access private
	 */
	function add_widgets() {

		register_widget( 'LD_ConvertKit_Widget_SubscriberForm' );
	}
}