<?php
/**
 * Widget class for: Subscriber Form
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || die();

/**
 * Class LD_ConvertKit_Widget_SubscriberForm
 *
 * Widget class for: Subscriber Form
 *
 * @since 1.0.0
 */
class LD_ConvertKit_Widget_SubscriberForm extends WP_Widget {

	/**
	 * LD_ConvertKit_Widget_SubscriberForm constructor.
	 *
	 * @since 1.0.0
	 */
	function __construct() {

		parent::__construct(
			'ld_convertkit_subscriber_form',
			__( 'LearnDash ConvertKit Subscriber Form', 'learndash-convertkit' ),
			array()
		);
	}

	/**
	 * Displays the widget.
	 *
	 * @since 1.0.0
	 *
	 * @param array $args Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'
	 * @param array $instance The settings for the particular instance of the widget.
	 */
	public function widget( $args, $instance ) {

		$title = ! empty( $instance['title'] ) ? $instance['title'] : '';

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );


		$course_id = get_the_ID();
		$post_type = $course_id ? get_post_type( $course_id ) : false;

		if ( $post_type === 'sfwd-courses' ) {

			echo $args['before_widget'];

			if ( ! empty( $title ) ) {

				echo $args['before_title'] . $title . $args['after_title'];
			}

			?>
            <div class="ld-convertkit-subscriber-form-widget">
				<?php LD_ConvertKit_Courses::show_subscribe_form( $course_id ); ?>
            </div>
			<?php

			echo $args['after_widget'];
		}
    }

	/**
	 * Handles updating settings for the current Text widget instance.
	 *
	 * @since 1.0.0
	 *
	 * @param array $new_instance New settings for this instance as input by the user via
	 *                            WP_Widget::form().
	 * @param array $old_instance Old settings for this instance.
	 *
	 * @return array Settings to save or bool false to cancel saving.
	 */
	public function update( $new_instance, $old_instance ) {

		$new_instance = wp_parse_args(
			$new_instance, array(
				'title' => '',
			)
		);

		$instance = $old_instance;

		$instance['title'] = sanitize_text_field( $new_instance['title'] );

		return $instance;
	}

	/**
	 * Outputs the settings update form.
	 *
	 * @since 1.0.0
	 *
	 * @param array $instance Current settings.
	 *
	 * @return string Default return is 'noform'.
	 */
	public function form( $instance ) {
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'learndash-convertkit' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
                   name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"
                   value="<?php echo esc_attr( $instance['title'] ); ?>"/>
        </p>
		<?php
	}
}