<?php

namespace Uncanny_Automator_Pro;

/**
 * Class WF_TAGSAPPLIED
 * @package Uncanny_Automator_Pro
 */
class WF_TAGSAPPLIED {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WF';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'WFTAGSAPPLIED';
		$this->trigger_meta = 'TAGSAPPLIED';
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'meta'                => $this->trigger_meta,
			'sentence'            => sprintf( __( '{{Tag:%1$s}} is added to a user', 'uncanny-automator' ), $this->trigger_meta ),
			'select_option_name'  => __( '{{Tag}} is added to a user', 'uncanny-automator' ),
			'action'              => 'wpf_tags_applied',
			'priority'            => 10,
			'accepted_args'       => 2,
			'validation_function' => array( $this, 'save_data' ),
			'options'            => [
				$this->fusion_tags(),
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_id
	 */
	public function save_data( $user_id, $tags ) {

		global $uncanny_automator;

		$args = [
			'code'           => $this->trigger_code,
			'meta'           => $this->trigger_meta,
			'post_id'        => - 1,
			'ignore_post_id' => true,
			'user_id'        => $user_id,
		];
		$recipes = $uncanny_automator->get->recipes_from_trigger_code( $this->trigger_code );
		foreach ( $recipes as $recipe ) {
			foreach ( $recipe['triggers'] as $trigger ) {
				if ( key_exists( $this->trigger_meta, $trigger['meta'] ) ) {
					if ( true === in_array( (string) $trigger['meta'][ $this->trigger_meta ], $tags ) ) {
						$args = $uncanny_automator->maybe_add_trigger_entry( $args );
						break;
					}
				}
			}
		}
	}

	/**
	 * @param string $label
	 * @param string $option_code
	 *
	 * @return mixed
	 */
	public function fusion_tags( $label = '' ) {

		if ( empty( $label ) ) {
			$label = __( 'Select a Tag', 'uncanny-automator' );
		}

		$tags   = wp_fusion()->settings->get( 'available_tags' );

		$option = [
			'option_code' => $this->trigger_meta,
			'label'       => $label,
			'input_type'  => 'select',
			'required'    => true,
			'options'     => $tags,
		];

		return apply_filters( 'uap_option_wp_user_roles', $option );
	}
}
