<?php

namespace Uncanny_Automator_Pro;

/**
 * Class GP_EARNSACHIEVEMENT
 * @package Uncanny_Automator_Pro
 */
class GP_EARNSACHIEVEMENT {

	/**
	 * Integration code
	 *
	 * @var string
	 */
	public static $integration = 'GP';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * SetAutomatorTriggers constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'EARNSACHIEVEMENT';
		$this->trigger_meta = 'GPACHIEVEMENT';
		$this->define_trigger();

		add_action( 'wp_ajax_select_achievements_from_types_EARNSACHIEVEMENT', array( $this, 'select_achievements_from_types_func' ) );
	}

	/**
	 * Define trigger settings
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'sentence'            => sprintf( __( 'User earns {{an Achievement:%1$s}}', 'uncanny-automator' ), $this->trigger_meta ),
			'select_option_name'  => __( 'User earns {{an Achievement}}', 'uncanny-automator' ),
			'action'              => 'gamipress_award_achievement',
			'priority'            => 20,
			'accepted_args'       => 5,
			'validation_function' => array( $this, 'earned_achievement' ),
			'options'             => [],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->list_gp_award_types(
						__( 'Select an Achievement Type', 'uncanny-automator' ),
						'GPAWARDTYPES',
						[
							'token'        => false,
							'is_ajax'      => true,
							'target_field' => $this->trigger_meta,
							'endpoint'     => 'select_achievements_from_types_EARNSACHIEVEMENT',
						]
					),
					$uncanny_automator->options->select_field( $this->trigger_meta, __( 'Select an Award', 'uncanny-automator' ), [ '' => __( 'Select a Type Above', 'uncanny-automator' ) ] ),
				]
			],
		);
		
		$uncanny_automator->register_trigger( $trigger );
		
		return;
	}
	
	/**
	 * @param $user_id
	 * @param $achievement_id
	 * @param $trigger
	 * @param $site_id
	 * @param $args
	 */
	public function earned_achievement( $user_id, $achievement_id, $trigger, $site_id, $args ) {
		global $uncanny_automator;
		if( ! $user_id ) {
			$user_id = get_current_user_id();
		}
		if ( empty ( $user_id ) ) {
			return;
		}

		$args = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => absint( $achievement_id ),
			'user_id' => $user_id,
		];

		$uncanny_automator->maybe_add_trigger_entry( $args );
	}

	/**
	 * Return all the specific fields of a form ID provided in ajax call
	 */
	public function select_achievements_from_types_func() {

		global $uncanny_automator;

		// Nonce and post object validation.
		$uncanny_automator->utilities->ajax_auth_check( $_POST );

		$fields = [];
		if ( isset( $_POST ) ) {

			$args = [
				'post_type'      => $_POST['value'],
				'posts_per_page' => 999,
				'orderby'        => 'title',
				'order'          => 'ASC',
				'post_status'    => 'publish',
			];
		}

		$options = $uncanny_automator->options->wp_query( $args, false, 'awards' );

		foreach ( $options as $award_id => $award_name ) {
			$fields[] = array(
				'value' => $award_id,
				'text'  => $award_name,
			);
		}

		echo wp_json_encode( $fields );
		die();
	}
}