<?php

namespace Uncanny_Automator_Pro;

/**
 * Class GP_REVOKEPOINTS_A
 * @package uncanny_automator
 */
class GP_REVOKEPOINTS_A {
	
	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'GP';
	
	private $action_code;
	private $action_meta;
	private $quiz_list;
	
	/**
	 * Set up Automator action constructor.
	 */
	public function __construct() {
		$this->action_code = 'GPREVOKEPOINTS';
		$this->action_meta = 'GPPOINTS';
		$this->define_action();
	}
	
	/**
	 * Define and register the action by pushing it into the Automator object
	 */
	public function define_action() {
		
		global $uncanny_automator;
		
		$action = [
			'author'             => $uncanny_automator->get_author_name(),
			'support_link'       => $uncanny_automator->get_author_support_link(),
			'integration'        => self::$integration,
			'code'               => $this->action_code,
			/* Translators: 1:Lessons*/
			'sentence'           => sprintf( __( 'Revoke {{Points:%1$s}}', 'uncanny-automator' ), $this->action_meta ),
			'select_option_name' => __( 'Revoke {{Points}}', 'uncanny-automator' ),
			'priority'           => 10,
			'accepted_args'      => 1,
			'execution_function' => [ $this, 'revoke_points' ],
			'options'            => [],
			'options_group'       => [
				$this->action_meta => [
					$uncanny_automator->options->list_gp_points_types( __( 'Select an Point Type', 'uncanny-automator' ), $this->action_meta, [
						'token'        => false,
						'is_ajax'      => false,
					
					] ),
					$uncanny_automator->options->integer_field( 'GPPOINTVALUE', __( 'Enter Points', 'uncanny-automator' ), false, '0' )
				],
			],
		];
		
		$uncanny_automator->register_action( $action );
	}
	
	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $user_id
	 * @param $action_data
	 * @param $recipe_id
	 */
	public function revoke_points( $user_id, $action_data, $recipe_id ) {

		global $uncanny_automator;

		$points_type     = $action_data['meta'][ $this->action_meta ];
		$points          = $action_data['meta']['GPPOINTVALUE'];
		$deduct_points   = 0;
		$existing_points = gamipress_get_user_points( absint( $user_id ), $points_type );
		if ( ( $existing_points - absint( $points ) ) < 0 ) {
			$deduct_points = absint( $points ) + ( $existing_points - absint( $points ) );
		} else {
			$deduct_points = absint( $points );
		}

		gamipress_deduct_points_to_user( absint( $user_id ), absint( $deduct_points ), $points_type );

		$uncanny_automator->complete_action( $user_id, $action_data, $recipe_id );
	}

}
