<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class WoocommerceLicenseSubscription
 * @package uncanny_learndash_groups
 */
class WoocommerceLicenseSubscription {
	public function __construct() {

		// Only Run if woocommerce is available
		if ( Utilities::if_woocommerce_active() && Utilities::if_woocommerce_subscription_active() ) {
			add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ), 21 );

		}
	}

	public function plugins_loaded() {
		//Saving course option field - Simple Subscription
		add_action( 'woocommerce_process_product_meta_subscription', array( $this, 'save_courses_option_field' ) );
		//Not supported, but still added for variable subscription
		add_action( 'woocommerce_process_product_meta_variable_subscription', array(
			$this,
			'save_courses_option_field',
		) );

		/************************************/
		/********DYNAMIC PRICING*************/
		/************************************/

		add_action( 'woocommerce_before_calculate_totals', array( $this, 'subscription_price_update' ), 200 );
		add_action( 'woocommerce_cart_subscription_string_details', array( $this, 'order_total_html' ), 2500 );
		add_filter( 'woocommerce_subscriptions_product_price', array(
			$this,
			'update_subscription_price'
		), 150, 2 );
		add_filter( 'woocommerce_subscriptions_product_price_string_inclusions', array(
			$this,
			'wc_subscription_include_update'
		), 15000, 2 );

		add_filter( 'woocommerce_subscriptions_product_price_string', array( $this, 'subs_price_string' ), 100, 3 );
		add_filter( 'woocommerce_add_cart_item_data', array( $this, 'woo_custom_add_to_cart' ), 1500, 3 );


		//Add courses under cart item
		add_filter( 'woocommerce_cart_item_name', array( $this, 'woocommerce_rename_func' ), 99, 3 );

		/************************************/
		/********Group Name Checkout*************/
		/************************************/
		$user_id       = wp_get_current_user()->ID;
		$get_transient = get_transient( '_ulgm_user_' . $user_id . '_order' );
		if ( ! $get_transient ) {
			add_action( 'woocommerce_after_order_notes', array( $this, 'create_group_related_fields' ), 1001 );
			add_action( 'woocommerce_checkout_process', array( $this, 'process_group_name' ) );
		}
		/*********************************************************/
		/************************************/
		/********AFTER CHECKOUT**************/
		/************************************/
		/*add_action( 'woocommerce_subscription_payment_complete', array(
			$this,
			'process_subscription_completed'
		), 99 );*/
		add_action( 'woocommerce_checkout_update_order_meta', array( $this, 'update_order_meta' ) );

		/************************************/
		/********SUBSCRIPTION HOOKS**********/
		/************************************/
		add_action( 'woocommerce_subscription_status_expired', array( $this, 'change_group_to_draft' ), 99, 2 );
		add_action( 'woocommerce_subscription_status_on-hold', array( $this, 'change_group_to_draft' ), 99, 2 );
		add_action( 'woocommerce_subscription_status_cancelled', array( $this, 'change_group_to_draft' ), 99, 2 );
		add_action( 'woocommerce_subscription_status_pending-cancel', array( $this, 'change_group_to_draft' ), 99, 2 );
		add_action( 'woocommerce_subscription_status_active', array( $this, 'change_group_to_published' ), 99, 2 );
	}

	/**
	 * @param $val
	 *
	 * @return mixed
	 */
	public function order_total_html( $val ) {
		$cart_contents = WC()->cart->cart_contents;
		if ( $cart_contents ) {
			foreach ( $cart_contents as $cart ) {
				$id      = $cart['product_id'];
				$product = wc_get_product( $id );
				$qty     = WC()->cart->get_cart_item_quantities();

				if ( $product->is_type( 'subscription' ) ) {
					$price = \WC_Subscriptions_Product::get_meta_data( $product, 'subscription_price', 0, 'use_default_value' );
					if ( 0 === $price || empty( $price ) ) {
						$linked_courses = get_post_meta( $id, SharedFunctions::$license_meta_field, true );

						if ( $linked_courses ) {
							$total = 0;
							foreach ( $linked_courses as $course ) {
								$course_product = new \WC_Product( $course );
								if ( $course_product ) {
									$total = floatval( $total ) + floatval( $course_product->get_price() );
								}
							}
							$qty                     = $qty[ $id ];
							$total                   = $total * $qty;
							$val['recurring_amount'] = wc_price( $total );
						}
					}
				}
			}
		}

		return $val;

	}

	/**
	 * @param $subscriptions
	 * @param $user_id
	 *
	 * @return mixed
	 * @throws \WC_Data_Exception
	 */
	public function wcs_get_users_subscriptions( $subscriptions, $user_id ) { //TODO:: NOT IN USE FOR NOW
		if ( $subscriptions ) {
			foreach ( $subscriptions as $subscription ) {
				$subscription = new \WC_Subscription( $subscription );
				$order_id     = $subscription->get_parent_id();
				$order        = new \WC_Order( $order_id );
				if ( $order ) {
					foreach ( $order->get_items() as $items ) {
						$total = $items->get_total();
					}
				}
				$subscription->set_total( $total );
				//Utilities::log( $total, '$total', true, 'dynamic' );
				//Utilities::log( $subscription, '$subscription', true, 'dynamic' );
			}
		}

		return $subscriptions;
	}

	/**
	 * @param $title
	 * @param $cart_item
	 * @param $cart_item_key
	 *
	 * @return string
	 */
	function woocommerce_rename_func( $title, $cart_item, $cart_item_key ) {
		if ( ! empty( $cart_item ) ) {
			$product = $cart_item['data'];
			if ( $product->is_type( 'subscription' ) ) {
				$courses      = '';
				$course_names = array();
				$courses      = get_post_meta( $cart_item['product_id'], SharedFunctions::$license_meta_field, true );
				$courses_new  = get_post_meta( $cart_item['product_id'], SharedFunctions::$license_meta_field . '_new', true );
				if ( ! empty( $courses_new ) ) {
					foreach ( $courses_new as $new ) {
						$course_names[] = get_the_title( $new );
					}
				} else {
					foreach ( $courses as $c ) {
						$course_names[] = get_the_title( $c );
					}
				}
				if ( ! empty( $course_names ) ) {
					$learn_dash_labels = new \LearnDash_Custom_Label();
					$course_label      = $learn_dash_labels::get_label( 'courses' );
					$courses           = '<p class="coures-assigned-heading">' . $course_label . ':</p><ul class="courses-assigned">';
					foreach ( $course_names as $n ) {
						$courses .= '<li>' . $n . '</li>';
					}
					$courses .= '</ul>';

				}

				return $title . $courses;
			}
		}

		return $title;
	}

	/**
	 * Save the custom fields.
	 */
	function save_courses_option_field( $post_id ) {
		if ( isset( $_POST['_license'] ) ) {
			update_post_meta( $post_id, SharedFunctions::$license_meta_field, $_POST['_license'] );
		} else {
			delete_post_meta( $post_id, SharedFunctions::$license_meta_field );
		}
	}

	/**
	 * @param $cart_object
	 *
	 * @return mixed
	 */
	public function subscription_price_update( $cart_object ) {
		$products = $cart_object->cart_contents;
		if ( $products ) {
			foreach ( $products as $prod ) {
				$id      = $prod['product_id'];
				$product = wc_get_product( $id );
				$price   = \WC_Subscriptions_Product::get_meta_data( $product, 'subscription_price', 0, 'use_default_value' );
				if ( $product->is_type( 'subscription' ) && ( 0 === $price || empty( $price ) ) ) {
					$linked_courses = get_post_meta( $id, SharedFunctions::$license_meta_field, true );
					if ( $linked_courses ) {
						$total = 0;
						foreach ( $linked_courses as $course ) {
							$course_product = new \WC_Product( $course );
							if ( $course_product ) {
								$total = floatval( $total ) + floatval( $course_product->get_price() );
							}
						}
						$prod['data']->set_price( $total );
						//$prod['data']->subscription_price = $total;
					}
				}
			}
		}

		//return $cart_object;
	}


	/**
	 * @param $subscription_string
	 * @param $product
	 * @param $include
	 *
	 * @return string
	 */
	public function subs_price_string( $subscription_string, $product, $include ) {

		if ( ! empty( $subscription_string ) ) {

			if ( $product->is_type( 'subscription' ) ) {

				$courses = get_post_meta( $product->get_id(), SharedFunctions::$license_meta_field, true );
				if ( ! empty( $courses ) ) {
					$per_seat_text = get_option( 'ulgm_per_seat_text', 'Seat' );

					$subscription_string .= " / $per_seat_text";
					$subscription_string = apply_filters( 'ulgm_per_seat_text_subscription', $subscription_string, $product, $per_seat_text );
				}
			}
		}

		return $subscription_string;
	}

	/**
	 * @param $active_price
	 * @param \WC_Product_Subscription $product
	 *
	 * @return float|int
	 */
	public function update_subscription_price( $active_price, $product ) {
		if ( ! empty( $product ) && $product->is_type( 'subscription' ) ) {
			$id    = $product->get_id();
			$price = \WC_Subscriptions_Product::get_meta_data( $product, 'subscription_price', 0, 'use_default_value' );

			if ( 0 === $price || empty( $price ) ) {
				//$active_price   = 0;
				$linked_courses = get_post_meta( $id, SharedFunctions::$license_meta_field, true );
				if ( $linked_courses ) {
					foreach ( $linked_courses as $course ) {
						if ( false !== get_post_status( $course ) ) {
							$course_product = new \WC_Product( $course );
							if ( $course_product ) {
								$active_price = floatval( $active_price ) + floatval( $course_product->get_price() );
							}
						}
					}
				}
			}
		}

		return $active_price;
	}


	/**
	 * @param $include
	 * @param \WC_Product_Subscription $product
	 *
	 * @return float|int
	 */
	public function wc_subscription_include_update( $include, $product ) {
		if ( $product instanceof \WC_Product_Subscription ) {
			$id    = $product->get_id();
			$price = \WC_Subscriptions_Product::get_meta_data( $product, 'subscription_price', 0, 'use_default_value' );

			if ( 0 === $price || empty( $price ) ) {
				$linked_courses = get_post_meta( $id, SharedFunctions::$license_meta_field, true );
				if ( $linked_courses ) {
					$active_price = 0;
					foreach ( $linked_courses as $course ) {
						if ( false !== get_post_status( $course ) ) {
							$course_product = new \WC_Product( $course );
							if ( $course_product ) {
								$active_price = floatval( $active_price ) + floatval( $course_product->get_price() );
							}
						}
					}

					$include['price'] = wc_price( $active_price );
				}
			}
		}

		return $include;
	}

	/**
	 *
	 */
	public function process_group_name() {
		$show_additional_fields = $this->check_if_course_subscription_in_cart();
		if ( function_exists( 'wcs_cart_contains_resubscribe' ) ) {
			$resub_exists = wcs_cart_contains_resubscribe( WC()->cart );
		} else {
			$resub_exists = '';
		}
		if ( true === $show_additional_fields['status'] && ! $_POST['ulgm_group_name'] && empty( $resub_exists ) ) {
			wc_add_notice( esc_html__( 'Please Enter Group Name.', 'uncanny-learndash-groups' ), 'error' );
		}
	}


	/**
	 * @param $checkout
	 */
	public function create_group_related_fields( $checkout ) {
		$show_additional_fields = $this->check_if_course_subscription_in_cart();
		if ( function_exists( 'wcs_cart_contains_resubscribe' ) ) {
			$resub_exists = wcs_cart_contains_resubscribe( WC()->cart );
		} else {
			$resub_exists = '';
		}
		if ( true === $show_additional_fields['status'] && empty( $resub_exists ) ) {
			$group_name = get_post_meta( $show_additional_fields['product_id'], '_group_name', true );
			$custom_buy = get_post_meta( $show_additional_fields['product_id'], '_uo_custom_buy_product', true );
			if ( empty( $group_name ) ) {
				$group_name = '';
			}
			if ( 'yes' === $custom_buy ) {
				$classes = array( 'ulgm-woo-group-settings form-row-wide form-uo-hidden' );
				$class   = 'form-uo-hidden';
			} else {
				$classes = array( 'ulgm-woo-group-settings form-row-wide' );
				$class   = '';
			}

			echo '<div id="ulgm-checkout-heading" class="' . $class . '"><h3>' . esc_html__( 'Group Settings', 'uncanny-learndash-groups' ) . '</h3>';
			woocommerce_form_field( 'ulgm_group_name', array(
				'type'         => 'text',
				'class'        => $classes,
				'label'        => esc_html__( 'Group Name', 'uncanny-learndash-groups' ),
				//'placeholder'  => esc_html__( 'Meaningful Group Name', 'uncanny-learndash-groups' ),
				'maxlength'    => 80,
				'default'      => $group_name,
				'required'     => true,
				'autocomplete' => false,
			), $checkout->get_value( 'ulgm_group_name' ) );

			echo '</div>';
		}
	}


	/**
	 * @return array
	 */
	private function check_if_course_subscription_in_cart() {
		$items = \WC()->cart->get_cart();
		if ( $items ) {
			foreach ( $items as $item ) {
				$product = $item['data'];
				//$product = new \WC_Product( $pid );
				if ( $product->is_type( 'subscription' ) ) {
					$courses = get_post_meta( $product->get_id(), SharedFunctions::$license_meta_field, true );
					if ( ! empty( $courses ) ) {
						return array( 'status' => true, 'product_id' => $product->get_id() );
						break;
					}
				}
			}
		}

		return array( 'status' => false );
	}


	/**
	 * @param \WC_Subscription $subscription
	 */
	public function process_subscription_completed( \WC_Subscription $subscription ) {
		$order_id             = $subscription->get_last_order( 'ids', array( 'parent' ) );
		$order                = new \WC_Order( $order_id );
		$user_id              = $order->get_user_id();
		$user                 = new \WP_User( $user_id );
		$qty                  = 0;
		$product_id           = 0;
		$_quantity            = 0;
		$line_items           = $order->get_items( 'line_item' );
		$group_created        = get_post_meta( $order_id, '_group_already_created', true );
		$maybe_resubscription = wcs_order_contains_resubscribe( $order );
		$old_subscription     = wcs_get_subscriptions_for_resubscribe_order( $order );
		//Utilities::log( $maybe_resubscription, '$maybe_resubscription', true, 'resubsc' );
		//Utilities::log( $old_subscription, '$old_subscription', true, 'resubsc' );
		if ( ! empty( $old_subscription ) && $maybe_resubscription ) {
			if ( is_array( $old_subscription ) ) {
				foreach ( $old_subscription as $o_sub_id => $o_sub_data ) {
					$_old_subscription      = new \WC_Subscription( $o_sub_id );
					$old_order_id           = $_old_subscription->get_last_order( 'ids', 'parent' );
					$existing_group_id      = get_post_meta( $old_order_id, SharedFunctions::$linked_group_id_meta, true );
					$existing_code_group_id = get_post_meta( $old_order_id, SharedFunctions::$code_group_id_meta_key, true );
					update_post_meta( $order_id, SharedFunctions::$linked_group_id_meta, $existing_group_id );
					update_post_meta( $order_id, '_group_already_created', 'yes' );
					update_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, $existing_code_group_id );
					$this->force_change_group_to_publish( $existing_group_id );
				}
			}
		}

		if ( ! class_exists( 'Database' ) ) {
			include_once( Utilities::get_include( 'database.php' ) );
		}
		if ( ! $maybe_resubscription ) {
			if ( ( $order ) && ( $order->has_status( 'completed' ) || $order->has_status( 'processing' ) ) && $line_items && empty( $group_created ) ) {
				//Utilities::log( $line_items, 'Line Items', true, 'line-items' );
				$continue = false;
				foreach ( $line_items as $item_id => $item ) {
					$_product  = $item->get_product();
					$_quantity = $item->get_quantity();
					//Utilities::log( $_product, '$_product', true, 'subsc' );
					//Utilities::log( $_quantity, '$_quantity', true, 'subsc' );
					if ( $this->check_if_courses_in_subscription_items( $_product->get_id() ) ) {
						$product_id = $_product->get_id();
						$continue   = true;
						break;
					}
				}
				//Utilities::log( $continue, 'Continue', true, 'line-items' );

				if ( $continue ) {
					if ( 'yes' === get_post_meta( $product_id, '_uo_custom_buy_product', true ) ) {
						wp_update_post( array(
							'ID'          => $product_id,
							'post_author' => $user->ID,
						) );
					}
					if ( ! in_array( 'group_leader', (array) $user->roles ) ) {
						$user->add_role( 'group_leader' );
					}
					$group_title   = get_post_meta( $order_id, SharedFunctions::$group_name_field, true );
					$ld_group_args = array(
						'post_type'    => 'groups',
						'post_status'  => 'publish',
						'post_title'   => $group_title,
						'post_content' => '',
						'post_author'  => $user_id,
					);

					//Utilities::log( $ld_group_args, '$ld_group_args', true, 'subsc' );
					$group_id = wp_insert_post( $ld_group_args );

					foreach ( $line_items as $line ) {
						//$qty            = $qty + $line['qty'];
						$courses_linked = get_post_meta( $line['product_id'], SharedFunctions::$license_meta_field, true );
						if ( $courses_linked ) {
							foreach ( $courses_linked as $course_product ) {
								//Utilities::log( $course_product, 'Course', true, 'license' );
								$course_id = get_post_meta( $course_product, '_ulgm_course', true );
								ld_update_course_group_access( (int) $course_id, (int) $group_id, false );
								$transient_key = 'learndash_course_groups_' . $course_id;
								delete_transient( $transient_key );
							}
						}
					}
					$qty = $_quantity;
					update_post_meta( $group_id, '_ulgm_total_seats', $qty );
					update_post_meta( $order_id, SharedFunctions::$linked_group_id_meta, $group_id );
					$attr          = array(
						'user_id'    => $user_id,
						'order_id'   => $order_id,
						'group_id'   => $group_id,
						'group_name' => $group_title,
						'qty'        => $qty,
					);
					$codes         = SharedFunctions::generate_random_codes( $qty );
					$code_group_id = Database::add_codes( $attr, $codes );

					update_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, $code_group_id );
					update_post_meta( $group_id, '_uo_subscription_group', 'yes' );
					update_post_meta( $order_id, '_group_already_created', 'yes' );
					update_post_meta( $order_id, SharedFunctions::$code_group_id_meta_key, $code_group_id );

					// This is user is the creator or the group and cannot be remove on the frontend group management only
					update_post_meta( $group_id, 'locked_admin_group_leader', $user->ID );
					ld_update_leader_group_access( $user->ID, $group_id );

					//Setting group leader as a member of the group & using 1 code / qty for it.
					if ( 'yes' !== get_option( 'do_not_add_group_leader_as_member', 'no' ) ) {
						$rest_api = new RestApiEndPoints();
						$rest_api->add_existing_user( array( 'user_email' => $user->user_email ), true, $group_id, $order_id, 'redeemed', false );
					}
					SharedFunctions::remove_transient_cache( 'all' );
					//sleep( 1 );
					/*if ( ! is_admin() ) {
						$url = SharedFunctions::get_group_management_page_id( true );
						//wp_safe_redirect( $url );
						//exit;
					}*/
				}
			}
		}
	}

	/**
	 * @param \WC_Subscription $subscription
	 */
	public function change_group_to_draft( \WC_Subscription $subscription ) {
		$order_id = $subscription->get_last_order( 'ids', array( 'parent' ) );
		$group_id = get_post_meta( $order_id, SharedFunctions::$linked_group_id_meta, true );
		if ( ! empty( $group_id ) && is_numeric( $group_id ) ) {
			$post              = get_post( $group_id );
			$post->post_status = 'draft';
			wp_update_post( $post );
		}
	}

	/**
	 * @param \WC_Subscription $subscription
	 * @param null $group_id
	 */
	public function change_group_to_published( \WC_Subscription $subscription ) {
		$order_id      = $subscription->get_last_order( 'ids', array( 'parent' ) );
		$group_created = get_post_meta( $order_id, '_group_already_created', true );
		if ( empty( $group_created ) ) {
			$this->process_subscription_completed( $subscription );
		} elseif ( 'yes' === $group_created ) {
			//$order_id = $subscription->get_last_order( 'ids', array( 'parent' ) );
			//Utilities::log( $order_id, '$order_id', true, 'subsc' );
			$group_id = get_post_meta( $order_id, SharedFunctions::$linked_group_id_meta, true );
			if ( ! empty( $group_id ) && is_numeric( $group_id ) ) {
				$post              = get_post( $group_id );
				$post->post_status = 'publish';
				wp_update_post( $post );
			}
		}

	}

	/**
	 * @param null $group_id
	 */
	public function force_change_group_to_publish( $group_id = null ) {
		if ( null !== $group_id ) {
			if ( is_numeric( $group_id ) ) {
				$post              = get_post( $group_id );
				$post->post_status = 'publish';
				wp_update_post( $post );
			}
		}
	}

	/**
	 * @param $order_id
	 */
	public function update_order_meta( $order_id ) {
		if ( isset( $_POST['ulgm_group_name'] ) ) {
			update_post_meta( $order_id, SharedFunctions::$group_name_field, sanitize_text_field( $_POST['ulgm_group_name'] ) );
		}
	}

	/**
	 * @param $product_id
	 *
	 * @return bool
	 */
	public function check_if_courses_in_subscription_items( $product_id ) {
		$product = wc_get_product( $product_id );
		if ( $product->is_type( 'subscription' ) ) {
			$courses = get_post_meta( $product->get_id(), SharedFunctions::$license_meta_field, true );
			if ( ! empty( $courses ) ) {
				return true;
			}
		}

		return false;
	}

	/**
	 * @param $cart_item_data
	 * @param $product_id
	 * @param $variation_id
	 *
	 * @return mixed
	 */
	public function woo_custom_add_to_cart( $cart_item_data, $product_id, $variation_id ) {

		$product = wc_get_product( $product_id );
		//global $woocommerce;
		if ( $product->is_type( 'subscription' ) ) {
			if ( $this->check_if_courses_in_subscription_items( $product_id ) ) {
				$cart = WC()->cart->cart_contents;
				if ( $cart ) {
					foreach ( $cart as $cart_key => $cart_contents ) {
						$cart_product_id = $cart_contents['product_id'];
						$cart_product    = wc_get_product( $cart_product_id );
						$product_name    = get_the_title( $cart_product_id );
						if ( $cart_product->is_type( 'license' ) ) {
							$this->remove_related_courses( $cart_product_id );
							WC()->cart->remove_cart_item( $cart_key );
							wc_add_notice( sprintf( esc_html__( '%s removed from cart. Only one license is allowed.', 'uncanny-learndash-groups' ), $product_name ), 'error' );
						} elseif ( $product_id !== $cart_product_id && $cart_product->is_type( 'subscription' ) ) {
							$sub_license = new WoocommerceLicenseSubscription();
							if ( $sub_license->check_if_courses_in_subscription_items( $product->get_id() ) ) {
								WC()->cart->remove_cart_item( $cart_key );
								wc_add_notice( sprintf( esc_html__( '%s removed from cart. Only one license is allowed.', 'uncanny-learndash-groups' ), $product_name ), 'error' );
							}
						}
					}
				}

			}
			//$woocommerce->cart->empty_cart();
		}
		//$this->reset_license_on_cart_empty( $product_id );

		// Do nothing with the data and return
		return $cart_item_data;
	}

	/**
	 * @param $cart_product_id
	 */
	public function remove_related_courses( $cart_product_id ) {
		$cart    = WC()->cart->cart_contents;
		$courses = get_post_meta( $cart_product_id, SharedFunctions::$license_meta_field, true );
		if ( $cart && $courses ) {
			//Utilities::log( $courses, '$courses', true, 'carttttt' );
			foreach ( $cart as $cart_key => $cart_contents ) {
				$cart_product_id = $cart_contents['product_id'];
				if ( in_array( $cart_product_id, $courses ) ) {
					WC()->cart->remove_cart_item( $cart_key );
				}
			}
		}

	}
}