<?php

namespace uncanny_learndash_groups;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Class MigrateLearndashGroups
 * @package uncanny_learndash_groups
 */
class MigrateLearndashGroups {
	/**
	 * MigrateLearndashGroups constructor.
	 */
	function __construct() {
		add_action( 'plugins_loaded', array( $this, 'setup_groups_upgrade' ) );
		add_action( 'upgrade_learndash_groups', array( $this, 'upgrade_learndash_groups' ) );
		add_action( 'init', array( $this, 'upgrade_learndash_group' ) );

	}

	/**
	 *
	 */
	function setup_groups_upgrade() {
		if ( ( isset( $_GET['wpnonce'] ) && wp_verify_nonce( $_GET['wpnonce'], 'ulgm' ) ) && ( isset( $_GET['migrate'] ) && 'yes' === $_GET['migrate'] ) ) {
			wp_schedule_single_event( time() + 15, 'upgrade_learndash_groups' );
			add_action( 'admin_notices', array( $this, 'admin_notice__success' ) );
		}
	}

	/**
	 *
	 */
	function admin_notice__success() {
		?>
		<div class="notice notice-success is-dismissible">
			<p><?php _e( 'Upgrade is processing in background!', 'uncanny-learndash-groups' ); ?></p>
		</div>
		<?php
	}

	/**
	 *
	 */
	function upgrade_learndash_groups() {

		$groups                           = new \WP_Query( array(
			'post_type'      => 'groups',
			'posts_per_page' => 999,
			'meta_key'       => SharedFunctions::$code_group_id_meta_key,
			'meta_compare'   => 'NOT EXISTS',
		) );
		$groups_to_upgrade_in_single_pass = 50;
		$groups_upgraded                  = 0;
		if ( $groups->posts ) {
			$total_groups_to_upgrade = count( $groups->posts );
			if ( ! class_exists( 'Database' ) ) {
				include_once( Utilities::get_include( 'database.php' ) );
			}

			//Utilities::log( $groups->posts, '$posts', true, 'cron' );
			//Utilities::log( $total_groups_to_upgrade, '$total_groups_to_upgrade', true, 'cron' );
			foreach ( $groups->posts as $post ) {
				$group_leaders_arr = array();
				$group_id          = $post->ID;
				$number_of_seats   = 0;
				$group_leader_id   = 0;
				$seat_users        = array();
				$group_leaders     = learndash_get_groups_administrators( $group_id );
				$group_users       = learndash_get_groups_users( $group_id );
				//Utilities::log( $group_leaders, '$group_leaders', true, 'cron' );

				if ( $group_leaders ) {
					foreach ( $group_leaders as $gl ) {
						/*$group_leaders_arr[]   = array(
							'ID'         => $gl->ID,
							'user_email' => $gl->user_email,
						);*/
						$seat_users[ $gl->ID ] = array(
							'ID'         => $gl->ID,
							'user_email' => $gl->user_email,
							'role'       => 'group_leader',
						);
						if ( 0 === $group_leader_id ) {
							$group_leader_id = $gl->ID;
						}
					}
					//if ( $group_leaders_arr ) {
					//$number_of_seats = count( $group_leaders );
					//$group_leader_id = $group_leaders_arr[0]['ID'];
					//}
				}
				if ( $group_users ) {
					foreach ( $group_users as $key => $user ) {
						/*if ( ! in_array( $user->ID, $diff ) ) {
							$number_of_seats = $number_of_seats + 1;
						} else {
							unset( $group_users[ $key ] );
						}*/
						if ( ! key_exists( $user->ID, $seat_users ) ) {
							$seat_users[ $user->ID ] = array(
								'ID'         => $user->ID,
								'user_email' => $user->user_email,
								'role'       => 'user',
							);
						}
					}
				}
				$number_of_seats = count( $seat_users );
				//Utilities::log( $group_leaders_arr, '$group_leaders_arr', true, 'gfl' );
				$order_id      = Database::get_random_order_number();
				$attr          = array(
					'user_id'    => $group_leader_id,
					'order_id'   => $order_id,
					'group_id'   => $group_id,
					'group_name' => $post->post_title,
					'qty'        => $number_of_seats,
				);
				$codes         = SharedFunctions::generate_random_codes( $number_of_seats );
				$code_group_id = \uncanny_learndash_groups\Database::add_codes( $attr, $codes );

				update_post_meta( $group_id, '_ulgm_is_custom_group_created', 'yes' );
				update_post_meta( $group_id, '_ulgm_is_upgraded', 'yes' );
				update_post_meta( $group_id, '_ulgm_total_seats', $number_of_seats );
				update_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, $code_group_id );
				update_user_meta( $group_leader_id, '_ulgm_custom_order_id', $order_id );

				/*if ( count( $group_leaders_arr ) ) {
					foreach ( $group_leaders_arr as $arr ) {
						$rest_api = new RestApiEndPoints();
						$rest_api->add_existing_user( array( 'user_email' => $arr['user_email'] ), true, $group_id, $order_id, 'redeemed', false, true );
					}
				}*/
				if ( count( $seat_users ) ) {
					foreach ( $seat_users as $user ) {
						$rest_api  = new RestApiEndPoints();
						$user_data = array(
							'user_email' => $user['user_email'],
							'user_id'    => $user['ID'],
						);
						if ( 'group_leader' === $user['role'] ) {
							$status = 'redeemed';
						} else {
							$status = 'Not Started';
						}
						//Utilities::log( $user_data, '$user_data', true, 'seats' );

						$rest_api->add_existing_user( $user_data, true, $group_id, $order_id, $status, false, true );

					}
				}
				$groups_upgraded ++;
				//Utilities::log( $groups_upgraded, '$groups_upgraded', true, 'cron' );

				if ( $groups_upgraded >= $groups_to_upgrade_in_single_pass && $total_groups_to_upgrade > $groups_to_upgrade_in_single_pass ) {
					wp_schedule_single_event( time() + 30, 'upgrade_learndash_groups' );
					break;
				}
			}
		}
	}

	public function upgrade_learndash_group() {

		if ( ( isset( $_GET['wpnonce'] ) && wp_verify_nonce( $_GET['wpnonce'], 'ulgm' ) ) && ( isset( $_GET['migrate_one'] ) && '' !== $_GET['migrate_one'] ) ) {
			$groups = new \WP_Query( [
				'post_type' => 'groups',
				'p'         => $_GET['migrate_one'],
			] );

			$groups_to_upgrade_in_single_pass = 50;
			$groups_upgraded                  = 0;
			if ( $groups->posts ) {
				$total_groups_to_upgrade = count( $groups->posts );
				if ( ! class_exists( 'Database' ) ) {
					include_once( Utilities::get_include( 'database.php' ) );
				}

				foreach ( $groups->posts as $post ) {
					$group_leaders_arr = [];
					$group_id          = $post->ID;
					$number_of_seats   = 0;
					$group_leader_id   = 0;
					$seat_users        = [];
					$group_leaders     = learndash_get_groups_administrators( $group_id );
					$group_users       = learndash_get_groups_users( $group_id );

					if ( $group_leaders ) {
						foreach ( $group_leaders as $gl ) {
							/*$seat_users[ $gl->ID ] = [
								'ID'         => $gl->ID,
								'user_email' => $gl->user_email,
								'role'       => 'group_leader',
							];*/
							if ( 0 === $group_leader_id ) {
								$group_leader_id = $gl->ID;
							}
						}
					}

					if ( $group_users ) {
						foreach ( $group_users as $key => $user ) {
							if ( ! key_exists( $user->ID, $seat_users ) ) {
								$seat_users[ $user->ID ] = [
									'ID'         => $user->ID,
									'user_email' => $user->user_email,
									'role'       => 'user',
								];
							}
						}
					}

					if ( empty( $group_leaders ) && empty( $group_users ) ) {
						$number_of_seats = 0;
					} else {
						$number_of_seats = count( $seat_users );
					}

					$order_id = Database::get_random_order_number();
					$attr     = [
						'user_id'    => $group_leader_id,
						'order_id'   => $order_id,
						'group_id'   => $group_id,
						'group_name' => $post->post_title,
						'qty'        => $number_of_seats,
					];
					if ( $number_of_seats > 0 ) {
						$codes = SharedFunctions::generate_random_codes( $number_of_seats );
					} else {
						$codes = [];
					}
					$code_group_id = \uncanny_learndash_groups\Database::add_codes( $attr, $codes );

					update_post_meta( $group_id, '_ulgm_is_custom_group_created', 'yes' );
					update_post_meta( $group_id, '_ulgm_is_upgraded', 'yes' );
					update_post_meta( $group_id, '_ulgm_total_seats', $number_of_seats );
					update_post_meta( $group_id, SharedFunctions::$code_group_id_meta_key, $code_group_id );
					update_user_meta( $group_leader_id, '_ulgm_custom_order_id', $order_id );

					if ( count( $seat_users ) ) {
						foreach ( $seat_users as $user ) {
							$rest_api  = new RestApiEndPoints();
							$user_data = [
								'user_email' => $user['user_email'],
								'user_id'    => $user['ID'],
							];
							if ( 'group_leader' === $user['role'] ) {
								$status = 'redeemed';
							} else {
								$status = 'Not Started';
							}

							$rest_api->add_existing_user( $user_data, true, $group_id, $order_id, $status, false, true );
						}
					}
					$groups_upgraded ++;
				}
			}
			wp_safe_redirect( remove_query_arg( [ 'migrate_one', 'wpnonce' ] ) );
			die();
		}
	}

}