<?php

namespace uncanny_learndash_groups;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class learndashBreadcrumbs
 * @package uncanny_custom_toolkit
 */
class Blocks {

	/**
	 * Blocks constructor.
	 *
	 */
	public function __construct() {

		// Check if Gutenberg exists
		if ( function_exists( 'register_block_type' ) ) {

			// Register Blocks
			add_action( 'init', function () {
				require_once( dirname( __FILE__ ) . '/src/groups-group-management-interface/block.php' );
				require_once( dirname( __FILE__ ) . '/src/groups-group-reports-interface/block.php' );
				require_once( dirname( __FILE__ ) . '/src/groups-group-quiz-report/block.php' );
				require_once( dirname( __FILE__ ) . '/src/groups-woocommerce-buy-courses/block.php' );
				require_once( dirname( __FILE__ ) . '/src/groups-group-essays-report/block.php' );
				require_once( dirname( __FILE__ ) . '/src/groups-group-assignments-report/block.php' );
			} );

			// Enqueue Gutenberg block assets for both frontend + backend
			add_action( 'enqueue_block_assets', function () {
				wp_enqueue_style(
					'ulgm-gutenberg-blocks',
					plugins_url( 'blocks/dist/blocks.style.build.css', dirname( __FILE__ ) ),
					[],
					Utilities::get_version()
				);
			} );

			// Enqueue Gutenberg block assets for backend editor
			add_action( 'enqueue_block_editor_assets', function () {
				wp_enqueue_script(
					'ulgm-gutenberg-editor',
					plugins_url( 'blocks/dist/blocks.build.js', dirname( __FILE__ ) ),
					[ 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-editor' ],
					Utilities::get_version(),
					true
				);

				wp_enqueue_style(
					'ulgm-gutenberg-editor',
					plugins_url( 'blocks/dist/blocks.editor.build.css', dirname( __FILE__ ) ),
					[ 'wp-edit-blocks' ],
					Utilities::get_version()
				);
			} );

			// Create custom block category
			add_filter( 'block_categories', function ( $categories, $post ) {
				return array_merge(
					$categories,
					array(
						array(
							'slug'  => 'uncanny-learndash-groups',
							'title' => __( 'Uncanny LearnDash Groups', 'uncanny-learndash-groups' ),
						),
					)
				);
			}, 10, 2 );
		}
	}
}
