(function ($) { // Self Executing function with $ alias for jQuery

    /**
     *  Initialization  similar to include once but since all js is loaded by the browser automatically the all
     *   we have to do is call our functions to initialize them, his is only run in the main configuration file
     */
    $(document).ready(function () {
        window.ulgmGroupManagement.restForms.constructor();

        var file_frame;

        jQuery('#ulgm_group_upload_image_button').on('click', function( event ){
            event.preventDefault();

            if ( file_frame ) {

                file_frame.open();
                return;
            }
            // Create the media frame.
            file_frame = wp.media.frames.file_frame = wp.media({
                title: 'Select a image to upload',
                button: {
                    text: 'Use this image',
                },
                multiple: false
            });
            // When an image is selected, run a callback.
            file_frame.on( 'select', function() {
                attachment = file_frame.state().get('selection').first().toJSON();
                $( '#ulgm_group_image_preview' ).attr( 'src', attachment.url ).css( 'width', 'auto' ).show();
                $( '#ulgm_group_image_attachment_id' ).val( attachment.id );
            });

            file_frame.open();
        });

    });

    window.ulgmGroupManagement.restForms = {

        // initialize the code
        constructor: function () {

            if ( typeof window.ulgmRestApiSetup !== 'undefined' ){
                // Add events for the group management page
                this.addFormSubmitEvents();

                try {
                    $('#ulgm_font_color').wpColorPicker();
                    $('#ulgm_main_color').wpColorPicker();
                }
                catch (err) {
                    // Handle error(s) here
                }
            }
        },

        addFormSubmitEvents: function () {

            // Add rest call to all link with a rest call attached
            $('.submit-group-management-form').on('click', this.sendRestCall);

            // Add rest call to all link with a rest call attached
            $('.change-group-management-form').on('change', this.sendRestCall);

        },

        sendRestCall: function (e) {

            var spinner = $('.uo-modal-spinner');

            // The form or container of the input data
            var associatedForm = $(e.currentTarget).closest('.group-management-form');

            var $error_container = associatedForm.find('.group-management-rest-message');
            $error_container.hide();
            $('#uo-group-progress-report').hide();


            // Get the end point for the rest call from the clicked element
            var endPoint = $(e.currentTarget).data('end-point');
            if (typeof endPoint === 'undefined') {
                return false;
            }

            if ($(e.currentTarget).attr('id') === "group-id" && $(e.currentTarget).val() == 0) {
                return;
            }
            if ($(e.currentTarget).attr('id') === "uo-group-report-course" && $(e.currentTarget).val() == 0) {
                return;
            }

            // Sometimes wp editor doesn't update the textarea input rigth way.
            // Let's save iFrame editors to textarea so we can serialize
            if (typeof tinymce !== 'undefined') {
                for (edId in tinyMCE.editors) {
                    tinyMCE.editors[edId].save();
                }

            }
            // Get the input data from the closet form or contain of user inputs to the clicked element
            var restData = associatedForm.find(':input').serializeObject();

            spinner.show();

            $.ajax({

                method: "POST",
                url: ulgmRestApiSetup.root + endPoint + '/',
                data: restData,

                // Attach Nonce the the header of the request
                beforeSend: function (xhr) {
                    console.log(xhr);
                    xhr.setRequestHeader('X-WP-Nonce', ulgmRestApiSetup.nonce);
                },

                success: function (response) {
                    console.log(response);


                    spinner.hide();

                    if (true === response.success) {

                        $('#uo-group-report-course').show();

                        var url = window.location.href;

                        //append rest message to url
                        if (url.indexOf('?') > -1) {
                            url += '&message=' + encodeURIComponent(response.data.message);
                        } else {
                            url += '?message=' + encodeURIComponent(response.data.message);
                        }

                        if (typeof response.data.reload === 'undefined') {

                            var name = 'message';
                            var value = response.data.message;

                            var str = location.search;
                            if (new RegExp("[&?]" + name + "([=&].+)?$").test(str)) {
                                str = str.replace(new RegExp("(?:[&?])" + name + "[^&]*", "g"), "")
                            }
                            str += "&";
                            str += name + "=" + value;
                            str = "?" + str.slice(1);

                            // there is an official order for the query and the hash if you didn't know.
                            location.assign(location.origin + location.pathname + str + location.hash);

                        } else if (typeof response.data.call_function !== 'undefined') {

                            if (typeof response.data.function_vars !== 'undefined') {
                                window.ulgmGroupManagement[response.data.call_function](response.data.function_vars);
                            } else {
                                window.ulgmGroupManagement[response.data.call_function]();
                            }

                        }

                    } else {
                        spinner.hide();

                        if (ulgmRestApiSetup.hasOwnProperty('localized')) {
                            if ('invalid-course-id' !== response.data.error) {
                                $('#uo-group-report-course').empty().append(
                                    $('<option>', {
                                        value: '0',
                                        text: ulgmRestApiSetup.localized.selectCourse
                                    })
                                );
                            }
                        }

                        $error_container
                            .html(response.data.message)
                            .show();
                    }
                },

                fail: function (response) {
                    spinner.hide();
                    $error_container.html(response.data.message);
                }

            });

        }


    };

    /**
     * Extend serialize array to create a serialized object. This is the format that the rest call expects
     *
     * @returns object Returns key value pairs where the key is the input name and the value is the input value
     */
    // Extend serialize array to create an serialized object
    $.fn.serializeObject = function () {
        var o = {};
        var a = this.serializeArray();
        $.each(a, function () {
            if (o[this.name] !== undefined) {
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });
        return o;
    };


})(jQuery);
