(function ($) {
    $(document).ready(function () {
        // Init filters
        Filters.init();

        // Init reports
        CourseReport.init();
        DeficiencyReport.init();
    });

    var Filters = {
        init: function () {
            this.dateRange.init();
            this.user.init();
            this.groups.init();
        },

        dateRange: {
            $elements: {},

            init: function () {
                // Get element
                this.$elements.dateRange = $('#ucec-date-range');

                // Hidden fields
                this.$elements.customRangeStart = $('#ucec-date-range-custom-start');
                this.$elements.customRangeEnd = $('#ucec-date-range-custom-end');

                // Check if the required element exists
                if (this.$elements.dateRange.length > 0) {
                    // Init select2
                    this.select2();

                    // Check the Custom Date Range option
                    this.bindDateRange();
                }
            },

            bindDateRange: function () {
                // Reference
                let _this = this;

                // Check if the user is selecting
                this.$elements.dateRange.on('select2:selecting', function (event) {
                    // Check if the selected option is "custom"
                    if (event.params.args.data.id == 'custom') {
                        // Prevent default, we don't want to close the select
                        event.preventDefault();
                    }
                    // Check if it's clicking another option
                    else {
                        // Get datapicker
                        let $dataPicker = $('#ui-datepicker-div');

                        // Hide datepicker
                        $dataPicker.hide();
                    }
                });

                // Check click outside
                this.$elements.dateRange.on('select2:closing', function (event) {
                    // Get datapicker
                    let $dataPicker = $('#ui-datepicker-div');

                    // Check if there is a datapicker open,
                    // if there is then prevent the closing
                    if ($dataPicker.length > 0 && $dataPicker.is(':visible')) {
                        event.preventDefault();
                    }

                    // If the selected option is custom then update the value of the date fields
                    if (_this.$elements.dateRange.val() == 'custom') {
                        _this.updateDates();
                    }
                    else {
                        _this.cleanDates();
                    }
                });
            },

            formatOptions: function (option) {
                let output;

                // Check if the option is the custom one
                if (option.id == 'custom') {
                    // Create HTML for the custom option

                    // Get original text
                    // We're going to use this because we want to be able to translate this string with PHP
                    let originalText = option.text;

                    // Create main container
                    let container = $('<span/>', {
                        class: 'ucec-report-filter-custom-range'
                    });

                    // Top
                    let contentTop = $('<span/>', {
                        class: 'ucec-report-filter-custom-range__top',
                        text: originalText
                    });

                    container.append(contentTop);

                    // Bottom
                    let contentFields = $('<span/>', {
                        class: 'ucec-report-filter-custom-range__fields',
                    });

                    // Start field
                    let startField = $('<input/>', {
                        class: 'ucec-report-filter-custom-range__field ucec-report-filter-custom-range__start-date',
                        name: 'ucec-report-start-date',
                        id: 'ucec-report-start-date',
                        placeholder: UO_CEUs.l10n.report.filter.date.startFieldPlaceholder
                    });

                    // Check for default value
                    let startFieldValue = Filters.dateRange.$elements.customRangeStart.val();

                    if (startFieldValue != '') {
                        startField.val(startFieldValue);
                    }

                    // Start date picker
                    startField.datepicker({
                        dateFormat: 'd M, y'
                    });

                    // Append Start field
                    contentFields.append(startField);

                    // End field
                    let endField = $('<input/>', {
                        class: 'ucec-report-filter-custom-range__field ucec-report-filter-custom-range__end-date',
                        name: 'ucec-report-end-date',
                        id: 'ucec-report-end-date',
                        placeholder: UO_CEUs.l10n.report.filter.date.endFieldPlaceholder
                    });

                    // Check for default value
                    let endFieldValue = Filters.dateRange.$elements.customRangeEnd.val();

                    if (endFieldValue != '') {
                        endField.val(endFieldValue);
                    }

                    // Start date picker
                    endField.datepicker({
                        dateFormat: 'd M, y'
                    });

                    // Append End field
                    contentFields.append(endField);

                    // Save button
                    let saveButton = $('<div/>', {
                        class: 'ucec-report-filter-custom-range__save',
                        text: UO_CEUs.l10n.report.filter.date.saveButton
                    });

                    contentFields.append(saveButton);

                    // Bind Save
                    saveButton.on('click', function () {
                        // Select "custom"
                        Filters.dateRange.$elements.dateRange.val('custom');

                        // Close Select2
                        Filters.dateRange.$elements.dateRange.select2('close');
                    });

                    // Append fields to the container
                    container.append(contentFields);

                    // Set output
                    output = container;
                }
                else {
                    output = option.text;
                }

                return output;
            },

            updateDates: function () {
                // Get values
                let values = {
                    start: $('#ucec-report-start-date').val(),
                    end: $('#ucec-report-end-date').val()
                }

                // Set values
                Filters.dateRange.$elements.customRangeStart.val(values.start);
                Filters.dateRange.$elements.customRangeEnd.val(values.end);

                // Set "Custom" value
                Filters.dateRange.$elements.dateRange.trigger('change.select2');
            },

            cleanDates: function () {
                // Set values
                Filters.dateRange.$elements.customRangeStart.val('');
                Filters.dateRange.$elements.customRangeEnd.val('');
            },

            formatSelectedOption: function (option) {
                let output;

                // Check if the option is the custom one
                if (option.id == 'custom') {
                    // Get date values
                    let values = {
                        start: Filters.dateRange.$elements.customRangeStart.val(),
                        end: Filters.dateRange.$elements.customRangeEnd.val()
                    }

                    // Create text
                    let label = UO_CEUs.l10n.report.filter.date.fieldTemplate;

                    // Replace variables
                    label = label.replace(/%1\$s/, values.start != '' ? values.start : '∞');
                    label = label.replace(/%2\$s/, values.end != '' ? values.end : '∞');

                    // Set value
                    output = label;
                }
                else {
                    output = option.text;
                }

                return output;
            },

            select2: function () {
                // Reference main object
                let _this = this;

                this.$elements.dateRange.select2({
                    theme: 'default ucec-select2',
                    templateResult: _this.formatOptions,
                    templateSelection: _this.formatSelectedOption,
                    minimumResultsForSearch: -1,
                    escapeMarkup: (markup) => {
                        return markup
                    }
                });
            },
        },

        user: {

            $elements: {},

            init: function () {
                // Get element
                this.$elements.dateRange = $('#ucec-users');

                // Check if the required element exists
                if (this.$elements.dateRange.length > 0) {
                    // Init select2
                    this.select2();
                }
            },

            formatOptions: function (option) {
                let output;

                // Parse options if it contains user data
                if (option.text.indexOf('::') != -1) {
                    // Get user data
                    let userData = option.text.split('::'),
                        user = {
                            avatar: userData[0],
                            name: userData[1],
                            email: userData[2],
                        };

                    // Create main element
                    let optionText = $('<span/>', {
                        class: 'ucec-report-filter-users-dropdown',
                    });

                    // Add avatar
                    let optionAvatar = $('<img/>', {
                        class: 'ucec-report-filter-users__avatar',
                        src: user.avatar
                    });

                    optionText.append(optionAvatar);

                    // Add display name
                    let optionName = $('<span/>', {
                        class: 'ucec-report-filter-users__title',
                        text: user.name
                    });

                    optionText.append(optionName);

                    // Add email
                    let optionEmail = $('<span/>', {
                        class: 'ucec-report-filter-users__subtitle',
                        text: user.email
                    });

                    optionText.append(optionEmail);

                    // Assign jQuery object to .text property
                    output = optionText;
                }
                else {
                    output = option.text;
                }

                // Return modified option
                return output;
            },

            formatSelectedOption: function (option) {
                let output;

                // Check if text is a DOM element
                if (option.text.indexOf('::') != -1) {
                    // Get user data
                    let userData = option.text.split('::'),
                        user = {
                            avatar: userData[0],
                            name: userData[1],
                            email: userData[2],
                        };

                    // Create main element
                    let optionText = $('<span/>', {
                        class: 'ucec-report-filter-users-selected',
                    });

                    // Add avatar
                    let optionAvatar = $('<img/>', {
                        class: 'ucec-report-filter-users__avatar',
                        src: user.avatar
                    });

                    optionText.append(optionAvatar);

                    // Add display name
                    let optionName = $('<span/>', {
                        class: 'ucec-report-filter-users__title',
                        text: user.name
                    });

                    optionText.append(optionName);

                    // Assign jQuery object to .text property
                    output = optionText;
                }
                else {
                    output = option.text;
                }

                return output;
            },

            select2: function () {
                // Reference main object
                let _this = this;

                this.$elements.dateRange.select2({
                    theme: 'default ucec-select2',
                    templateResult: _this.formatOptions,
                    templateSelection: _this.formatSelectedOption,
                    escapeMarkup: function (m) {
                        return m;
                    }
                });
            },
        },

        groups: {
            $elements: {},

            init: function () {
                // Get element
                this.$elements.dateRange = $('#ucec-groups');

                // Check if ther required element exists
                if (this.$elements.dateRange.length > 0) {
                    // Init select2
                    this.select2();
                }
            },

            select2: function () {
                this.$elements.dateRange.select2({
                    theme: 'default ucec-select2'
                });
            },
        }
    }

    var CourseReport = {
        $elements: {},

        strings: {},

        init: function () {
            // Get main element
            this.$elements.container = $('.ucec-report');
            this.$elements.table = $('#ucec-course-report');

            // Check if the element exists
            if (this.$elements.table.length > 0) {
                // Get translatable strings
                this.strings.csvFileName = this.$elements.table.data('csvfilename');

                // Create DataTable
                this.dataTables();
            }
        },

        dataTables: function () {
            // Object reference
            let _this = this;

            // Create instance of DataTables
            this.$elements.table.DataTable({
                dom: 'Brtip',
                order: [[2, 'asc']],
                buttons: [
                    {
                        extend: 'csv',
                        filename: function () {
                            // Get today's date
                            let today = new Date();

                            // Create file name.
                            let filename = _this.strings.csvFileName.replace('%s', today.toLocaleDateString());

                            // Return file name
                            return filename;
                        },
                        exportOptions: {
                            rows: null,
                            selected: false,
                        },
                        customize: function (csv) {
                            csv = csv.replace(/"([0-9]*) /g, '"');
                            csv = csv.replace(/  +/g, ' ');
                            csv = csv.replace(/([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)/g, '"," $1');
                            csv = csv.replace('"User",', '"User","Email",');
                            csv = csv.replace(/(" )/g, '"');
                            return csv;
                        }
                    }
                ],
                paging: false,
                columnDefs: [
                    {
                        orderable: false,
                        targets: 3,
                    },
                    {
                        orderable: false,
                        targets: 4,
                    },
                ],
                initComplete: function () {
                    // Add ready class
                    _this.$elements.container.addClass('ucec-report--datatables-ready');

                    // Bind export CSV button
                    _this.bindExportCSV();
                }
            });

        },

        bindExportCSV: function () {
            // Get original button
            let $originalExportCSVButton = $('.ucec .buttons-csv');

            // Get cloned export CSV button
            let $clonedExportCSVButton = $('.ucec #ucec-report-export-csv');

            // Click original button when the cloned one is clicked
            $clonedExportCSVButton.on('click', function () {
                $originalExportCSVButton.trigger('click');
            });
        }
    }

    var DeficiencyReport = {
        $elements: {},

        strings: {},

        init: function () {
            // Get main element
            this.$elements.container = $('.ucec-report');
            this.$elements.table = $('#ucec-deficiency-report');

            // Check if the element exists
            if (this.$elements.table.length > 0) {
                // Get translatable strings
                this.strings.csvFileName = this.$elements.table.data('csvfilename');

                // Create DataTable
                this.dataTables();
            }
        },

        dataTables: function () {
            // Object reference
            let _this = this;

            // Create instance of DataTables
            this.$elements.table.DataTable({
                dom: 'Brtip',
                order: [[0, 'asc']],
                buttons: [
                    {
                        extend: 'csv',
                        filename: function () {
                            // Get today's date
                            let today = new Date();

                            // Create file name.
                            let filename = _this.strings.csvFileName.replace('%s', today.toLocaleDateString());

                            // Return file name
                            return filename;
                        },
                        customize: function (csv) {

                            console.log(csv);
                            csv = csv.replace(/\t+/g, '');
                            csv = csv.replace(/  +/g, ' ');

                            csv = csv.replace(/([a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?)/g, '"," $1');
                            csv = csv.replace('"User",', '"User","Email",');
                            csv = csv.replace(/(" )/g, '"');
                            return csv;
                        }
                    }
                ],
                paging: false,
                columnDefs: [
                    {
                        orderable: false,
                        targets: 1,
                    },
                    {
                        orderable: false,
                        targets: 2,
                    },
                ],
                initComplete: function () {
                    // Add ready class
                    _this.$elements.container.addClass('ucec-report--datatables-ready');

                    // Bind export CSV button
                    _this.bindExportCSV();
                }
            });
        },

        bindExportCSV: function () {
            // Get original button
            let $originalExportCSVButton = $('.ucec .buttons-csv');

            // Get cloned export CSV button
            let $clonedExportCSVButton = $('.ucec #ucec-report-export-csv');

            // Click original button when the cloned one is clicked
            $clonedExportCSVButton.on('click', function () {
                $originalExportCSVButton.trigger('click');
            });
        }
    }
})(jQuery);