<?php
/**
 * Provides helper functions.
 *
 * @since		1.0.0
 *
 * @package	LearnDash_Slack
 * @subpackage LearnDash_Slack/core
 */
if ( ! defined( 'ABSPATH' ) ) {
	die;
}

/**
 * Returns the main plugin object
 *
 * @since		1.0.0
 *
 * @return LearnDash_Slack
 */
function LEARNDASHSLACK() {
	return LearnDash_Slack::instance();
}

if ( ! function_exists( 'ld_slack_sanitize_html_class' ) ) {
	
	/**
	 * Sanitize HTML Class Names
	 * 
	 * @param		string|array $class HTML Class Name(s)
	 * 
	 * @since		1.1
	 * @return		string $class
	 */
	function ld_slack_sanitize_html_class( $class = '' ) {
		
		if ( is_string( $class ) ) {
			$class = sanitize_html_class( $class );
		}
		else if ( is_array( $class ) ) {
			$class = array_values( array_map( 'sanitize_html_class', $class ) );
			$class = implode( ' ', array_unique( $class ) );
		}
		
		return $class;
		
	}
	
}

require_once __DIR__ . '/learndash-slack-settings-api.php';