<?php
/**
 * Adds shortcode section to LearnDash tools.
 *
 * @since 1.0.0
 */

defined( 'ABSPATH' ) || die();

/**
 * Class LD_ConvertKit_Shortcodes_Section_SubscriberForm
 *
 * Adds shortcode section to LearnDash tools.
 *
 * @since 1.0.0
 */
class LD_ConvertKit_Shortcodes_Section_SubscriberForm extends LearnDash_Shortcodes_Section {

	/**
	 * LD_ConvertKit_Shortcodes_Section_SubscriberForm constructor.
	 *
	 * @since 1.0.0
	 *
	 * @param array $fields_args
	 */
	function __construct( $fields_args = array() ) {

		$this->fields_args = $fields_args;

		$this->shortcodes_section_key         = 'ld_convertkit_subscribe_form';
		$this->shortcodes_section_title       = __( 'ConvertKit Subscribe Form', 'learndash-convertkit' );
		$this->shortcodes_section_type        = 2;
		$this->shortcodes_section_description = __( 'This shortcode shows the ConvertKit subscriber form for a Course.', 'learndash-convertkit' );

		parent::__construct();
	}

	/**
	 * Creates sections for the shortcode adder form.
	 *
	 * @since 1.0.0
	 */
	function init_shortcodes_section_fields() {

		$this->shortcodes_option_fields = array(
			'course' => array(
				'id'			=>	$this->shortcodes_section_key . '_course',
				'name'  		=> 	'course',
				'type'  		=> 	'number',
				'label' 		=> 	sprintf( _x( '%s ID', 'placeholder: Course', 'learndash-convertkit' ), LearnDash_Custom_Label::get_label( 'course' ) ),
				'help_text'		=>	sprintf( _x( 'Enter single %s ID. Leave blank for current %s.', 'placeholders: Course, Courses', 'learndash-convertkit' ), LearnDash_Custom_Label::get_label( 'course' ), LearnDash_Custom_Label::get_label( 'courses' ) ),
				'value' 		=> 	'',
				'class'			=>	'small-text'
			),
		);

		$this->shortcodes_option_fields = apply_filters(
			'learndash_settings_fields',
			$this->shortcodes_option_fields,
			$this->shortcodes_section_key
		);

		parent::init_shortcodes_section_fields();
	}
}