<?php

require_once 'assignment-handler.php';
require_once 'lessons-handler.php';
require_once 'courses-handler.php';
require_once 'certificates-handler.php';
require_once 'quiz-handler.php';

require_once 'instructor-email-settings.php'; // Instructor Email Settings page
require_once 'instructor-settings.php'; // Instructor Settings page

require_once 'admin-approval-publish.php'; //
require_once 'commission/commission.php'; // Commission handler
require_once 'class-reports.php'; //showing reports
require_once 'class-child-reports.php';
require_once 'admin-menu.php';
require_once 'learndash-admin-menu-handler.php'; // To handle LearnDash admin menus

global $wdm_ar_post_types;

// array of all custom post types of LD posts.
$wdm_ar_post_types = array(
    'sfwd-assignment',
    'sfwd-certificates',
    'sfwd-courses',
    'sfwd-lessons',
    'sfwd-quiz',
    'sfwd-topic',
    'sfwd-essays', //added in v2.4.0
    'sfwd-question', //added in v2.6.0
    'achievement-type',
    'elementor_library',
);

/**
 * Added in v1.3
 * Added filter for post types.
 */
function wdmir_set_post_types()
{
    global $wdm_ar_post_types;
    $wdm_ar_post_types = apply_filters('wdmir_set_post_types', $wdm_ar_post_types);
}
add_action('admin_init', 'wdmir_set_post_types');

add_role(ROLE_ID, __(ROLE_NAME), unserialize(WDM_INS_CAPS));
/*
 *  sets current user id as  author id in the main query, excluding assignment page. Because author of assignment is any user not an instructor.
 *
 */
add_filter('pre_get_posts', 'wdm_set_author');

function wdm_set_author($query)
{
    // Check if admin
    if ($query->is_admin) {
        $wdm_user_id = get_current_user_id();

        if (wdm_is_instructor($wdm_user_id)) {
            $wdmir_exclude_posts = array(
                'sfwd-assignment',
                'achievement-type',
                'badges',
                'submission',
                'nomination',
                'badgeos-log-entry',
                'sfwd-essays'
            ); //added sfwd-essays in v2.4.0

            $wdmir_exclude_posts = apply_filters('wdmir_exclude_post_types', $wdmir_exclude_posts);

            $restrict_user = true;

            if (is_array($query->query['post_type'])) {
                foreach ($query->query['post_type'] as $post_type) {
                    if (!post_type_exists($post_type)) {
                        $restrict_user = false;
                        break;
                    }
                    if (in_array($post_type, $wdmir_exclude_posts)) {
                        $restrict_user = false;
                    }
                }
            } elseif (in_array($query->query['post_type'], $wdmir_exclude_posts)) {
                $restrict_user = false;
            }

            if ($restrict_user) {
                $query->query['author__in'] = array($wdm_user_id);
                $query->query_vars['author__in'] = array($wdm_user_id);

                $query = apply_filters('ir_filter_instructor_query', $query);
            }
        }
    }

    return $query;
}

/*
 * to load all scripts and styles
 */
 add_action('admin_enqueue_scripts', 'wdmLoadScriptsAll');

/**
 * Function to enqueue scripts.
 */
function wdmLoadScriptsAll()
{
    if (isset($_GET['page']) && ($_GET['page']=="instuctor" || $_GET['page']=="instructor_lms_reports")) {
        wp_enqueue_script('wdm_popup.js', plugin_dir_url(__FILE__).'js/wdm_popup.js', array('jquery'), '0.0.1');
        wp_enqueue_script('wdmHighcharts', plugin_dir_url(__FILE__).'js/highchart.js', array('jquery'), '0.0.1');
        //    Data table for users who attempted course
        wp_enqueue_script('wdmDtGootable', plugin_dir_url(__FILE__).'js/footable.js', array('jquery'), '0.0.1');
        wp_enqueue_script('wdmDtFilter', plugin_dir_url(__FILE__).'js/footable.filter.js', array('jquery'), '0.0.1');
        wp_enqueue_script('wdmDtSort', plugin_dir_url(__FILE__).'js/footable.sort.js', array('jquery'), '0.0.1');

        //    Custom css
        wp_enqueue_style('wdmCss', plugin_dir_url(__FILE__).'css/style.css');
        //    For data table
        wp_enqueue_style('wdmDtCssFootable', plugin_dir_url(__FILE__).'css/footable.core.css');
        wp_enqueue_style('wdmDtCssFooStand', plugin_dir_url(__FILE__).'css/footable.standalone.css');
        //    For popup email form
        wp_enqueue_style('wdmPopEmailCss', plugin_dir_url(__FILE__).'css/wdm_popup_ins_mail.css' /*, array('editor-style.css')*/);
    }

    // Instructor admin scripts and styles
    if (wdm_is_instructor()) {
        wp_enqueue_style('ir-instructor-styles', plugins_url('css/ir-instructor.css', __FILE__));
        wp_enqueue_script('ir-instructor-scripts', plugins_url('js/ir-instructor.js', __FILE__), array('jquery'));
    }
}

/*
 * to remove update, maintenance, license notices from all users except admin
 */
add_action('admin_head', 'hide_update_notice_to_all_but_admin_users', 1);

/**
 * Function to hide update notification from users those who can't update core.
 */
function hide_update_notice_to_all_but_admin_users()
{
    if (!current_user_can('update_core')) {
        remove_action('admin_notices', 'update_nag', 3);
    }
}

/*
 * to remove "dashboard" tab from admin menu
 */
function wdm_remove_dashboard_tab()
{

    if (wdm_is_instructor()) {
        global $menu;

        // to remove Contact Form 7 tab from Dashboard
        $arr_dash_tabs = apply_filters('wdmir_remove_dash_tabs', array('contact form 7'));

        foreach ($menu as $key => $value) {
            // To remove tabs from dashboard
            if (isset($value[3]) && in_array(strtolower($value[3]), $arr_dash_tabs)) {
                unset($menu[ $key ]);
            }
        }

        remove_menu_page('index.php'); //dashboard
    }
}

add_action('admin_menu', 'wdm_remove_dashboard_tab', 99);

/**
 * to add restrictions on various pages to the instructor. As "edit_posts" is assigned to instructor, so to restrict creation of other posts other than LD, this function is used.
 * It validates using current screen base name and $_POST data.
 */
function wdm_this_screen()
{
    $currentScreen = get_current_screen();

    global $post, $wdm_ar_post_types;

    $is_ld = false;

    $arr_ld_post_types = array();
    $arr_ld_post_types = $wdm_ar_post_types;

    // array_push($arr_ld_post_types, 'sfwd-assignment'); // access for assignments.
    //  array_push($arr_ld_post_types, 'sfwd-essays');
    if ((!empty($post) || !empty($_POST['post_type'])) &&
        (in_array($post->post_type, $arr_ld_post_types) || in_array($_POST['post_type'], $arr_ld_post_types))) {
        $is_ld = true;
    }
    if (wdm_is_instructor()) {
        // if ($currentScreen->base == 'dashboard') {
        //     header('Location: '.site_url().'/wp-admin/edit.php?post_type=sfwd-courses');
        //     die();
        // }
        wdmCheckScreenOfInstructor($currentScreen, $_GET['page'], $_GET['post_type'], $is_ld, $arr_ld_post_types);
        //reduceCyclomaticOfWdmThisScreen($currentScreen->base, $_GET['page'], $_GET['post_type'], $is_ld, $arr_ld_post_types);
    }
}

/**
 * Function to check a variable is set or not.
 */
function checkIfSet($page)
{
    if (isset($page)) {
        return $page;
    }

    return '';
}

/**
 * This function checks the current screen page of instructor to permission checking.
 */
function wdmCheckScreenOfInstructor($currentScreen, $get_page, $get_post_type, $is_ld, $arr_ld_post_types)
{

    $current_scr_base = $currentScreen->base;

    $skipChecking = apply_filters('wdm_ir_check_current_page', false, $current_scr_base, $get_page, $get_post_type, $is_ld, $arr_ld_post_types);

    if ($skipChecking) {
        return;
    }

    $ld_category_page_ids = apply_filters("wdmir_ld_category_page_ids", array("edit-ld_course_category", "edit-ld_course_tag"));

    if (in_array($currentScreen->id, $ld_category_page_ids)) {
        return;
    }

    global $post;

    if ($post != null) {
        if (in_array($post->post_type, $arr_ld_post_types)) {
            return;
        }
    } else {
        $post_type = get_post_type(@$_GET['post']);
        if (!empty($post_type) && in_array($post_type, $arr_ld_post_types)) {
            return;
        }
    }
    //Hook to restrict more pages. v3.0.0
    do_action('wdm_ir_restrict_page', $current_scr_base, $get_page, $get_post_type, $is_ld, $arr_ld_post_types);
    $param_page = checkIfSet($get_page);

    $page_data = array(
        'current_scr_base'  =>  $current_scr_base,
        'get_post_type' =>  $get_post_type,
        'is_ld' =>  $is_ld,
        'arr_ld_post_types' =>  $arr_ld_post_types,
        'param_page'    =>  $param_page
    );

    if (apply_filters('ir_filter_deny_page_access', irDenyPageAccess($page_data), $page_data)) {
        wp_die(__('You do not have sufficient permissions to access this page...', 'wdm_instructor_role'));
    }
}

/**
 * Function to redirect current screen base.
 */
function redirectIfCurrentScrBase($current_scr_base)
{
    if ($current_scr_base == 'dashboard') {
        //echo site_url();
        header('Location: '.site_url().'/wp-admin/edit.php?post_type=sfwd-courses');
    }
}

add_action('current_screen', 'wdm_this_screen');

/**
 * To remove count and "mine" tab from the subsubsub menu.
 * It removes the <span> element from the string.
 * It unsets the "mine" key from the $view array.
 */
function wdm_remove_counts($views)
{
    if (wdm_is_instructor()) {
        if (!empty($views)) {
            foreach ($views as $key => $value) {
                if ('mine' == $key) {
                    unset($views[ $key ]);
                    continue;
                }

                $start_pos = strpos($value, '<span');
                $end_pos = strpos($value, '</a>');

                $views[ $key ] = substr_replace($value, '', $start_pos, ($end_pos - $start_pos));
            }
        }
    }

    return $views;
}

foreach ($wdm_ar_post_types as $value) {
    add_filter('views_edit-'.$value, 'wdm_remove_counts');
}

/*
 * to remove posts,comments,etc. tabs from admin menu
 */
function wdm_remove_admin_menus()
{

    // Check that the built-in WordPress function remove_menu_page() exists in the current installation

    if (function_exists('remove_menu_page')) {
        if (wdm_is_instructor()) {
            $remove_menu_page=array(
                'posts'=>'edit.php',
                'comments'=>'edit-comments.php',
                'tools'=>'tools.php',
                'media'=>'upload.php',
                'themes'=>'themes.php',
                );
            $remove_menu_page=apply_filters('wdm_ir_remove_menu_page', $remove_menu_page); //added v2.4.0
            foreach ($remove_menu_page as $remove_page) {
                remove_menu_page($remove_page);
            }
        }
    }
}

add_action('admin_menu', 'wdm_remove_admin_menus', 999);

/**
 * to remove dashboard widgets from dashboard page in case header redirect fails.
 */
function wdm_remove_dashboard_widgets()
{
    if (wdm_is_instructor()) {
        remove_meta_box('dashboard_right_now', 'dashboard', 'normal'); // right now
        remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal'); // recent comments
        remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal'); // incoming links
        remove_meta_box('dashboard_plugins', 'dashboard', 'normal'); // plugins

        remove_meta_box('dashboard_quick_press', 'dashboard', 'normal'); // quick draft
        remove_meta_box('dashboard_recent_drafts', 'dashboard', 'normal'); // recent drafts
        remove_meta_box('dashboard_primary', 'dashboard', 'normal'); // wordpress blog
        remove_meta_box('dashboard_secondary', 'dashboard', 'normal'); // other wordpress news
        remove_meta_box('dashboard_activity', 'dashboard', 'normal');
    }
}

add_action('admin_init', 'wdm_remove_dashboard_widgets');

/**
 * To show message on dashboard page that no data to display to user  in case header redirect fails.
 */
function show_admin_messages()
{
    $currentScreen = get_current_screen();

    if (wdm_is_instructor()) {
        if ($currentScreen->base == 'dashboard') {
            echo '<div class="error"><p>'.__('No data to display', 'wdm_instructor_role').'!</p></div>';
        }
    }
}

add_action('admin_notices', 'show_admin_messages');

/**
 * To remove default copy question ajax action, and load custom ajax action.
 */
function wdm_remove_copy_question_action()
{
    if (wdm_is_instructor()) {
        remove_all_actions('wp_ajax_wp_pro_quiz_load_question');
        add_action('wp_ajax_wp_pro_quiz_load_question', 'wdm_quiz_load_question_for_copy');
    }
}

add_action('admin_init', 'wdm_remove_copy_question_action');

/**
 * This function takes "quiz_id" as an argument and returns all quizzes with questions of same user only. It takes quiz_id argument to exclude current quiz questions.
 *  Here most of the LD code used, with some changes in it.
 */
function wdm_quiz_load_question_for_copy()
{
    $quizId = checkIfSet($_GET['quiz_id']);

    $wdm_current_user = get_current_user_id();

    if (!current_user_can('wpProQuiz_edit_quiz')) {
        echo json_encode(array());
        exit;
    }

    $questionMapper = new WpProQuiz_Model_QuestionMapper();
    $data = array();

    global $wpdb;

    $res = array();

    $results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}wp_pro_quiz_master ORDER BY id ASC", ARRAY_A);

    foreach ($results as $row) {
        if ($row['result_grade_enabled']) {
            $row['result_text'] = unserialize($row['result_text']);
        }
        $res[] = new WpProQuiz_Model_Quiz($row);
    }

    $quiz = $res;

    foreach ($quiz as $qz) {
        if ($qz->getId() == $quizId) {
            continue;
        }

        $quiz_post_id = learndash_get_quiz_id_by_pro_quiz_id($qz->getId());

        //$wdm_current_user
        $post_author_id = get_post_field('post_author', $quiz_post_id);

        if ($wdm_current_user != $post_author_id) {
            continue;
        }

        $question = $questionMapper->fetchAll($qz->getId());
        $questionArray = array();

        foreach ($question as $qu) {
            $questionArray[] = array(
                'name' => $qu->getTitle(),
                'id' => $qu->getId(),
            );
        }

        $data[] = array(
            'name' => $qz->getName(),
            'id' => $qz->getId(),
            'question' => $questionArray,
        );
    }

    echo json_encode($data);

    exit;
}

/**
 * To add 'author' role to Instructor. 'author' role is required because, if author role is not there then user does not list in author field in edit course, etc.
 */
function wdm_my_profile_update($user_id)
{

    //Added in v1.4, because WordPress stores meta key of capabilities using prefix of mysql table.
    global $wpdb;
    $wdm_user_roles = get_user_meta($user_id, $wpdb->prefix.'capabilities', false);

    if (wdm_in_array(ROLE_ID, $wdm_user_roles, false)) {
        // search in multidimentional array
        $usr = new WP_User($user_id);
        $usr->add_role('author');
    }
}

add_action('admin_head', 'wdm_remove_template_field');

add_action('admin_menu', 'wdm_reset_author_metabox');

/**
 *  To remove default author meta box and add custom author meta box, to list users having role "authors" or "Instructor" in LD custom post types.
 */
function wdm_reset_author_metabox()
{

    // if (is_super_admin()) {
    // Changed condition because, Instructors were not listing in author list when logged in as an subsite admin in multisite.
    if (current_user_can('administrator')) {
        global $wdm_ar_post_types;

        foreach ($wdm_ar_post_types as $value) {
            remove_meta_box('authordiv', $value, 'normal');
            add_meta_box('authordiv', __('Author', 'wdm_instructor_role'), 'wdm_post_author_meta_box', $value);
        }
    }
}

/**
 * Remove/Add capabilities from Instructors.
 * Checks if plugin's license is deactivated or not, if deactivated then removes all caps of 'wdm_instructor' role
 * excluding 'read' cap, when next time, activate license then adds all caps again.
 */
function wdm_set_capabilities()
{
    // Get the role object.
    $wdm_instructor = get_role(ROLE_ID);

    // A list of capabilities to remove from Instructors.
    $wdm_ins_caps = unserialize(WDM_INS_CAPS);

    // if 'read_course' cap is not present then add all caps
    if (!isset($wdm_instructor->capabilities['read_course']) || !isset($wdm_instructor->capabilities['delete_essays'])) {
        foreach ($wdm_ins_caps as $key_cap => $val_cap) {
            if ('read' != $key_cap) {
                // add the capability.
                $wdm_instructor->add_cap($key_cap);
                unset($val_cap);
            }
        }
    }

    $wdmir_admin_settings = get_option('_wdmir_admin_settings', array());

    // if (isset($wdm_instructor->capabilities['instructor_page'])) {
    if (isset($wdmir_admin_settings['instructor_commission']) && '1' == $wdmir_admin_settings['instructor_commission']) {
        remove_action('woocommerce_order_status_completed', 'wdm_add_record_to_db');
        remove_action('added_post_meta', 'wdm_instructor_updated_postmeta', 10);
    }

    $wdm_admin = get_role('administrator');
    if (!isset($wdm_admin->capabilities['instructor_page'])) {
        $wdm_admin->add_cap('instructor_page');
    }
}
add_action('init', 'wdm_set_capabilities');

/**
 * @description: To edit "dashboard" tabs in admin menu
 */
function wdmirAddDashboardTabs()
{
    // global $menu;
    //     echo "<pre>";
    //     var_dump($menu);
    //     die();
    if (wdm_is_instructor()) {
        global $menu;

        // Default allowed tabs
        $allowed_tabs = array(
            // 'products',
            'courses',
            'lessons',
            'quizzes',
            'assignments',
            'topics',
            'certificates',
            'profile',
            'learndash-lms',  // This menu has been added in LearnDash v2.4.0.
            'h5p',            // @since v3.2.1
            // 'woocommerce',
        );
        // to remove Contact Form 7 tab from Dashboard
        $allowed_tabs = apply_filters('wdmir_add_dash_tabs', $allowed_tabs);
        foreach ($menu as $key => $value) {
            // If not from an array, remove from the menu.
            if (isset($value[2]) && in_array(strtolower($value[2]), $allowed_tabs)) {
                // Do nothing
            } else {
                unset($menu[ $key ]);
            }
        }
        remove_menu_page('index.php'); //dashboard
    }
}
add_action('admin_menu', 'wdmirAddDashboardTabs', 999);



add_action('admin_bar_menu', 'wdm_remove_top_menu', 1);
/**
 * wdm_remove_top_menu to remove the top menu of new content menu
 */
function wdm_remove_top_menu()
{
    if (wdm_is_instructor()) {
        //for removing comment and new content menu which appears at the top of the dashboard
         remove_action('admin_bar_menu', 'wp_admin_bar_comments_menu', 60); //added v2.4.0
         remove_action('admin_bar_menu', 'wp_admin_bar_new_content_menu', 70); //added v2.4.0
    }
}

/**
 * Remove help tab
 *
 * @since 3.1.0
 */
function irRemoveHelpTab($help, $screen_id, $screen)
{
    if (wdm_is_instructor()) {
        $screen->remove_help_tabs();
    }
    return $help;
}
add_filter('contextual_help', 'irRemoveHelpTab', 999, 3);
/**
 * Remove course group settings for instructor
 *
 * @since 3.1.0
 */
function irRemoveGroupSettings()
{
    if (wdm_is_instructor()) {
        remove_meta_box('learndash_course_groups', learndash_get_post_type_slug('course'), 'normal');
    }
}
add_action('do_meta_boxes', 'irRemoveGroupSettings');
/**
 * Remove Apps and Integrations tab in EDD
 *
 * @since 3.1.0
 */
function irRemoveEddTabs($tabs)
{
    if (wdm_is_instructor()) {
        unset($tabs['integrations']);
    }
    return $tabs;
}
add_filter('edd_add_ons_tabs', 'irRemoveEddTabs');
/**
 * Admin Customizer Settings
 *
 * @since 3.1.0
 */
if (! function_exists('irEnableAdminCustomizerSettings')) {
    function irEnableAdminCustomizerSettings()
    {
        require_once 'admin_theme/everest-admin-theme.php';
    }
}
/**
 * Whether to enable the admin theme for the current user or not
 *
 * @return bool True if admin theme to be enabled for current user, false otherwise
 * @since 3.1.0
 */
if (! function_exists('irEnableAdminTheme')) {
    function irEnableAdminTheme()
    {
        // Get all theme settings
        $admin_theme_settings = get_option('eat_admin_theme_settings');
        if (empty($admin_theme_settings['visibility'])) {
            return false;
        }

        // Extract visibility settings
        $visibility_settings = $admin_theme_settings['visibility'];

        // Check if enabled for all users
        if (array_key_exists('enable_for_all', $visibility_settings) && $visibility_settings['enable_for_all']) {
            return true;
        }

        // Is current user admin
        if (current_user_can('manage_options')) {
            // Check if enabled for admin
            if (array_key_exists('enable_for_admin', $visibility_settings) && $visibility_settings['enable_for_admin']) {
                return true;
            }
        }

        // Is current user instructor
        if (wdm_is_instructor()) {
            // Check if enabled for instructor
            if (array_key_exists('enable_for_instructor', $visibility_settings) && $visibility_settings['enable_for_instructor']) {
                return true;
            }
        }

        return false;
    }
}
/**
 * Admin Customizer
 *
 * @since 3.1.0
 */
if (! function_exists('irAdminCustomizer')) {
    function irAdminCustomizer()
    {
        $wdmir_admin_settings = get_option('_wdmir_admin_settings', false);

	// Get required wp functions
	if (! function_exists('wp_get_current_user')) {
		require_once ABSPATH . WPINC . '/pluggable.php';
	}

	// Return if customizer disabled or if user is admin
	// if (empty($wdmir_admin_settings) || current_user_can('administrator')) {

        if (empty($wdmir_admin_settings)) {
            return;
        }

        // If enabled, then load admin customizer module
        if (array_key_exists('admin_customizer_check', $wdmir_admin_settings) && 1 == $wdmir_admin_settings['admin_customizer_check']) {
            irEnableAdminCustomizerSettings();
        }
    }
    add_action('plugins_loaded', 'irAdminCustomizer' );
}
/**
 * Instructor Overview Page
 *
 * @since 3.1.0
 */
if (! function_exists('irLoadInstructorClasses')) {
    function irLoadInstructorClasses()
    {
        if (wdm_is_instructor()) {
            require_once INSTRUCTOR_ROLE_ABSPATH.'/includes/class-ir-settings-page-instructor-overview.php';
            \Ir_Instructor_Overview_Page::add_page_instance();
        }
    }
    add_action('learndash_settings_pages_init', 'irLoadInstructorClasses', 999);
}
/**
 * Remove admin notices for instructors.
 *
 * @since 3.1.0
 */
if (! function_exists('irRemoveAdminNotices')) {
    function irRemoveAdminNotices()
    {
        if (wdm_is_instructor()) {
            remove_all_actions('admin_notices');
        }
    }
    add_action('admin_head', 'irRemoveAdminNotices');
}
/**
 * Remove default admin bar for instructors
 *
 * @since 3.1.0
 */
if (! function_exists('irRemoveAdminBar')) {
    function irRemoveAdminBar()
    {
        if (wdm_is_instructor()) {
            remove_action('in_admin_header', 'wp_admin_bar_render', 0);
        }
    }
}
/**
 * Add Primary frontend menu for instructors
 *
 * @since 3.1.0
 */
if (! function_exists('irAddInstructorMenu')) {
    function irAddInstructorMenu()
    {
        if (wdm_is_instructor()) {
            $menu_list = array('primary', 'top');
            $menu_slug = '';
            $menu_item = '';

            while (! empty($menu_list) && empty($menu_slug)) {
                $menu_item = array_shift($menu_list);
                if (has_nav_menu($menu_item)) {
                    $menu_slug = $menu_item;
                }
            }

            if (! empty($menu_slug)) {
                echo wp_nav_menu(
                    array(
                        'theme_location'  => $menu_slug,
                        'menu_id'         => 'ir-primary-menu',
                        'container_id'    => 'ir-primary-navigation',
                        'container_class' => '',
                        'echo'            => false
                    )
                );
            } else {
                include(INSTRUCTOR_ROLE_ABSPATH.'/admin/templates/ir-default-instructor-menu.template.php');
            }
        }
    }
}
/**
 * Exclude menu items from the list of post types to restrict access to.
 *
 * @since 3.1.0
 */
if (! function_exists('irExcludeMenuItems')) {
    function irExcludeMenuItems($post_types)
    {
        if (wdm_is_instructor()) {
            $post_types[] = 'nav_menu_item';
        }
        return $post_types;
    }
}
// Instructor Redirection
/**
 * Redirect instructor to respective page
 *
 * @param string $redirect_to   URL to redirect to
 * @param string $requset       URL the user is coming from
 * @param object $user          WP_User object of the user
 * 
 * @return string $redirect_to   Updated URL, if user is instructor then instructor overiew page URL, else unchanged.
 *
 * @since 3.1.0
 */
if (! function_exists('irInstructorRedirect')) {
    function irInstructorRedirect($redirect_to, $request, $user)
    {
        if (empty($user) || is_wp_error($user)) {
            return $redirect_to;
        }

        if (wdm_is_instructor($user->ID)) {
            $redirect_to = add_query_arg('page', 'ir_instructor_overview', admin_url('admin.php'));

            $redirect_to = apply_filters('ir_login_redirect_filter', $redirect_to, $user);
        }

        return $redirect_to;
    }
    add_filter('login_redirect', 'irInstructorRedirect', 999, 3);
}
/**
 * Redirect Instructors from Woocommerce Login
 *
 * @param string $redirect_to   URL to redirect to
 * @param object $user          WP_User object of the user
 *
 * @return string $redirect_to   Updated URL, if user is instructor then instructor overiew page URL, else unchanged.
 *
 * @since 3.1.0
 */
if (! function_exists('irWooInstructorRedirect')) {
    function irWooInstructorRedirect($redirect_to, $user)
    {
        return irInstructorRedirect($redirect_to, '', $user);
    }
    add_filter('woocommerce_login_redirect', 'irWooInstructorRedirect', 10, 2);
}

/**
 * Redirect admin to new feature showcase page on activation
 * @since 3.1.0
 */
if (! function_exists('irFeatureShowCaseRedirect')) {
    function irFeatureShowCaseRedirect()
    {
        if (! get_option('ir-feature-showcase-demo')) {
            require_once INSTRUCTOR_ROLE_ABSPATH.'/includes/class-ir-instructor-showcase.php';
            $ir_showcase_instance = \irInstructorShowcase::getInstance();
            if (! empty($ir_showcase_instance)) {
                // delete_option('ir-feature-showcase-init');
                update_option('ir-feature-showcase-demo', 1);
                wp_redirect($ir_showcase_instance->redirect_url);
                exit();
            }
        }
    }
    add_action('plugins_loaded', 'irFeatureShowCaseRedirect', 100);
}

function irAddEssaysMenuItem($admin_menu_section)
{
    if (wdm_is_instructor()) {
        learndash_add_admin_tab_item(
            'edit.php?post_type=sfwd-quiz',
            array(
                'link' => 'edit.php?post_type=sfwd-essays',
                'name' => esc_html_x( 'Submitted Essays', 'Submitted Essays Menu Label', 'learndash' ),
                'id'   => 'edit-sfwd-essays',
                'class' => 'ir-sfwd-essays',
                'cap'  => 'edit_essay',
            ),
            20
        );
    }
}
add_action('learndash_admin_tabs_set', 'irAddEssaysMenuItem', 10);

// Allow instructors to access their own course screens on front end.
add_filter('sfwd_lms_has_access', 'irAutoEnrollInstructorCourses', 10, 3);

/**
 * Auto Enroll Instructors to their own courses
 *
 * @param bool $access      Whether the user has access to the post
 * @param int $post_id      ID of the post
 * @param int $user_id      ID of the user. If null, current user ID is used.
 *
 * @return bool             True if user has access to post, false otherwise
 * 
 * @since @todo Latest
 */
function irAutoEnrollInstructorCourses($access, $post_id, $user_id)
{
    if (! is_user_logged_in()) {
        return $access;
    }

    if (! $post_id) {
        return $access;
    }

    if (empty($user_id)) {
        $user_id = get_current_user_id();
    }

    $post = get_post($post_id);
    $ld_post_types = array('sfwd-courses', 'sfwd-lessons', 'sfwd-question', 'sfwd-quiz', 'sfwd-topic');

    if (! in_array($post->post_type, $ld_post_types)) {
        return $access;
    }

    if ($user_id == $post->post_author) {
        return true;
    }

    return $access;
}

if (! function_exists('irDenyPageAccess')) {
    /**
     * Deny access to a page to instructors
     *
     * @param array $data   Details about the current page.
     * @return bool         Updated access for current screen
     * @since 3.1.5
     */
    function irDenyPageAccess($data)
    {
        $restricted_base_screens = apply_filters(
            'ir_restricted_base_screens', 
            array(
                'edit-tags',
                'tools',
                'edit-comments',
                'upload',
                'media'
            )
        );
    
        if (in_array($data['current_scr_base'], $restricted_base_screens)) {
            return true;
        }
    
        if ($data['current_scr_base'] == 'post' && ! isset($data['get_post_type']) && ! $data['is_ld']) {
            return true;
        }
    
        if ($data['current_scr_base'] == 'edit' && ! isset($data['get_post_type']) && ! $data['is_ld']) {
            return true;
        }
    
        if ($data['current_scr_base'] == 'edit' && isset($data['get_post_type']) && ! in_array(trim($data['get_post_type']), $data['arr_ld_post_types'])) {
            return true;
        }
    
        if (
            $data['current_scr_base'] == 'post' &&
            isset($data['get_post_type']) &&
            ! in_array(trim($data['get_post_type']), $data['arr_ld_post_types']) || 
            ($data['current_scr_base'] == 'appearance_page_' . $data['param_page'])
        ) {
            return true;
        }
    }
}

if (! function_exists('irRestrictJetpackAccess')) {
    /**
     * Restrict access to jetpack page to instructors
     *
     * @param bool $deny_access     Access to the screen.
     * @param array $data           Data about current screen.
     *
     * @return bool                 Updated access for current screen
     * @since 3.1.5
     */
    function irRestrictJetpackAccess($deny_access, $data)
    {
        if (false !== strpos($data['current_scr_base'], 'jetpack')) {
            $deny_access = true;
        }
        return $deny_access;
    }
    add_filter('ir_filter_deny_page_access', 'irRestrictJetpackAccess', 10, 2);
}

if (! function_exists('irLoadModules'))
{
    function irLoadCoreModules()
    {
        $modules = array(
            'multiple-instructors'   =>  'irMultipleInstructors',
            'instructor-emails'     =>  'irInstructorEmails'
        );

        $modules = apply_filters('ir_filter_core_modules', $modules);

        foreach($modules as $file_name   =>  $class_name) {
            require_once INSTRUCTOR_ROLE_ABSPATH.'/includes/class-ir-'.$file_name.'.php';
            call_user_func(array($class_name, 'getInstance'));
        }
    }
    add_action('plugins_loaded', 'irLoadCoreModules');
}

if (! function_exists('irEnableUserMenusForInstructors')) {
    /**
     * Enable the user menu plugin settings to show/hide menu page links to instructors
     *
     * @since 3.1.5
     */
    function irEnableUserMenusForInstructors()
    {
        // Check if User Menus plugin active.
        if (class_exists('JP_User_Menus')) {
            // Check if instructor.
            if (wdm_is_instructor()) {
                // Check if instructor dashboard.
                if (is_admin()) {
                    // Enable user menu plugin features for instructor dashboard.
                    $user_menus_instance = JP_User_Menus::instance();
                    require_once($user_menus_instance->plugin_path().'includes/classes/site/menus.php');
                }
            }
        }
    }
    add_action('plugins_loaded', 'irEnableUserMenusForInstructors');
}

// Fix for assigning courses to instructors
add_filter( 'wp_insert_post_data', 'irUpdateCourseToInstructors', 10, 2);

/**
 * Update all lesson,topic and quiz when course author is updated to an instructor.
 *
 * @param array $data
 * @param array $post
 *
 * @return array
 */
function irUpdateCourseToInstructors( $data, $post )
{
    // If not admin return.
    if (! current_user_can('manage_options') && apply_filters('ir_filter_default_course_author_update', true)) {
        return $data;
    }

    // Check if course edit page.
    if ('sfwd-courses' !== $data['post_type']) {
        return $data;
    }

    // Check if course author updated.
    if (array_key_exists('post_author_override', $post) && $post['post_author_override'] !== $data['post_author']) {
        // error_log('Overiding course author');
        $new_author_id = intval($post['post_author_override']);

        if (! wdm_is_instructor($new_author_id)) {
            return $data;
        }

        $course_content_list = irGetCourseContents($post['ID']);
        if (! empty($course_content_list)) {
            foreach ($course_content_list as $content_id) {
                wp_update_post(
                    array(
                        'ID'    =>  $content_id,
                        'post_author'   =>  $new_author_id
                    )
                );
                // error_log('-- Updating author for '.print_r($content_id, 1));
            }
        }
    }
    return $data;
}

if (!function_exists('irGetCourseContents')) {
    /**
     * Get all lessons, topics and quizzes for a specific Course
     *
     * @param int $course_id    ID of the course.
     * @param string $data
     * @return array            List of all course contents.
     */
    function irGetCourseContents($course_id, $data = '')
    {
        if (empty($data)) {
            $data = array();
        }

        // Get a list of lessons to loop.
        $lessons        = learndash_get_course_lessons_list($course_id, null, array( 'num' => 0 ));
        $course_contents_list = [];

        if (( is_array($lessons) )  && ( ! empty($lessons) )) {
            // Loop course's lessons.
            foreach ($lessons as $lesson) {
                $post          = $lesson['post'];
                // Get lesson's topics.
                $topics        = learndash_topic_dots($post->ID, false, 'array', null, $course_id);

                if (( is_array($topics) )  && ( ! empty($topics) )) {
                    // Loop Topics.
                    foreach ($topics as $topic) {
                        // Get topic's quizzes.
                        $topic_quizzes        = learndash_get_lesson_quiz_list($topic->ID, null, $course_id);

                        if (( is_array($topic_quizzes) )  && ( ! empty($topic_quizzes) )) {
                            // Loop Topic's Quizzes.
                            foreach ($topic_quizzes as $quiz) {
                                $quiz_post = $quiz['post'];
                                $course_contents_list[] = $quiz_post->ID;
                            }
                        }
                        $course_contents_list[] = $topic->ID;
                    }
                }

                // Get lesson's quizzes.
                $quizzes        = learndash_get_lesson_quiz_list($post->ID, null, $course_id);
                
                if (( is_array($quizzes) )  && ( ! empty($quizzes) )) {
                    // Loop lesson's quizzes.
                    foreach ($quizzes as $quiz) {
                        $quiz_post = $quiz['post'];
                        $course_contents_list[] = $quiz_post->ID;
                    }
                }
                $course_contents_list[] = $post->ID;
            }
        }

        // Get a list of quizzes to loop.
        $quizzes        = learndash_get_course_quiz_list($course_id);

        if (( is_array($quizzes) )  && ( ! empty($quizzes) )) {
            // Loop course's quizzes.
            foreach ($quizzes as $quiz) {
                $post = $quiz['post'];
                $course_contents_list[] = $post->ID;
            }
        }

        return $course_contents_list;
    }
}

/**
 * Update Learndash data to allow access to course settings for instructors and disallow groups access.
 *
 * @param array $learndash_data     Learndash Data.
 *
 * @since 3.2.0
 */
if (! function_exists('updateLearnDashDataForInstructors')) {
    function updateLearnDashDataForInstructors($learndash_data) {
        global $post, $current_screen;

        // Check if instructor
        if (! is_user_logged_in() || ! wdm_is_instructor()) {
            return $learndash_data;
        }

        // Check if course edit page.
        if ('sfwd-courses' != $post->post_type) {
            return $learndash_data;
        }
        
        // LD 3.1 Course Settings Fix 
        // @todo To remove when LD Groups support is added in IR.
        if (defined('LEARNDASH_VERSION') && '3.1' <= LEARNDASH_VERSION ) {
            // Add support for course settings section
            $learndash_data['tabs'][] = [
                'id'                  => $post->post_type . '-settings',
                'name'                => esc_html__( 'Settings', 'learndash' ),
                'metaboxes'           => [ 'sfwd-courses', 'learndash-course-display-content-settings', 'learndash-course-access-settings', 'learndash-course-navigation-settings', 'learndash-course-users-settings', 'learndash-course-grid-meta-box' ],
                'showDocumentSidebar' => 'false',
            ];
        } elseif (defined('LEARNDASH_VERSION') && '3.0' <= LEARNDASH_VERSION ) {
            // Remove groups access for instructors.
            foreach($learndash_data['tabs'] as $key => $header_tab) {
                if ('learndash_course_groups' == $header_tab['id']) {
                    unset($learndash_data['tabs'][$key]);
                }
            }
        }

        // Hide course settings option on course listing page.
        if( 'edit-sfwd-courses' == $current_screen->id ) {
            foreach($learndash_data['tabs'] as $key => $header_tab) {
                if ('sfwd-courses-settings' == $header_tab['id']) {
                    unset($learndash_data['tabs'][$key]);
                }
            }
        }
        
        return $learndash_data;
    }
}
add_filter('learndash_header_data', 'updateLearnDashDataForInstructors', 999, 1);

/**
 * Add mobile menu icon on instructor dashboard.
 * @since   3.2.1
 */
function irAddMobileMenuIcon($items, $args)
{
    // Check if instructor
    if (! wdm_is_instructor()) {
        return $items;
    }

    // Check if primary menu set.
    $menu_list = array('primary', 'top');
    $menu_slug = '';
    $menu_item = '';

    while (! empty($menu_list) && empty($menu_slug)) {
        $menu_item = array_shift($menu_list);
        if (has_nav_menu($menu_item)) {
            $menu_slug = $menu_item;
        }
    }

    // If empty, then return
    if (empty($menu_slug)) {
        return $items;
    }

    // Add mobile menu icon.
    $items = '<li class="wdm-mob-menu wdm-admin-menu-show wdm-hidden"><span class="dashicons dashicons-menu-alt"></span></li>'.$items;

    return $items;
}
add_filter('wp_nav_menu_items', 'irAddMobileMenuIcon', 10, 2);

if (!function_exists('ir_add_dashboard_menu_links')) {
    /**
     * Add menu links for instructor.
     * 
     * @since 3.2.1.
     */
    function ir_add_instructor_dashboard_menu_items()
    {
        global $menu;

        // Check if menu set.
        if (empty($menu)) {
            return;
        }

        // Check if instructor.
        if (!wdm_is_instructor()) {
            return;
        }

        // Allow 3rd party plugins to filter through menu items.
        $menu_items = apply_filters(
            'ir_filter_instructor_dashboard_menu_items', 
            array(
                array(
                    __('Profile', 'wdm_instructor_role'),
                    'instructor_reports',
                    get_edit_profile_url(),
                    '',
                    '',
                    '',
                    'dashicons-admin-users'
                ),
                array(
                    __('Logout', 'wdm_instructor_role'),
                    'instructor_reports',
                    wp_logout_url(),
                    '',
                    '',
                    '',
                    'dashicons-migrate'
                )
            )
        );

        // Add menu links.
        foreach ($menu_items as $item) {
            array_push(
                $menu,
                $item
            );
        }
    }
}
add_action('admin_init', 'ir_add_instructor_dashboard_menu_items');