<?php

namespace uncanny_automator;

/**
 * Class WP_VIEWCUSTOMPOST
 * @package uncanny_automator
 */
class WP_VIEWCUSTOMPOST {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'WP';

	private $trigger_code;
	private $trigger_meta;


	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'VIEWCUSTOMPOST';
		$this->trigger_meta = 'WPCUSTOMPOST';
		add_action( 'wp_ajax_select_custom_post_by_type', array( $this, 'select_custom_post_func' ) );
		if ( is_admin() ) {
			add_action( 'wp_loaded', array( $this, 'plugins_loaded' ), 99 );
		} else {
			$this->define_trigger();
		}
	}

	public function plugins_loaded() {
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Custom post types 2:Number of times*/
			'sentence'            => sprintf( __( 'User views {{a custom post type:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User views {{a custom post type}}', 'uncanny-automator' ),
			'action'              => 'template_redirect',
			'priority'            => 90,
			'accepted_args'       => 1,
			'validation_function' => array( $this, 'view_post' ),
			'options'             => [
				$uncanny_automator->options->number_of_times(),
			],
			'options_group'       => [
				$this->trigger_meta => [
					$uncanny_automator->options->all_post_types( null, 'WPPOSTTYPES', [
						'token'        => false,
						'is_ajax'      => true,
						'target_field' => $this->trigger_meta,
						'endpoint'     => 'select_custom_post_by_type',
					] ),
					$uncanny_automator->options->select_field( $this->trigger_meta, __( 'Select a Post', 'uncanny-automator' ), [ '' => __( 'Select a Post Type Above', 'uncanny-automator' ) ] ),
				],
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	public function view_post() {

		global $uncanny_automator;

		global $post;
		$user_id = get_current_user_id();

		$args                    = [
			'code'    => $this->trigger_code,
			'meta'    => $this->trigger_meta,
			'post_id' => $post->ID,
			'user_id' => $user_id,
		];
		$post_type               = get_post_type_object( $post->post_type );
		$args['post_type_label'] = $post_type->labels->singular_name;

		$arr = $uncanny_automator->maybe_add_trigger_entry( $args, false );
		if ( $arr ) {
			foreach ( $arr as $result ) {
				if ( true === $result['result'] ) {
					$result['args']['post_type_label'] = $post_type->labels->singular_name;
					$uncanny_automator->maybe_trigger_complete( $result['args'] );
				}
			}
		}
	}

	/**
	 * Return all the specific fields of post type in ajax call
	 */
	function select_custom_post_func() {
		global $uncanny_automator;

		$uncanny_automator->utilities->ajax_auth_check( $_POST );
		$fields = [];
		if ( isset( $_POST ) ) {
			$post_type = $_POST['value'];

			$args       = array(
				'posts_per_page'   => 999,
				'orderby'          => 'title',
				'order'            => 'ASC',
				'post_type'        => $post_type,
				'post_status'      => 'publish',
				'suppress_filters' => true,
				'fields'           => array( 'ids', 'titles' ),
			);
			$posts_list = get_posts( $args );

			if ( ! empty( $posts_list ) ) {
				foreach ( $posts_list as $post ) {
					$fields[] = array(
						'value' => $post->ID,
						'text'  => $post->post_title,
					);
				}
			}
		}
		echo wp_json_encode( $fields );
		die();
	}
}