<?php

namespace uncanny_automator;

/**
 * Class LD_FAILQUIZ
 * @package uncanny_automator
 */
class LD_FAILQUIZ {

	/**
	 * Integration code
	 * @var string
	 */
	public static $integration = 'LD';

	private $trigger_code;
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		$this->trigger_code = 'LD_FAILQUIZ';
		$this->trigger_meta = 'LDQUIZ';
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 */
	public function define_trigger() {

		global $uncanny_automator;

		$trigger = array(
			'author'              => $uncanny_automator->get_author_name( $this->trigger_code ),
			'support_link'        => $uncanny_automator->get_author_support_link( $this->trigger_code ),
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			/* Translators: 1:Quizzes 2:Number of times*/
			'sentence'            => sprintf( __( 'User fails {{a quiz:%1$s}} {{a number of:%2$s}} times', 'uncanny-automator' ), $this->trigger_meta, 'NUMTIMES' ),
			'select_option_name'  => __( 'User fails {{a quiz}}', 'uncanny-automator' ),
			'action'              => 'learndash_quiz_completed',
			'priority'            => 15,
			'accepted_args'       => 2,
			'validation_function' => array( $this, 'quiz_completed' ),
			// very last call in WP, we need to make sure they viewed the page and didn't skip before is was fully viewable
			'options'             => [
				$uncanny_automator->options->all_ld_quiz(),
				$uncanny_automator->options->number_of_times(),
			],
		);

		$uncanny_automator->register_trigger( $trigger );

		return;
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $data
	 */
	public function quiz_completed( $data, $current_user ) {

		$q_status = $data['pass'];

		if ( 0 === (int) $q_status ) {

			global $uncanny_automator;
			
			$user    = $current_user;
			$quiz    = $data['quiz'];
			$post_id = $quiz;

			if ( empty( $user ) ) {
				$user = wp_get_current_user();
			}

			$args = [
				'code'    => $this->trigger_code,
				'meta'    => $this->trigger_meta,
				'post_id' => (int)$post_id,
				'user_id' => $user->ID,
			];

			$uncanny_automator->maybe_add_trigger_entry( $args );
		}
	}
}
