<?php
namespace Uncanny_Automator;

// Get data
$license = get_option( 'uap_automator_license_key' );
$status  = get_option( 'uap_automator_license_status' ); // $license_data->license will be either "valid", "invalid", "expired", "disabled"
$license_check = get_option( 'uap_automator_license_check' ); // $license_data->license_check will be either

/**
 * Possible values for $status
 *
 * {bool}    false     Empty, never saved
 * {string}  valid 	   The License is valid
 * {string}  expired   The License has expired
 * {string}  invalid   The license is invalid
 * {string}  inactive  The license has been disabled
*/

// Check license status
$license_is_active = $status == 'valid' ? true : false;

// CSS Classes
$css_classes = array();

if ( $license_is_active ){
	$css_classes[] = 'uo-license--active';
}

// Set links. Add UTM parameters at the end of each URL
$where_to_get_my_license = 'https://automatorplugin.com/knowledge-base/where-can-i-find-my-license-key/?utm_source=uncanny_automator_lite&utm_medium=license_page&utm_content=where_to_get_my_license';
$buy_new_license 		 = 'https://automatorplugin.com/pricing/?utm_source=uncanny_automator_lite&utm_medium=license_page&utm_content=buy_new_license';
$knowledge_base			 = 'https://automatorplugin.com/knowledge-base/?utm_source=uncanny_automator_lite&utm_medium=license_page&utm_content=knowledge_base';

?>

<div class="wrap"> <!-- WP container -->
	<div id="poststuff"> <!-- WP container -->
		<div class="uo-license <?php echo implode( ' ', $css_classes ); ?>">
			<div class="uo-license-status">
				<div class="uo-license-status__icon">
					
					<?php if ( $license_is_active ){ ?>

						<svg class="uo-license-status-icon__svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512">
							<path class="uo-license-status-icon__svg-path uo-license-status-icon__svg-check" d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"></path>
						</svg>

					<?php } else { ?>

						<svg class="uo-license-status-icon__svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 352 512">
							<path class="uo-license-status-icon__svg-path uo-license-status-icon__svg-times" d="M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z"></path>
						</svg>

					<?php } ?>

				</div>
			</div>
			<div class="uo-license-content">

				<form class="uo-license-content-form" method="POST" action="options.php">

					<?php settings_fields( 'uap_automator_license' ); ?>

					<?php wp_nonce_field( 'uap_automator_nonce', 'uap_automator_nonce' ); ?>

					<div class="uo-license-content-top">
						<div class="uo-license-content-info">
							
							<?php  ?>

								<div class="uo-license-content-title">
									
									<?php

										if ( $license_is_active ){
											_e( 'Your License is Active!', 'uncanny-automator' );
										}
										else {
											_e( 'Your License is Not Active!', 'uncanny-automator' );
										}

									?>
								</div>

							<div class="uo-license-content-description">

								<?php 

									switch ( $license_check ){
										case 'valid':
											break;
										
										case 'empty':
											_e( 'Please enter a valid license code and click "Activate now".', 'uncanny-automator' );
											break;

										case 'expired':
											printf( _x( 'Your license has expired. Please %s to get instant access to updates and support.', 'Your license has expired. Please renew your license to get instant access to updates and support.', 'uncanny-automator' ), sprintf( '<a href="%s" target="_blank">%s</a>', '#', _x( 'renew your license', 'Your license has expired. Please renew your license to get instant access to updates and support.', 'uncanny-automator' ) ) );
											break;

										case 'disabled':
											printf( _x( 'Your license is disabled. Please %s to get instant access to updates and support.', 'Your license has disabled. Please renew your license to get instant access to updates and support.', 'uncanny-automator' ), sprintf( '<a href="%s" target="_blank">%s</a>', '#', _x( 'renew your license', 'Your license has expired. Please renew your license to get instant access to updates and support.', 'uncanny-automator' ) ) );
											break;

										case 'invalid':
										case 'inactive':
											_e( 'The license code you entered is invalid.', 'uncanny-automator' );
											break;
									}

								?>

							</div>

							<div class="uo-license-content-form">

								<?php if ( $license_is_active ){ ?>
								
									<input id="uo-license-field" name="uap_automator_license_key" type="password" value="<?php esc_attr_e( $license ); ?>" placeholder="<?php _e( 'Enter your Uncanny Automator Lite license key', 'uncanny-automator' ); ?>" required>

								<?php } else { ?>
				
									<input id="uo-license-field" name="uap_automator_license_key" type="text" value="<?php esc_attr_e( $license ); ?>" placeholder="<?php _e( 'Enter your Uncanny Automator Lite license key', 'uncanny-automator' ); ?>" required>

								<?php } ?>

								<div class="uo-license-content-form__notice">
									<?php echo str_replace( '{{', '<strong>', str_replace( '}}', '</strong>', _x( 'If you purchased Uncanny Automator Pro, first activate the Uncanny Automator Pro plugin, {{then}} enter your Pro license key.', 'Words between double curly braces will be bold', 'uncanny-automator' ))); ?>
								</div>
								
							</div>

							<div class="uo-license-content-mobile-buttons">
								
								<?php if ( $license_is_active ){ ?>

									<button type="submit" name="uap_automator_license_deactivate" class="uo-license-btn uo-license-btn--error">
										<?php _e( 'Deactivate License', 'uncanny-automator' ); ?>
									</button>

								<?php } else { ?>

									<button type="submit" name="uap_automator_license_activate" class="uo-license-btn uo-license-btn--primary">
										<?php _e( 'Activate now', 'uncanny-automator' ); ?>
									</button>

									<a href="<?php echo $buy_new_license; ?>" target="_blank" class="uo-license-btn uo-license-btn--secondary">
										<?php _e( 'Buy license', 'uncanny-automator' ); ?>
									</a>

								<?php } ?>

							</div>

						</div>
						<div class="uo-license-content-faq">
							<div class="uo-license-content-title">
								<?php _e( 'Need help?', 'uncanny-automator' ); ?>
							</div>

							<div class="uo-license-content-faq-list">
								<ul class="uo-license-content-faq-list-ul">
									<li class="uo-license-content-faq-item">
										<a href="<?php echo $where_to_get_my_license; ?>" target="_blank">
											<?php _e( 'Where to get my license key', 'uncanny-automator' ); ?>
										</a>
									</li>
									<li class="uo-license-content-faq-item">
										<a href="<?php echo $buy_new_license; ?>" target="_blank">
											<?php _e( 'Buy a new license', 'uncanny-automator' ); ?>
										</a>
									</li>
									<li class="uo-license-content-faq-item">
										<a href="<?php echo $knowledge_base; ?>" target="_blank">
											<?php _e( 'Knowledge Base', 'uncanny-automator' ); ?>
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>
					<div class="uo-license-content-footer">

						<?php if ( $license_is_active ){ ?>

							<button type="submit" name="uap_automator_license_deactivate" class="uo-license-btn uo-license-btn--error">
								<?php _e( 'Deactivate License', 'uncanny-automator' ); ?>
							</button>

						<?php } else { ?>

							<button type="submit" name="uap_automator_license_activate" class="uo-license-btn uo-license-btn--primary">
								<?php _e( 'Activate now', 'uncanny-automator' ); ?>
							</button>

							<a href="<?php echo $buy_new_license; ?>" target="_blank" class="uo-license-btn uo-license-btn--secondary">
								<?php _e( 'Buy license', 'uncanny-automator' ); ?>
							</a>

						<?php } ?>

					</div>

				</form>

			</div>
		</div>
	</div>
</div>