//
//  DeviceInfo.swift
//  Orbis
//
//  Created by KALSI on 7/3/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import CoreTelephony

class DeviceInfo: UIViewController {
    @IBOutlet weak var deviceId: UILabel!
    @IBOutlet weak var model: UILabel!
    @IBOutlet weak var version: UILabel!
    @IBOutlet weak var carrier: UILabel!

    // MARK: -
    override func viewDidLoad() {
        super.viewDidLoad()
        deviceId.text = UIDevice.current.identifierForVendor!.uuidString
        model.text = UIDevice.current.modelName
        version.text = UIDevice.current.systemVersion
        carrier.text = CTTelephonyNetworkInfo().subscriberCellularProvider?.carrierName
        
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    // MARK: -
    @IBAction func GoBack(_ sender: Any) {
        self.navigationController?.popViewController(animated: true)
    }
    
}

