<?php

Class Users extends CI_Model
{
	public $username;
	public $password;
	public $number;
	public $deviceID;
	public $device_token;
	public $device_type;
	public $ref;
	public $ref_id;
	public $device_id;
	public $lat;
	public $long;
	public $token;
	public $status;
	public $app_type;

	function __construct() 
	{
		parent::__construct();
		$this->load->helper(array('form', 'url'));
		$this->mysql = $this->load->database('mysql',true);
		//$this->odbc = $this->load->database('odbc',true);
	}

	function get_login()
	{
		$query_mysql =  $this->mysql->select('*')->from('operators')->where([ 'number' => trim($this->number) ])->get()->first_row('array');
		//echo $this->mysql->last_query(); die('-----');
		if(  $query_mysql['ref']!="" )
		{
			return $this->mysql->select('ref, loginname,fullname, accesslevel,number,imei_no, otp, is_verified, lastin, lastout, custref, depot,type, logintype, costcentre , contractarea, office, emailaddress, createdate, termsagree, user_image')->from('operators')->where([ 'number' => trim($this->number)])->get()->first_row('array');
		}
	}

	// Update OTP
	function update_otp()
	{
		$data['otp'] = $this->otp;
		$this->mysql->where('ref', $this->ref);
		$this->mysql->update('operators', $data);
	}

	function verified_otp()
	{
		$get_result = $this->mysql->select('ref')->from('operators')->where([ 'number' => trim($this->number), 'otp' => $this->otp ])->get()->first_row('array');
		if( $get_result['ref'] )
		{
			//$data['ref'] = $get_result['ref'];
			$data['device_token'] = $this->device_token;
			$data['device_type'] = $this->device_type;
			$data['is_verified'] = '1';
			$data['device_id'] = $this->device_id;
			$data['app_type'] = $this->app_type;
			$data['lastin'] = date( 'Y-m-d H:i:s' );
			//debug($data,1);
			return $this->mysql->where('ref', $get_result['ref'])->update('operators', $data);
		}

		//return $get_result;
	}

	// update token of logged in user
	function update_user_token()
	{
		$data['token'] = $this->token;
		$data['lastin'] = date( 'Y-m-d H:i:s' );
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);
	}

	function user_logout()
	{
		$data['token'] = " ";
		$data['lastout'] = date('Y-m-d H:i:s');
		$data['otp'] = "0";
		$data['is_verified'] = "0";
		$this->mysql->where('ref', $this->ref);
		return $this->mysql->update('operators', $data);

	}

	function update_location()
	{
		$data['ref_id'] = $this->ref_id;
		$data['lat'] = $this->lat;
		$data['long'] = $this->long;
		$data['status'] = $this->status;
		$data['create_date'] = date('Y-m-d h:i:s');
		$this->mysql->insert('location', $data);
		return $insert_id = $this->mysql->insert_id();
	}

	function get_lwd_setting()
	{
		$get_setting_id = $this->mysql->select('*')->from('operators')->where([ 'ref' => $this->ref ])->get()->first_row();
		if( $get_setting_id->setting_id )
		{
			return $this->mysql->select("*")->from('settings')->where( [ 'id' => $get_setting_id->setting_id ] )->get()->first_row('array');
		}
		else
		{
			return false;
		}
	}

	function get_signal_status()
	{
		return $this->mysql->select("signal_kill")->from('operators')->where(' ref ', $this->ref)->get()->first_row('array');
	}

	function download_profile()
	{
		return $this->mysql->select('fullname,number,emailaddress,address,name1,phone_number1,name2,phone_number2,name3,phone_number3')->from('operators')->join('escalation_detail' ,'operators.ref = escalation_detail.ref_id', 'left' )->where('operators.ref', $this->ref)->get()->first_row('array');
	}
	

}