<?php

Class Users extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
		$this->mysql = $this->load->database('mysql', true);
	}

	function count_cost_center()
	{
		return $this->mysql->count_all('newcostcentres');
	}

	function count_contract_area()
	{
		return $this->mysql->count_all('newcontractareas');
	}

	function count_office()
	{
		return $this->mysql->count_all('newoffices');
	}

	function count_lwd()
	{
		return $this->mysql->select('*')->from('user')->order_by('create_at', 'desc')->get()->result_array();
	}

	function get_office_lwd()
	{
		return $this->mysql->select('*')->from('operators')->where(['office' => '23'])->get()->result_array();
	}

	function get_system_users_list($limit,  $offset =null  )
	{
		return $this->mysql->select('*')->from('user')->limit( $limit , $offset )->order_by('create_at', 'desc')->get()->result_array();
	}

	function get_user_data($id)
	{
		return $this->mysql->select('*')->from('user')->where('user_id' , $id)->get()->first_row('array');
	}

	function add_system_user($data)
	{
		// event_log
		$row['log_name'] = "add new user";
		$row['user_type'] = "1";
		$this->mysql->insert('logs',$row);
		// add user
		unset($data['edit_user_id']);
		$this->mysql->insert('user',$data);
		return $this->mysql->insert_id();
	}

	function edit_system_user($data,$id)
	{
		unset($data['edit_user_id']);
		if( !isset($data['lone_read']) )
		{
			$data['lone_read'] = '0';
		}
		if( !isset($data['lone_write']) )
		{
			$data['lone_write'] = '0';
		}
		if( !isset($data['report_write']) )
		{
			$data['report_write'] = '0';
		}
		if( !isset($data['report_read']) )
		{
			$data['report_read'] = '0';
		}
		if( !isset($data['geo_read']) )
		{
			$data['geo_read'] = '0';
		}
		if( !isset($data['geo_write']) )
		{
			$data['geo_write'] = '0';
		}
		if( !isset($data['user_read']) )
		{
			$data['user_read'] = '0';
		}
		if( !isset($data['user_write']) )
		{
			$data['user_write'] = '0';
		}

		$this->mysql->where('user_id', $id)->update('user',$data);
		//echo $this->mysql->last_query();
		return $this->mysql->affected_rows();
	}

	// get geofence
	function get_location_geofence($id)
	{
		return $this->mysql->select('area,zoomLevel')->from('officeArea')->where('officeId',$id)->get()->first_row('array');
		//echo $this->mysql->last_query();
	}

	//geofence first time
	function get_data_first_time()
	{
		return $this->mysql->select('area,zoomLevel')->from('officeArea')->order_by('create_at','desc')->get()->first_row('array');
	}

	function count_geo()
	{
		return $this->mysql->select('*')->from('geofence')->where('agency_type','1')->get()->result_array();
	}

	// add geofence Model
	function geofence_add($data)
	{
		return $this->mysql->insert('geofence',$data);
	}

	//update geofence
	function update_geofence($data,$id)
	{
		return $this->mysql->where( 'geofence_id', $id )->update( 'geofence', $data );
	}

	function delete_geofence($id)
	{
		$this->mysql->where('officeID', $id)->delete('officeArea');
		return $this->mysql->where('geofence_id',$id)->delete('geofence');
	}

	// function geofencelist($limit, $offset)
	// {
	// 	return $this->mysql->select('*')->from('geofence')->limit( $limit , $offset )->order_by('create_at', 'desc')->get()->result_array();
	// }
	function geofencelist()
	{
		return $this->mysql->select('*')->from('geofence')->order_by('create_at', 'desc')->get()->result_array();
	}
}
