<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quotation extends MY_Controller {

  function __construct()
  {
    parent::__construct();
  }

  function index()
  {
    $data['content'] = 'energy/quotation';
    $this->load->view('layout/theme_master_blue',$data);
  }

  function postcode()
  {
    $data['back_link'] = base_url();
    $this->load->view('energy/postcode',$data);
  }

  function quotefor()
  {
    $data1 = ['pcod' => $this->input->post('postcode') ];
		$response = $this->curl->curl_request('/v3.1/partner-resources/'.$this->affiliate_id.'/mpas/addresses-by-pcod/', $data1, 'post' );
    $address_list = json_decode($response,true);
    //debug($address_list);
    if($address_list['statusCode'] == '1046')
    {
        $address_data = $address_list['data']['addresses'];
        $this->session->set_userdata('address_data',$address_data);
        $this->load->view('energy/quotefor');
    }
    else {
        echo  $address_list['statusCode'];
    }
  }

  function address_list(){
    $data = array();
    $address_data = $this->session->userdata('address_data');
    //debug($address_data,1);
    if( !empty($address_data) )
    {
      for( $i=0; $i<count($address_data); $i++ )
      {
        ($address_data[$i]['dept'])? $dept = $address_data[$i]['dept'] : $dept = '';
        ($address_data[$i]['orgn'])? $orgn = $address_data[$i]['orgn'] : $orgn = '';
        ($address_data[$i]['pobx'])? $pobx = $address_data[$i]['pobx'] : $pobx = '';
        ($address_data[$i]['dept'])? $dept = $address_data[$i]['dept'] : $dept = '';
        ($address_data[$i]['subb'])? $subb = $address_data[$i]['subb'] : $subb = '';
        ($address_data[$i]['bnam'])? $bnam = $address_data[$i]['bnam'] : $bnam = '';
        ($address_data[$i]['dpth'])? $dpth = $address_data[$i]['dpth'] : $dpth = '';
        ($address_data[$i]['thor'])? $thor = $address_data[$i]['thor'] : $thor = '';
        ($address_data[$i]['ddlo'])? $ddlo = $address_data[$i]['ddlo'] : $ddlo = '';
        ($address_data[$i]['dplo'])? $dplo = $address_data[$i]['dplo'] : $dplo = '';
        ($address_data[$i]['town'])? $town = $address_data[$i]['town'] : $town = '';
        ($address_data[$i]['cnty'])? $cnty = $address_data[$i]['cnty'] : $cnty = '';
        ($address_data[$i]['pcod'])? $pcod = $address_data[$i]['pcod'] : $pcod = '';

        $address_data[$i]['address'] = $address_data[$i]['bnum']."".$dept." ".$orgn." ".$pobx." ".$subb." ".$bnam." ".$dpth." ".$thor." ".$ddlo." ".$dplo." ".$town." ".$cnty." ".$pcod;

        //electricity
        if( !empty($address_data[$i]['metersElec']) )
        {
          //$address_data[$i]['mpan'] = count($address_data[$i]['metersElec']);
          for( $m=0; $m<count($address_data[$i]['metersElec']); $m++ ){
            if( count($address_data[$i]['metersElec']) > 1 ){
              $address_data[$i]['mpan'][] = $address_data[$i]['metersElec'][$m]['mpan'];
            }
            else {
            $address_data[$i]['mpan'][] = $address_data[$i]['metersElec'][$m]['mpan'];
            }
          }
        }else {
            $address_data[$i]['mpan'] = array();
        }

        //gas
        if( !empty($address_data[$i]['metersGas']) )
        {
          //$address_data[$i]['mpan'] = count($address_data[$i]['metersElec']);
          for( $m=0; $m<count($address_data[$i]['metersGas']); $m++ ){
            if( count($address_data[$i]['metersGas']) > 1 ){
              $address_data[$i]['mprn'][] = $address_data[$i]['metersGas'][$m]['mprn'];
            }
            else {
            $address_data[$i]['mprn'][] = $address_data[$i]['metersGas'][$m]['mprn'];
            }
          }
        }else {
            $address_data[$i]['mprn'] = array();
        }

        //unset some array value
        // $address_data[$i]['metersGas'];
        // $address_data[$i]['metersElec'];
        // $address_data[$i]['gsps'];
        // $address_data[$i]['postcodeMapping'];
      }
      $data['address_list'] = $address_data;
    }
    $this->load->view('energy/address_list',$data);
  }

  function payEnergy()
  {
    $this->load->view('energy/pay_energy');
  }

  function know_supplier()
  {
      $this->load->view('energy/know_supplier');
  }

  function hear_about()
  {
    $this->load->view('energy/hear_about');
  }

  function select_supplier(){
    //get supplier list
    $response = $this->curl->curl_request('/v3.1/partner-resources/'.$this->affiliate_id.'/suppliers/', [], 'post' );
    $supplier_list = json_decode($response,true);
    //debug($supplier_list);
    if( !empty($supplier_list) ){
      if( $supplier_list['statusCode'] == '1013' )
      {
        $data['supplier_data'] = $supplier_list['data']['suppliers'];
      }
    }
    else {
      $data['supplier_data'] = array();
    }
    //debug($data,1);
    $this->load->view('energy/select_supplier',$data);
  }

  function get_tariff()
  {
    $parameter = ['supplierName' => $this->input->post('elec_supplier') ];
    //$parameter = ['supplierName' => 'abc energy' ];
    $quotation_for = $this->input->post('quotation_for');
    if( $quotation_for=='both' )
    {
      $quotation_for = 'elecgas';
    }
    if( $quotation_for=='electricity' )
    {
      $quotation_for = 'elec';
    }
    $data = array();
    $response = $this->curl->curl_request('/v3.1/partner-resources/'.$this->affiliate_id.'/tariffs/', $parameter, 'post' );
    $tariff_list = json_decode($response,true);
    //debug($tariff_list,1);
    //echo '==='.count($tariff_list['data']['tariffs']);
    if( $tariff_list['statusCode'] == '1040' )
    {
      for( $t=0; $t<count($tariff_list['data']['tariffs']); $t++ )
      {
          //echo $quotation_for == $tariff_list['data']['tariffs'][$t]['fuelType'];
          if( $quotation_for == $tariff_list['data']['tariffs'][$t]['fuelType'] ){
            //debug($tariff_list['data']['tariffs'][$t]);
            $data[] = $tariff_list['data']['tariffs'][$t];
          }
      }
      if( empty($data) )
      {
          $data = array();
      }
      echo json_encode([ 'error' => '0', 'data' => $data ]);
    }
    if( $tariff_list['statusCode'] == '2000' )
    {
      echo json_encode([ 'error' => '1', 'data' => $tariff_list['errors']['supplierName'] ]);
    }
    if( $tariff_list['statusCode'] == '2025' )
    {
      echo json_encode([ 'error' => '2', 'data' => $tariff_list['message'] ]);
    }
  }

  function current_energy()
  {
    $this->load->view('energy/current_energy');
  }

  function home_type()
  {
    $this->load->view('energy/home_type');
  }

  function enter_energy()
  {
    $this->load->view('energy/enter_usage');
  }

  function stop_quotation()
  {
    $this->load->view('energy/stop_page_message');
  }

  function summary()
  {

    if( $this->input->post('hasExistingSupply') == 'yes' )
    {
      //$this->input->post('hasExistingSupply') = 'true';
      $_POST['hasExistingSupply'] = 'true';
    }
    if($this->input->post('hasExistingSupply') == 'no'){
      $_POST['hasExistingSupply'] = 'false';
    }

    if( $this->input->post('quotation_pay_energy') == 'prepay' ){
        $_POST['existingPayTypesElec'] = '5';
        $_POST['desiredPayTypes'] = '5';
    }
    if( $this->input->post('quotation_pay_energy') == 'directdebit' ){
      $_POST['existingPayTypesElec'] = '1';
      $_POST['desiredPayTypes'] = '1';
    }
    if( $this->input->post('quotation_pay_energy') == 'paperbill' ){
      $_POST['existingPayTypesElec'] = '15';
      $_POST['desiredPayTypes'] = '15';
    }
    $parameter = json_encode($this->input->post(),true);
    debug($parameter);
    $response = $this->curl->curl_request('/v2.2/partner-resources/'.$this->affiliate_id.'/quotes/elec/',$this->input->post(), 'post' );
    debug(json_decode($response,true),1);
    $this->load->view('energy/summary');
  }

  function get_projection(){
	  $this->load->view('energy/switch_template');
	  
    /*if( $this->input->post('quotation_pay_energy') == 'prepay' ){
        $_POST['existingPayTypesElec'] = '5';
        $_POST['desiredPayTypes'] = '5';
    }
    if( $this->input->post('quotation_pay_energy') == 'directdebit' ){
      $_POST['existingPayTypesElec'] = '1';
      $_POST['desiredPayTypes'] = '1';
    }
    if( $this->input->post('quotation_pay_energy') == 'paperbill' ){
      $_POST['existingPayTypesElec'] = '15';
      $_POST['desiredPayTypes'] = '15';
    }



    $parameter = [
        'existingkWhsElec' => $this->input->post('elec_usage'),
        'nightUsePercentElec' => '10',
        'existingPayTypesElec' =>   $_POST['existingPayTypesElec'],
        'existingSupplierNameElec' => $this->input->post('quotation_supplier'),
        'existingTariffNameElec' => $this->input->post('quotation_tariff'),
        'meterTypeElec' => 'STD',
        'distId' => '10'
    ];
    //debug($parameter);
    $response = $this->curl->curl_request('/v2.1/partner-resources/'.$this->affiliate_id.'/projections/elec-by-annual-kwhs/',$parameter, 'post' );
    //debug(json_decode($response,true));
    $response_data = json_decode($response,true);
    if($response_data['statusCode'] == '1049' )
    {
      $this->session->set_userdata('projection_data',$response_data['data']['energySearchProfile'] );
      $this->session->set_userdata( 'signup_detail',$this->input->post() );
      $data['projection_data'] = $response_data['data'];
      $this->load->view('energy/switch_template',$data);
    }
    if( $response_data['statusCode'] == '3042' ){
        echo $response_data['statusCode'];
    }*/
  }

}
