<?php
// if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use \vendor\stripe;
require_once('./vendor/autoload.php');

class Cron extends MY_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->model('user_modal');
        $this->load->model('api_modal');
        $this->mysql = $this->load->database('mysql',true);
    }

    function parseHttpResponse($response)
    {
        // Parse the headers
        $headers = array();

        $body = null;

        // Split up the httpResponse
        $responseParts = explode("\r\n\r\n", $response);
        foreach ($responseParts as $i => $responsePart) {
            $lines = explode("\r\n", $responsePart);

            // If the part has 200 response Code, parse the rest of the lines as headers.
            //if($lines[0] == "HTTP/1.1 " )
            if (strpos($lines[0], 'HTTP/1.1') !== false) {
                if (preg_match('/^HTTP\/1.1 [4,5]/', $lines[0])) {
                    // 4xx or 5xx error
                    // so log the error
                    $this->logMessage('error', 'Line 0=' . $lines[0], 2);
                }

                foreach ($lines as $j => $line) {
                    if ($j === 0) {
                        $headers['http_code'] = $line;
                    } else {
                        list ($key, $value) = explode(': ', $line);

                        $headers[$key] = $value;
                    }
                }
            } // If last element, probably body
            else if ($i === sizeof($responseParts) - 1) {
                $body = json_decode($responsePart, true);
            }
        }

        return array(
            'headers' => $headers,
            'body' => $body
        );
    }


    // START ENROLL DYBALL METHODS

    function generate_dyball_import()
    {

        // Get any one who hasn't already been added to Dyball
        $DyballCustomerData = $this->get_new_dyball_customers();

        // Do we have any records?
        $DyballCustomerCount = count($DyballCustomerData);

        if($DyballCustomerCount>0) {
            // Yes, make the CSV (Attachment) and save file to location
            $Attachment = $this->generate_new_dyball_customer_csv($DyballCustomerData);

        }

        // Trigger email with attachment
        $forename = 'Dan & Matt';
        $recipient_email = 'dan.jones@eversmartenergy.co.uk';
        $cc_recipient_email = 'matthew.scrivens@eversmartenergy.co.uk';

        $email_data['email_info'] = ['name' => $forename, 'count' => $DyballCustomerCount];
        $email_data['email_header_img'] = 'account_header.jpg';
        $email_data['content'] = 'layout/new_dyball_customers_email_content';

        $template = $this->load->view('layout/email_template', $email_data, true);

        $this->load->library('email');
        $this->email->clear(true);
        $this->email->from('no-reply@eversmartenergy.co.uk', 'Eversmart');
        $this->email->to($recipient_email);
        $this->email->cc($cc_recipient_email);
        $this->email->subject('Dyball Customer Import');
        $this->email->message($template);
        if (!empty($Attachment)) {

            // First Log attachments in db
            $elec_data['filename'] = $Attachment['elec_filename'];
            $elec_data['generated_file_type_id'] = 1;   // Elec
            $elec_data['affected_rows'] = $DyballCustomerCount;
            $this->mysql->insert('generated_file', $elec_data);

            $gas_data['filename'] = $Attachment['gas_filename'];
            $gas_data['generated_file_type_id'] = 2;    // Gas
            $gas_data['affected_rows'] = $Attachment['dual_counter'];
            $this->mysql->insert('generated_file', $gas_data);
           
            $this->email->attach($Attachment['elec_filename']);
            $this->email->attach($Attachment['gas_filename']);
        }
        $this->email->send();
    }

    function get_new_dyball_customers(){

        $DyballCustomerData = $this->mysql->select('*')->from('customer_info')
            ->where(array('billingMethod' => 'prepay', 'dyball_import_success' => NULL))
            ->get()->result_array();
        return $DyballCustomerData;
    }

    function generate_new_dyball_customer_csv($DyballCustomerData) {

        // Create filename
        $elec_filename = 'assets/temp_csv/elec_dyball_import_'.date('dmYHi').'.csv';
        $gas_filename = 'assets/temp_csv/gas_dyball_import_'.date('dmYHi').'.csv';

        // Set location
        $elec_file = fopen( $elec_filename, 'wb');
        $gas_file = fopen( $gas_filename, 'wb');


        // Set the column headers -
        $DyballCustomerHeadings = array();
        $DyballCustomerHeadings[] = 'TYPE';
        $DyballCustomerHeadings[] = 'CUSTID';
        $DyballCustomerHeadings[] = 'NAME';
        $DyballCustomerHeadings[] = 'Profile Class';
        $DyballCustomerHeadings[] = 'MTC';
        $DyballCustomerHeadings[] = 'LLF';
        $DyballCustomerHeadings[] = 'SSC';
        $DyballCustomerHeadings[] = 'Energisation Status';
        $DyballCustomerHeadings[] = 'MPAN';
        $DyballCustomerHeadings[] = 'SP'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'START';
        $DyballCustomerHeadings[] = 'CONTACTNAME';
        $DyballCustomerHeadings[] = 'CONTACTTEL';
        $DyballCustomerHeadings[] = 'CONTACTFAX'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'RETRIEVALMETHOD';
        $DyballCustomerHeadings[] = 'REGULARREADCYCLE';
        $DyballCustomerHeadings[] = 'ESTANNUALCONSUMPTION';
        $DyballCustomerHeadings[] = 'MEASUREMENTCLASSID';
        $DyballCustomerHeadings[] = 'METERPOINTADD1'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'METERPOINTADD2'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'House Number';
        $DyballCustomerHeadings[] = 'METERPOINTADD4'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'Street';
        $DyballCustomerHeadings[] = 'METERPOINTADD6'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'Locality';
        $DyballCustomerHeadings[] = 'Town';
        $DyballCustomerHeadings[] = 'County';
        $DyballCustomerHeadings[] = 'Post Code';
        $DyballCustomerHeadings[] = 'MAILADD1'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'MAILADD2'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'House Number';
        $DyballCustomerHeadings[] = 'MAILADD4'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'Street';
        $DyballCustomerHeadings[] = 'MAILADD6'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'MAILADD7'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'Town';
        $DyballCustomerHeadings[] = 'County';
        $DyballCustomerHeadings[] = 'MAILPOSTCODE';
        $DyballCustomerHeadings[] = 'DCAGENT';
        $DyballCustomerHeadings[] = 'DCAGTYPE';
        $DyballCustomerHeadings[] = 'DCCONTREF';
        $DyballCustomerHeadings[] = 'DCSERVREF';
        $DyballCustomerHeadings[] = 'DCSERVLEVREF';
        $DyballCustomerHeadings[] = 'MOAGENT';
        $DyballCustomerHeadings[] = 'MOAGTYPE';
        $DyballCustomerHeadings[] = 'MOCONTREF';
        $DyballCustomerHeadings[] = 'MOSERVREF';
        $DyballCustomerHeadings[] = 'MOSERVLEVREF';
        $DyballCustomerHeadings[] = 'DAAGENT';
        $DyballCustomerHeadings[] = 'DAAGTYPE';
        $DyballCustomerHeadings[] = 'DACONTREF';
        $DyballCustomerHeadings[] = 'DASERVREF';
        $DyballCustomerHeadings[] = 'DASERVLEVREF';
        $DyballCustomerHeadings[] = 'COTIND'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'DELMAILADDHELD'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'CUSTPASSWORD'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'CUSTPASSEFFDATE'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'MAXPOWERREQ'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'SPECIALACCESS'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'ADDITIONALINFO'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'SPECIALNEEDSIND'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'Salesman'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'Email'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pps contact'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pps phone1'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pps phone2'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'alternate contact name'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'alternate phone1'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'alternate phone2'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress1'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress2'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress3'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress4'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress5'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress6'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress7'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress8'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'pscaddress9'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'psc postcode'; // ## NOT REQUIRED ##
        $DyballCustomerHeadings[] = 'Special Needs Additional Info'; // ## NOT REQUIRED ##

        fputcsv($elec_file, $DyballCustomerHeadings);
        fputcsv($gas_file, $DyballCustomerHeadings);


        // Update user customer record success flag
        $db_parameter = ['dyball_import_success' => 1 ];

        // Initiate the gas counter 
        $DualCustomer = 0;

        // output each row of the data
        foreach ($DyballCustomerData as $row) {



            // WE WILL NEED TO AMEND THE DATA AT THIS STAGE
            $DyballCustomer = array();
            $DyballCustomer[] = '';             // ## NOT REQUIRED (may need to be 'NC' for new connection) ## - TYPE
            $DyballCustomer[] = $row['id'];     // CUSTID
            $DyballCustomer[] = $row['title']. ' ' .$row['forename']. ' ' .$row['surname']; //NAME
            $DyballCustomer[] = substr($row['electricityProduct_mpans'], 1, 1); //Profile Class
            $DyballCustomer[] = substr($row['electricityProduct_mpans'], 2, 3); //MTC
            $DyballCustomer[] = substr($row['electricityProduct_mpans'], 5, 3); //LLF
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - SSC
            $DyballCustomer[] = 'D';            // ## HARDCODED ## - Energisation Status
            $DyballCustomer[] = $row['elec_mpan_core']; //MPAN
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - SP
            $DyballCustomer[] = date('d/m/Y', strtotime($row['start_date'])); // START
            $DyballCustomer[] = $row['forename']. ' ' .$row['surname']; //CONTACTNAME
            $DyballCustomer[] = $row['phone1']; //CONTACTTEL
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - CONTACTFAX
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - RETRIEVALMETHOD
            $DyballCustomer[] = 'Q';            // ## HARDCODED ## - REGULARREADCYCLE
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - ESTANNUALCONSUMPTION
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - MEASUREMENTCLASSID
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - METERPOINTADD1
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - METERPOINTADD2
            $DyballCustomer[] = $row['first_line_address']; // House Number
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - METERPOINTADD4
            $DyballCustomer[] = $row['dplo_address']; // Street
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - METERPOINTADD6
            $DyballCustomer[] = $row['town_address']; // Locality
            $DyballCustomer[] = $row['town_address']; // Town
            $DyballCustomer[] = $row['city_address']; // County
            $DyballCustomer[] = $row['address_postcode']; //Post Code
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - MAILADD1
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - MAILADD2
            $DyballCustomer[] = $row['first_line_address']; //House Number
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - MAILADD4
            $DyballCustomer[] = $row['dplo_address']; // Street
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - MAILADD6
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - MAILADD7
            $DyballCustomer[] = $row['town_address']; // Town
            $DyballCustomer[] = $row['city_address']; // County
            $DyballCustomer[] = $row['address_postcode']; // MAILPOSTCODE
            $DyballCustomer[] = 'UDMS';         // ## HARDCODED ## - DCAGENT
            $DyballCustomer[] = 'N';            // ## HARDCODED ## - DCAGTYPE
            $DyballCustomer[] = 'ENGQNDC001';   // ## HARDCODED ## - DCCONTREF
            $DyballCustomer[] = 'ENDC';         // ## HARDCODED ## - DCSERVREF
            $DyballCustomer[] = 'NDC1';         // ## HARDCODED ## - DCSERVLEVREF
            $DyballCustomer[] = 'FUML';         // ## HARDCODED ## - MOAGENT
            $DyballCustomer[] = 'N';            // ## HARDCODED ## - MOAGTYPE
            $DyballCustomer[] = 'EVERSMTE01';   // ## HARDCODED ## - MOCONTREF
            $DyballCustomer[] = 'ESS1';         // ## HARDCODED ## - MOSERVREF
            $DyballCustomer[] = 'ESL1';         // ## HARDCODED ## - MOSERVLEVREF
            $DyballCustomer[] = 'UDMS';         // ## HARDCODED ## - DAAGENT
            $DyballCustomer[] = 'N';            // ## HARDCODED ## - DAAGTYPE
            $DyballCustomer[] = 'ENGQNDA001';   // ## HARDCODED ## - DACONTREF
            $DyballCustomer[] = 'ENDA';         // ## HARDCODED ## - DASERVREF
            $DyballCustomer[] = 'NDA1';         // ## HARDCODED ## - DASERVLEVREF
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - COTIND
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - DELMAILADDHELD
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - CUSTPASSWORD
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - CUSTPASSEFFDATE
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - MAXPOWERREQ
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - SPECIALACCESS
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - ADDITIONALINFO
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - SPECIALNEEDSIND
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - Salesman
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - Email
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pps contact
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pps phone1
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pps phone2
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - alternate contact name
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - alternate phone1
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - alternate phone2
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress1
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress2
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress3
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress4
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress5
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress6
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress7
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress8
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - pscaddress9
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - psc postcode
            $DyballCustomer[] = '';             // ## NOT REQUIRED ## - Special Needs Additional Info

            
            // If dyb_dual customer
            if($row['prefix'] == 'DYB_DUAL_') {  
                if(fputcsv($gas_file, $DyballCustomer)){

                    // Increment Dual Cust count for db
                    $DualCustomer++;
                }
                else {
                    die('Dual - Something happened during the write of the line '. $row['id']);
                }
            }

            // Everyone goes into elec
            if(fputcsv($elec_file, $DyballCustomer)){

                // Update record
                $this->user_modal->update_customer_info($db_parameter,$row['id']);
            }
            else {
                die('Elec - Something happened during the write of the line '. $row['id']);
            }

        }

        return array('elec_filename' => $elec_filename, 'gas_filename' => $gas_filename, 'dual_counter' => $DualCustomer);
    }

    // END ENROLL DYBALL METHOD



    // START MONTHLY INTEREST METHODS

    function get_monthly_interest_customers(){

        // Get anyone who has signed up within the last year
        $MICustomerData = $this->mysql->query('SELECT id, account_id FROM `customer_info` where `monthly_interest_customer_signup_date` >= DATE_SUB(NOW(),INTERVAL 1 YEAR)')->result_array();
        return $MICustomerData;
    }

    function monthly_interest_calculation(){

        // Get any one who is a monthly interest customer who has signed up within a year
        $MICustomerData = $this->get_monthly_interest_customers();

        // Do we have any records?
        $MICustomerCount = count($MICustomerData);

        if($MICustomerCount>0) {

            // loop through each row of the data
            foreach ($MICustomerData as $row) {

                // Get month end total credit
                $get_balance_junifer = $this->curl->junifer_request('/rest/v1/accounts/'.$row['account_id'].'');
                $get_balance_junifer = $this->parseHttpResponse($get_balance_junifer);

                // If we find the balance, work out the percentage
                if($get_balance_junifer['headers']['http_code'] == 'HTTP/1.1 200 OK') {

                    // 1% Calculation
                    $MonthlyInterest = ($get_balance_junifer['body']['balance']>0?0:(abs($get_balance_junifer['body']['balance']) / 100));

                    // Set up parameters
                    $db_parameter = ['customer_id' => $row['id'], 'monthly_interest' => $MonthlyInterest ];

                    // Add record to database
                    $this->user_modal->insert_customer_monthly_interest($db_parameter);
                }
            }


        }


    }

    // END MONTHLY INTEREST METHODS



    // START JUNIFER YEARLY PAYMENTS

    function customer_payment() {

        // find any registered yearly pay customers that registered at least 14 days ago AND have not had a successful / failed payment already
        $CustomerData = $this->find_yearly_pay_customers();

        // Do we have any records?
        $CustomerCount = count($CustomerData);

        if($CustomerCount>0) {

            $currency = 'gbp';

            $stripe = array(
                "secret_key"      => $this->config->item('stripe')['sk_test'],
                "publishable_key" => $this->config->item('stripe')['pk_test']
            );

            // loop through each customer record
            foreach ($CustomerData as $row) {


                //extract data from the post
                $url = 'https://webto.salesforce.com/servlet/servlet.WebToCase?encoding=UTF-8';
                $fields = array(
                    'orgid' => urlencode('00D1l0000008d2T'),
                    'name' => urlencode($row['title'] . ' ' . $row['forename'] . ' ' . $row['surname']),
                    'email' => urlencode($row['email']),
                    'phone' => urlencode($row['phone1']),
                    'dob' => urlencode($row['dateOfBirth']),
                    'address' => urlencode($row['first_line_address']),
                    'postcode' => urlencode($row['address_postcode']),
                    'junifer_customer_id' => urlencode($row['account_id']),
                    'dyball_account_id' => urlencode(''),
                    'external_system_registration_status' => urlencode('Other')
                );

                //url-ify the data for the POST
                $fields_string = '';

                // use email to find token (card)
                try {

                    \Stripe\Stripe::setApiKey($stripe['secret_key']);

                    // Does the customer already exist?
                    $customer = \Stripe\Customer::all(array("email" => $row['email'], "limit" => 1));

                    // If we find a record
                    if(!empty($customer['data'])) {

                        $stripe_customer_id = $customer['data'][0]['id'];
                        $stripe_customer_token = $customer['data'][0]['default_source'];
                        $stripe_amount = $row['tariff_newspend'] * 100;

                        $charge = \Stripe\Charge::create(array(
                            'customer' => $stripe_customer_id,
                            'amount' => $stripe_amount,
                            'source' => $stripe_customer_token,
                            'currency' => $currency,
                        ));

                        // on success - NO web to case required - send success email to customer
                        if ($charge['status'] == 'succeeded' && isset($stripe_customer_id)) {

                            // Update user customer record payment success flag
                            $db_parameter = ['first_payment_status_type_id' => 1];
                            $this->user_modal->update_customer_info($db_parameter, $row['id']);

                            $response['account_id'] = $row['account_id'];
                            $response['amount'] = $row['amount'];

                            $row = [
                                'transaction_id' => $charge['id'],
                                'amount' => $row['amount'],
                                'currency' => $currency,
                                'status' => $charge['status'],
                                'account_id' => $response['account_id']
                            ];

                            $post = [
                                "grossAmount" => $row['amount'],
                                "salesTaxName" => "Standard VAT",
                                "accountDebitReasonName" => "Saasquatch Referral"
                            ];


                            $junifer_credit = $this->curl->junifer_request('/rest/v1/accounts/' . $response['account_id'] . '/accountDebits', $post, 'post');

                            $get_head = $this->parseHttpResponse($junifer_credit);

                            $this->api_modal->save_transaction($row);

                            if ($get_head['headers']['http_code'] == 'HTTP/1.1 204 No Content') {
                                $this->jres->success_stripe($response, $charge['status']);
                            }
                            else {
                                $this->jres->failure('Error while payment in stripe');

                                // Update user customer record payment failed flag
                                $db_parameter = ['first_payment_status_type_id' => 2];
                                $this->user_modal->update_customer_info($db_parameter, $row['id']);

                                // SEND WEB TO CASE - open connection
                                $fields['subject'] = urlencode('Failed Payment - Junifer Customer ID:' . $response['account_id'] . ' - Failed');
                                $fields['description'] = urlencode('Failed Payment - Payment error in Stripe for ' . $row['forename'] . ' ' . $row['surname']);

                                foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
                                $fields_string = rtrim($fields_string, '&');

                                $ch = curl_init();
                                if( $_SERVER['HTTP_HOST'] == '127.0.0.1:8000' ) {
                                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                                }
                                //set the url, number of POST vars, POST data
                                curl_setopt($ch,CURLOPT_URL, $url);
                                curl_setopt($ch,CURLOPT_POST, count($fields));
                                curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
                                curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);

                                //execute post
                                $result = curl_exec($ch);

                                if ($result === FALSE) {
                                    echo 'WebToCase error has occurred: ' . curl_error($ch) . PHP_EOL;
                                }
                                else {
                                    echo $result;
                                }

                                //close connection
                                curl_close($ch);

                            }

                        } // on fail - web to case - send failed email (unless salesforce can handle this HAHAHAHAHA)
                        else {

                            // Update customer record if payment failed
                            $db_parameter = ['first_payment_status_type_id' => 2];
                            $this->user_modal->update_customer_info($db_parameter, $row['id']);

                            // SEND WEB TO CASE - open connection
                            $fields['subject'] = urlencode('Failed Payment - Junifer Customer ID:' . $row['account_id'] . ' - Failed');
                            $fields['description'] = urlencode('Failed Payment - Charge failed in Stripe for ' . $row['forename'] . ' ' . $row['surname']);

                            foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
                            $fields_string = rtrim($fields_string, '&');

                            $ch = curl_init();
                            if( $_SERVER['HTTP_HOST'] == '127.0.0.1:8000' ) {
                                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                            }
                            //set the url, number of POST vars, POST data
                            curl_setopt($ch,CURLOPT_URL, $url);
                            curl_setopt($ch,CURLOPT_POST, count($fields));
                            curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
                            curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);

                            //execute post
                            $result = curl_exec($ch);

                            if ($result === FALSE) {
                                echo 'WebToCase error has occurred: ' . curl_error($ch) . PHP_EOL;
                            }
                            else {
                                echo $result;
                            }

                            //close connection
                            curl_close($ch);
                        }
                    }
                    else {

                        // Update customer record if no customer found
                        $db_parameter = ['first_payment_status_type_id' => 2];
                        $this->user_modal->update_customer_info($db_parameter, $row['id']);

                        // SEND WEB TO CASE - open connection
                        $fields['subject'] = urlencode('Failed Payment - Junifer Customer ID:' . $row['account_id'] . ' - Failed');
                        $fields['description'] = urlencode('Failed Payment - No account found for ' . $row['email']);

                        foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
                        $fields_string = rtrim($fields_string, '&');


                        $ch = curl_init();
                        if( $_SERVER['HTTP_HOST'] == '127.0.0.1:8000' ) {
                            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                        }
                        //set the url, number of POST vars, POST data
                        curl_setopt($ch,CURLOPT_URL, $url);
                        curl_setopt($ch,CURLOPT_POST, count($fields));
                        curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
                        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);

                        //execute post
                        $result = curl_exec($ch);

                        if ($result === FALSE) {
                            echo 'WebToCase error has occurred: ' . curl_error($ch) . PHP_EOL;
                        }
                        else {
                            echo $result;
                        }

                        //close connection
                        curl_close($ch);
                    }

                }
                catch( Stripe_Error $e )
                {

                    // Update customer record if stripe failed
                    $db_parameter = ['first_payment_status_type_id' => 2 ];
                    $this->user_modal->update_customer_info($db_parameter, $row['id']);

                    // SEND WEB TO CASE - open connection
                    $fields['subject'] = urlencode('Failed Payment - Junifer Customer ID:' . $row['account_id'] . ' - Failed');
                    $fields['description'] = urlencode('Failed Payment - Stripe failed for ' . $row['forename'] . ' ' . $row['surname']);

                    foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
                    $fields_string = rtrim($fields_string, '&');

                    $ch = curl_init();
                    if( $_SERVER['HTTP_HOST'] == '127.0.0.1:8000' ) {
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                    }
                    //set the url, number of POST vars, POST data
                    curl_setopt($ch,CURLOPT_URL, $url);
                    curl_setopt($ch,CURLOPT_POST, count($fields));
                    curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
                    curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);

                    //execute post
                    $result = curl_exec($ch);

                    if ($result === FALSE) {
                        echo 'WebToCase error has occurred: ' . curl_error($ch) . PHP_EOL;
                    }
                    else {
                        echo $result;
                    }

                    //close connection
                    curl_close($ch);
                }

            } // End customer loop

        } // End if customers found

    }

    function find_yearly_pay_customers(){

        // find any registered customer (api_user_status = 1) yearly pay customers( monthly_interest_customer_signup_date IS NOT NULL)
        // that registered at least 14 days ago AND have not had a successful / failed payment already
        $CustomerData = $this->mysql->select('id, account_id, title, forename, surname, email, phone1, dateOfBirth, first_line_address, address_postcode, tariff_newspend')->from('customer_info')
            ->where('api_user_status = \'1\' 
                AND monthly_interest_customer_signup_date IS NOT NULL 
                AND UNIX_TIMESTAMP(`monthly_interest_customer_signup_date`) < UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 5 DAY))
                AND first_payment_status_type_id IS NULL')
            ->get()->result_array();
        return $CustomerData;

    }

    // END JUNIFER YEARLY PAYMENTS

}
