<?php // if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('user_modal');
        $this->mysql = $this->load->database('mysql', true);
    }


    // Web to case
    function webtocase(){

        $customerdata['status_type'] = $this->input->post('status_type');
        $customerdata['signup_type'] = $this->input->post('signup_type');

        if($this->input->post('signup_type')==0){ // Junifer

            $customerdata['customer'] = $this->get_random_junifer_customer();
            $customerdata['signup_type'] = 0;
            $customerdata['junifer_customer_id'] = $customerdata['customer']['account_id'];
            $customerdata['dyball_account_id'] = '';
            $customerdata['subject'] = ($customerdata['status_type']?$customerdata['status_type']:'Meter Booking').' - Junifer Customer ID: ' . $customerdata['junifer_customer_id'] . ' - '.(strstr($customerdata['status_type'],'Pending')?'Pending':'Success');
            $customerdata['description'] = ($customerdata['status_type']?$customerdata['status_type']:'Meter Booking').' request for ' . $customerdata['customer']['forename'] . ' ' . $customerdata['customer']['surname'];
        }
        else if ($this->input->post('signup_type')==3) { // Dyball

            $customerdata['customer'] = $this->get_random_dyball_customer();
            $customerdata['signup_type'] = 3;
            $customerdata['dyball_account_id'] = $customerdata['customer']['dyball_account_id'];
            $customerdata['junifer_customer_id'] = '';


            $customerdata['subject'] = ($customerdata['status_type']?$customerdata['status_type']:'Meter Booking').' - Dyball Account Number: ' . $customerdata['dyball_account_id'] . ' - ' . (strstr($customerdata['status_type'],'Pending')?'Pending':'Success');
            $customerdata['description'] = ($customerdata['status_type']?$customerdata['status_type']:'Meter Booking').' request for ' . $customerdata['customer']['forename'] . ' ' . $customerdata['customer']['surname'];
        }

        $admin_data['page_ref'] = 'webtocase';
        $admin_data['page_title'] = 'Web To Case';
        $admin_data['content']['output'] = $this->load->view('admin/webtocase', $customerdata, true);
        $this->load->view('layout/admin_template',$admin_data);
    }


    function get_random_junifer_customer(){
        return $this->mysql->select('*')->from('customer_info')->where('billingMethod','directdebit')->order_by('id','RANDOM')->limit(1)->get()->first_row('array');
    }

    function get_random_dyball_customer(){
        return $this->mysql->select('*')->from('customer_info')->where('billingMethod','prepay')->order_by('id','RANDOM')->limit(1)->get()->first_row('array');
    }


    function customer_signup(){
        $customerdata = array();

        $admin_data['page_ref'] = 'customeradmin';
        $admin_data['page_title'] = 'Customer Admin';
        $this->load->view('admin/customer_signup',$admin_data);
    }


    
    function address_lookup()
    {
        $response = $this->curl->curl_request('/v3.1/partner-resources/'.$this->affiliate_id.'/mpas/addresses-by-pcod/', $this->input->post(), 'post' );
        $address_list = json_decode($response,true);

        if($address_list['statusCode'] == '1046')
        {
            $address_data = array();
            $address_data1 = $address_list['data']['addresses'];

            for( $mm=0; $mm<count($address_data1); $mm++ )
            {

                for( $j=0; $j<count( $address_data1[$mm]['metersElec'] ); $j++ )
                {
                    if( $address_data1[$mm]['metersElec'][$j]['mpanProfileClass'] != '03' )
                    {
                        $address_data[] = $address_data1[$mm];
                    }
                }
            }
            $this->session->set_userdata('address_data',$address_data);
        }
        else 
        {
          echo  $address_list['statusCode'];
        }
        $this->address_list();
    }
    
    function address_list()
    {
      $data = array();
      $address_data = $this->session->userdata('address_data');
      
      if( !empty($address_data) )
      {
        for( $i=0; $i<count($address_data); $i++ )
        {
          ($address_data[$i]['dept'])? $dept = $address_data[$i]['dept'] : $dept = '';
          ($address_data[$i]['orgn'])? $orgn = $address_data[$i]['orgn'] : $orgn = '';
          ($address_data[$i]['pobx'])? $pobx = $address_data[$i]['pobx'] : $pobx = '';
          ($address_data[$i]['dept'])? $dept = $address_data[$i]['dept'] : $dept = '';
          ($address_data[$i]['subb'])? $subb = $address_data[$i]['subb'] : $subb = '';
          ($address_data[$i]['bnam'])? $bnam = $address_data[$i]['bnam'] : $bnam = '';
          ($address_data[$i]['dpth'])? $dpth = $address_data[$i]['dpth'] : $dpth = '';
          ($address_data[$i]['thor'])? $thor = $address_data[$i]['thor'] : $thor = '';
          ($address_data[$i]['ddlo'])? $ddlo = $address_data[$i]['ddlo'] : $ddlo = '';
          ($address_data[$i]['dplo'])? $dplo = $address_data[$i]['dplo'] : $dplo = '';
          ($address_data[$i]['town'])? $town = $address_data[$i]['town'] : $town = '';
          ($address_data[$i]['cnty'])? $cnty = $address_data[$i]['cnty'] : $cnty = '';
          ($address_data[$i]['pcod'])? $pcod = $address_data[$i]['pcod'] : $pcod = '';
  
          $address_data[$i]['address'] = $address_data[$i]['bnum']."".$dept." ".$orgn." ".$pobx." ".$subb." ".$bnam." ".$dpth." ".$thor." ".$ddlo." ".$dplo." ".$town." ".$cnty." ".$pcod;
          $address_data[$i]['pcod'] = $address_data[$i]['pcod'];
  
          //electricity
          if( !empty($address_data[$i]['metersElec']) )
          {
            for( $m=0; $m<count($address_data[$i]['metersElec']); $m++ )
            {
              if( count($address_data[$i]['metersElec']) > 1 )
              {
                $address_data[$i]['mpan'][] = $address_data[$i]['metersElec'][$m]['mpan'];
                $address_data[$i]['mpanLower'][] = $address_data[$i]['metersElec'][$m]['mpanLower'];
                $address_data[$i]['meterType'] = $address_data[$i]['metersElec'][$m]['pricePlanCode'];
                $address_data[$i]['meterSerialElec'][] = $address_data[$i]['metersElec'][$m]['meterSerialElec'];
                $db_mpan_check = $this->user_modal->db_mpan_check($address_data[$i]['metersElec'][$m]['mpanLower']);
                if($db_mpan_check == '1')
                {
                  $address_data[$i]['elec_used_in_db2'] = '1';
                }
                else
                {
                  $address_data[$i]['elec_used_in_db2'] = '0';
                }
              }
              else 
              {
                $address_data[$i]['metersElec'][$m]['mpanLower'];
                $address_data[$i]['mpan'][] = $address_data[$i]['metersElec'][$m]['mpan'];
                $address_data[$i]['mpanLower'][] = $address_data[$i]['metersElec'][$m]['mpanLower'];
                $address_data[$i]['meterType'] = $address_data[$i]['metersElec'][$m]['pricePlanCode'];
                $address_data[$i]['meterSerialElec'][] = $address_data[$i]['metersElec'][$m]['meterSerialElec'];
                $db_mpan_check = $this->user_modal->db_mpan_check($address_data[$i]['metersElec'][$m]['mpanLower']);
                if($db_mpan_check == 1)
                {
                  $address_data[$i]['elec_used_in_db1'] = '1';
                }
                else
                {
                  $address_data[$i]['elec_used_in_db1'] = '0';
                }
              }
            }
          }
          else
          {
            $address_data[$i]['mpan'] = array();
            $address_data[$i]['meterType'] = array();
            $address_data[$i]['meterSerialElec'] = array();
            $address_data[$i]['elec_used_in_db3'] = '0';
          }
  
          //gas
          if( !empty($address_data[$i]['metersGas']) )
          {
            for( $m=0; $m<count($address_data[$i]['metersGas']); $m++ )
            {
              if( count($address_data[$i]['metersGas']) > 1 )
              {
                $address_data[$i]['mprn'][] = $address_data[$i]['metersGas'][$m]['mprn'];
                $address_data[$i]['meterSerialGas'][] = $address_data[$i]['metersGas'][$m]['meterSerialGas'];
              }
              else 
              {
                $address_data[$i]['mprn'][] = $address_data[$i]['metersGas'][$m]['mprn'];
                $address_data[$i]['meterSerialGas'][] = $address_data[$i]['metersGas'][$m]['meterSerialGas'];
              }
            }
          }
          else 
          {
            $address_data[$i]['mprn'] = array();
            $address_data[$i]['meterSerialGas'] = array();
          }
        }

          $data['address_list'] = $address_data;
      }

      $address_data_gas = $this->session->userdata('address_data_gas');
  
      if( !empty($address_data_gas) )
      {
        for( $i=0; $i<count($address_data_gas); $i++ )
        {
          ($address_data_gas[$i]['dept'])? $dept_gas = $address_data_gas[$i]['dept'] : $dept_gas = '';
          ($address_data_gas[$i]['orgn'])? $orgn_gas = $address_data_gas[$i]['orgn'] : $orgn_gas = '';
          ($address_data_gas[$i]['pobx'])? $pobx_gas = $address_data_gas[$i]['pobx'] : $pobx_gas = '';
          ($address_data_gas[$i]['dept'])? $dept_gas = $address_data_gas[$i]['dept'] : $dept_gas = '';
          ($address_data_gas[$i]['subb'])? $subb_gas = $address_data_gas[$i]['subb'] : $subb_gas = '';
          ($address_data_gas[$i]['bnam'])? $bnam_gas = $address_data_gas[$i]['bnam'] : $bnam_gas = '';
          ($address_data_gas[$i]['dpth'])? $dpth_gas = $address_data_gas[$i]['dpth'] : $dpth_gas = '';
          ($address_data_gas[$i]['thor'])? $thor_gas = $address_data_gas[$i]['thor'] : $thor_gas = '';
          ($address_data_gas[$i]['ddlo'])? $ddlo_gas = $address_data_gas[$i]['ddlo'] : $ddlo_gas = '';
          ($address_data_gas[$i]['dplo'])? $dplo_gas = $address_data_gas[$i]['dplo'] : $dplo_gas = '';
          ($address_data_gas[$i]['town'])? $town_gas = $address_data_gas[$i]['town'] : $town_gas = '';
          ($address_data_gas[$i]['cnty'])? $cnty_gas = $address_data_gas[$i]['cnty'] : $cnty_gas = '';
          ($address_data_gas[$i]['pcod'])? $pcod_gas = $address_data_gas[$i]['pcod'] : $pcod_gas = '';
  
          $address_data_gas[$i]['address'] = $dept_gas." ".$orgn_gas." ".$pobx_gas." ".$subb_gas." ".$bnam_gas." ".$address_data_gas[$i]['bnum']." ".$dpth_gas." ".$thor_gas." ".$ddlo_gas." ".$dplo_gas." ".$town_gas." ".$cnty_gas." ".$pcod_gas;
          $address_data_gas[$i]['pcod'] = $address_data_gas[$i]['pcod'];
  
          //gas
          if( !empty($address_data_gas[$i]['metersGas']) )
          {
            for( $m=0; $m<count($address_data_gas[$i]['metersGas']); $m++ )
            {
              if( count($address_data_gas[$i]['metersGas']) > 1 )
              {
                $address_data_gas[$i]['mprn'][] = $address_data_gas[$i]['metersGas'][$m]['mprn'];
                $address_data_gas[$i]['meterSerialGas'][] = $address_data_gas[$i]['metersGas'][$m]['meterSerialGas'];
              }
              else 
              {
                $address_data_gas[$i]['mprn'][] = $address_data_gas[$i]['metersGas'][$m]['mprn'];
                $address_data_gas[$i]['meterSerialGas'][] = $address_data_gas[$i]['metersGas'][$m]['meterSerialGas'];
              }
            }
          }
          else 
          {
            $address_data_gas[$i]['mprn'] = array();
            $address_data_gas[$i]['meterSerialGas'] = array();
          }
  
        }

        $data['address_list_gas'] = $address_data_gas;
      }
  
      $this->load->view('admin/addresslist',$data);
    }

    function supply_address_lookup()
    {
        $response = $this->curl->curl_request('/v3.1/partner-resources/'.$this->affiliate_id.'/mpas/addresses-by-pcod/', $this->input->post(), 'post' );
        $address_list = json_decode($response,true);

        if($address_list['statusCode'] == '1046')
        {
            $address_data = array();
            $address_data1 = $address_list['data']['addresses'];

            for( $mm=0; $mm<count($address_data1); $mm++ )
            {

                for( $j=0; $j<count( $address_data1[$mm]['metersElec'] ); $j++ )
                {
                    if( $address_data1[$mm]['metersElec'][$j]['mpanProfileClass'] != '03' )
                    {
                        $address_data[] = $address_data1[$mm];
                    }
                }
            }
            $this->session->set_userdata('address_data',$address_data);
        }
        else 
        {
          echo  $address_list['statusCode'];
        }
        $this->supply_address_list();
    }
    
    function supply_address_list()
    {
      $data = array();
      $address_data = $this->session->userdata('address_data');
      
      if( !empty($address_data) )
      {
        for( $i=0; $i<count($address_data); $i++ )
        {
          ($address_data[$i]['dept'])? $dept = $address_data[$i]['dept'] : $dept = '';
          ($address_data[$i]['orgn'])? $orgn = $address_data[$i]['orgn'] : $orgn = '';
          ($address_data[$i]['pobx'])? $pobx = $address_data[$i]['pobx'] : $pobx = '';
          ($address_data[$i]['dept'])? $dept = $address_data[$i]['dept'] : $dept = '';
          ($address_data[$i]['subb'])? $subb = $address_data[$i]['subb'] : $subb = '';
          ($address_data[$i]['bnam'])? $bnam = $address_data[$i]['bnam'] : $bnam = '';
          ($address_data[$i]['dpth'])? $dpth = $address_data[$i]['dpth'] : $dpth = '';
          ($address_data[$i]['thor'])? $thor = $address_data[$i]['thor'] : $thor = '';
          ($address_data[$i]['ddlo'])? $ddlo = $address_data[$i]['ddlo'] : $ddlo = '';
          ($address_data[$i]['dplo'])? $dplo = $address_data[$i]['dplo'] : $dplo = '';
          ($address_data[$i]['town'])? $town = $address_data[$i]['town'] : $town = '';
          ($address_data[$i]['cnty'])? $cnty = $address_data[$i]['cnty'] : $cnty = '';
          ($address_data[$i]['pcod'])? $pcod = $address_data[$i]['pcod'] : $pcod = '';
  
          $address_data[$i]['address'] = $address_data[$i]['bnum']."".$dept." ".$orgn." ".$pobx." ".$subb." ".$bnam." ".$dpth." ".$thor." ".$ddlo." ".$dplo." ".$town." ".$cnty." ".$pcod;
          $address_data[$i]['pcod'] = $address_data[$i]['pcod'];
  
          //electricity
          if( !empty($address_data[$i]['metersElec']) )
          {
            for( $m=0; $m<count($address_data[$i]['metersElec']); $m++ )
            {
              if( count($address_data[$i]['metersElec']) > 1 )
              {
                $address_data[$i]['mpan'][] = $address_data[$i]['metersElec'][$m]['mpan'];
                $address_data[$i]['mpanLower'][] = $address_data[$i]['metersElec'][$m]['mpanLower'];
                $address_data[$i]['meterType'] = $address_data[$i]['metersElec'][$m]['pricePlanCode'];
                $address_data[$i]['meterSerialElec'][] = $address_data[$i]['metersElec'][$m]['meterSerialElec'];
                $db_mpan_check = $this->user_modal->db_mpan_check($address_data[$i]['metersElec'][$m]['mpanLower']);
                if($db_mpan_check == '1')
                {
                  $address_data[$i]['elec_used_in_db2'] = '1';
                }
                else
                {
                  $address_data[$i]['elec_used_in_db2'] = '0';
                }
              }
              else 
              {
                $address_data[$i]['metersElec'][$m]['mpanLower'];
                $address_data[$i]['mpan'][] = $address_data[$i]['metersElec'][$m]['mpan'];
                $address_data[$i]['mpanLower'][] = $address_data[$i]['metersElec'][$m]['mpanLower'];
                $address_data[$i]['meterType'] = $address_data[$i]['metersElec'][$m]['pricePlanCode'];
                $address_data[$i]['meterSerialElec'][] = $address_data[$i]['metersElec'][$m]['meterSerialElec'];
                $db_mpan_check = $this->user_modal->db_mpan_check($address_data[$i]['metersElec'][$m]['mpanLower']);
                if($db_mpan_check == 1)
                {
                  $address_data[$i]['elec_used_in_db1'] = '1';
                }
                else
                {
                  $address_data[$i]['elec_used_in_db1'] = '0';
                }
              }
            }
          }
          else
          {
            $address_data[$i]['mpan'] = array();
            $address_data[$i]['meterType'] = array();
            $address_data[$i]['meterSerialElec'] = array();
            $address_data[$i]['elec_used_in_db3'] = '0';
          }
  
          //gas
          if( !empty($address_data[$i]['metersGas']) )
          {
            for( $m=0; $m<count($address_data[$i]['metersGas']); $m++ )
            {
              if( count($address_data[$i]['metersGas']) > 1 )
              {
                $address_data[$i]['mprn'][] = $address_data[$i]['metersGas'][$m]['mprn'];
                $address_data[$i]['meterSerialGas'][] = $address_data[$i]['metersGas'][$m]['meterSerialGas'];
              }
              else 
              {
                $address_data[$i]['mprn'][] = $address_data[$i]['metersGas'][$m]['mprn'];
                $address_data[$i]['meterSerialGas'][] = $address_data[$i]['metersGas'][$m]['meterSerialGas'];
              }
            }
          }
          else 
          {
            $address_data[$i]['mprn'] = array();
            $address_data[$i]['meterSerialGas'] = array();
          }
        }

          $data['address_list'] = $address_data;
      }

      $address_data_gas = $this->session->userdata('address_data_gas');
  
      if( !empty($address_data_gas) )
      {
        for( $i=0; $i<count($address_data_gas); $i++ )
        {
          ($address_data_gas[$i]['dept'])? $dept_gas = $address_data_gas[$i]['dept'] : $dept_gas = '';
          ($address_data_gas[$i]['orgn'])? $orgn_gas = $address_data_gas[$i]['orgn'] : $orgn_gas = '';
          ($address_data_gas[$i]['pobx'])? $pobx_gas = $address_data_gas[$i]['pobx'] : $pobx_gas = '';
          ($address_data_gas[$i]['dept'])? $dept_gas = $address_data_gas[$i]['dept'] : $dept_gas = '';
          ($address_data_gas[$i]['subb'])? $subb_gas = $address_data_gas[$i]['subb'] : $subb_gas = '';
          ($address_data_gas[$i]['bnam'])? $bnam_gas = $address_data_gas[$i]['bnam'] : $bnam_gas = '';
          ($address_data_gas[$i]['dpth'])? $dpth_gas = $address_data_gas[$i]['dpth'] : $dpth_gas = '';
          ($address_data_gas[$i]['thor'])? $thor_gas = $address_data_gas[$i]['thor'] : $thor_gas = '';
          ($address_data_gas[$i]['ddlo'])? $ddlo_gas = $address_data_gas[$i]['ddlo'] : $ddlo_gas = '';
          ($address_data_gas[$i]['dplo'])? $dplo_gas = $address_data_gas[$i]['dplo'] : $dplo_gas = '';
          ($address_data_gas[$i]['town'])? $town_gas = $address_data_gas[$i]['town'] : $town_gas = '';
          ($address_data_gas[$i]['cnty'])? $cnty_gas = $address_data_gas[$i]['cnty'] : $cnty_gas = '';
          ($address_data_gas[$i]['pcod'])? $pcod_gas = $address_data_gas[$i]['pcod'] : $pcod_gas = '';
  
          $address_data_gas[$i]['address'] = $dept_gas." ".$orgn_gas." ".$pobx_gas." ".$subb_gas." ".$bnam_gas." ".$address_data_gas[$i]['bnum']." ".$dpth_gas." ".$thor_gas." ".$ddlo_gas." ".$dplo_gas." ".$town_gas." ".$cnty_gas." ".$pcod_gas;
          $address_data_gas[$i]['pcod'] = $address_data_gas[$i]['pcod'];
  
          //gas
          if( !empty($address_data_gas[$i]['metersGas']) )
          {
            for( $m=0; $m<count($address_data_gas[$i]['metersGas']); $m++ )
            {
              if( count($address_data_gas[$i]['metersGas']) > 1 )
              {
                $address_data_gas[$i]['mprn'][] = $address_data_gas[$i]['metersGas'][$m]['mprn'];
                $address_data_gas[$i]['meterSerialGas'][] = $address_data_gas[$i]['metersGas'][$m]['meterSerialGas'];
              }
              else 
              {
                $address_data_gas[$i]['mprn'][] = $address_data_gas[$i]['metersGas'][$m]['mprn'];
                $address_data_gas[$i]['meterSerialGas'][] = $address_data_gas[$i]['metersGas'][$m]['meterSerialGas'];
              }
            }
          }
          else 
          {
            $address_data_gas[$i]['mprn'] = array();
            $address_data_gas[$i]['meterSerialGas'] = array();
          }
  
        }

        $data['address_list_gas'] = $address_data_gas;
      }
  
      $this->load->view('admin/supply_addresslist',$data);
    }

    function our_tariffs()
    {

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://apis2.awsprod.energylinx.com/v2/partner-resources/EVERSMARTENERGYSUPP/tariffs-onsale-by-supplier-name/",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_SSL_VERIFYPEER => false,
          CURLOPT_SSL_VERIFYHOST => false,
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => "{\n    \"supplierName\": \"Eversmart Energy\"\n}",
          CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json",
            "cache-control: no-cache"
          ),
        ));
    
        $response = curl_exec($curl);
        $err = curl_error($curl);
    
        curl_close($curl);
    
        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
         $response;
        }

        $data['get_tariffs'] = $response;
    
        $this->load->view('admin/tariffs',$data);
      
    }

    function prev_supplier_lookup()
    {
      //get supplier list
      $response = $this->curl->curl_request('/v3.1/partner-resources/'.$this->affiliate_id.'/suppliers/', [], 'post' );
      $supplier_list = json_decode($response,true);
      
      if( !empty($supplier_list) )
      {
        if( $supplier_list['statusCode'] == '1013' )
        {
          $data['supplier_data'] = $supplier_list['data']['suppliers'];
        }
      }
      else 
      {
        $data['supplier_data'] = array();
      }
      
      $this->load->view('admin/prev_supplier',$data);
    }

    function prev_tariff_lookup()
    {
      $parameter = ['supplierName' => $this->input->post('elec_supplier') ];
      
      $data = array();
      $response = $this->curl->curl_request('/v3.1/partner-resources/'.$this->affiliate_id.'/tariffs/', $parameter, 'post' );
      $tariff_list = json_decode($response,true);

      if( $tariff_list['statusCode'] == '1040' )
      {
        $data['tariff_list'] = $tariff_list['data']['tariffs'];       
      }
      else {
        $data['tariff_list'] = array();
      }

      $this->load->view('admin/prev_tariff',$data);
    }
}
