package com.orbis.net;

import android.content.Context;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.EscalationDetail;
import com.orbis.Model.EsclationBeans;
import com.orbis.Model.KillSignalBeans;
import com.orbis.Model.LocationUpdateBeans;
import com.orbis.Model.LoginASMBeans;
import com.orbis.Model.LoginBeans;
import com.orbis.Model.LogoutBeans;
import com.orbis.Model.SettingBeans;
import com.orbis.Model.SignalBeans;
import com.orbis.Model.TriggerSignalBeans;
import com.orbis.Model.VerifyBeans;
import com.orbis.Model.Verify_otp_beans;
import com.orbis.Model.escalation.EscalationMain;

import java.util.List;
import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Query;

public class WebRequest {
    private static Context mContext;
    private static WebRequest mWebrequest;
    public static APIInterface apiInterface;

    public static WebRequest getSingleton(Context context) {
        if (mWebrequest == null) {
            synchronized ((WebRequest.class)) {
                if (mWebrequest == null) {
                    mWebrequest = new WebRequest(context);
                }
            }
        }
        return mWebrequest;
    }

    public WebRequest(Context context) {
        apiInterface = RestClient.getClient();
        mContext = context;
    }

    private static class RestClient {
        private static APIInterface apiInterface;

        public static APIInterface getClient() {
            if (apiInterface == null) {
                Gson gson = new GsonBuilder()
                        .setLenient()
                        .create();
                HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
                interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);

                OkHttpClient client = new OkHttpClient.Builder().
                        connectTimeout(30, TimeUnit.SECONDS).
                        readTimeout(30, TimeUnit.SECONDS).
                        writeTimeout(30, TimeUnit.SECONDS).
                        addInterceptor(interceptor).build();

                Retrofit retrofit = new Retrofit.Builder()
                        .baseUrl(GlobalConstants.SERVER_URL)
                        .addConverterFactory(ScalarsConverterFactory.create())
                        .client(client)
                        .addConverterFactory(GsonConverterFactory.create(gson))
                        .build();

                apiInterface = retrofit.create(APIInterface.class);
            }
            return apiInterface;
        }
    }

    public interface APIInterface {

        @POST("user/login_asm/?")
        Call<List<LoginASMBeans>>userLoginASM(@Query("number") String number);

        @POST("user/")
        Call<LoginBeans> userLogin(@Query("number") String number);

        @POST("user/logout?")
        Call<LogoutBeans> userLogout(@Query("ref") String ref);

        @FormUrlEncoded
        @POST("user/verify_otp_asm/?")
        Call<Verify_otp_beans>verifyOTPASM(@Field("number") String number, @Field("app_type") String app_type, @Field("device_type") String device_type, @Field("device_id") String device_id, @Field("device_token") String device_token, @Field("otp") String otp);
        // number, device_type, device_token, device_id, app_type, otp


        @FormUrlEncoded
        @POST("user/verify_otp_operators/?")
        Call<VerifyBeans> verifyOTP(@Field("number") String number, @Field("app_type") String app_type, @Field("device_type") String device_type, @Field("device_id") String device_id, @Field("device_token") String device_token, @Field("otp") String otp);

        /*Get Format*/
        @POST("signals/?")
        Call<SignalBeans> signal(@Query("datetime") String datetime, @Query("imei") String imei, @Query("number") String number, @Query("messageType") String messageType, @Query("lat") String lat, @Query("long") String lng, @Query("posdatatime") String posdatatime, @Query("postype") String postype, @Query("status") String status, @Query("interval") String interval, @Query("speed") String speed);

        /*@POST("user/location_update/?")
        Call<LocationUpdateBeans>userLocationUpdate(@Query("ref_id") String ref_id,@Query("lat") String lat,@Query("long") String lng,@Query("datetime") String datetime,@Query("imei") String imei,@Query("number") String number,@Query("messageType") String messageType,@Query("posdatatime") String posdatatime,@Query("postype") String postype,@Query("status") String status,@Query("interval") String interval,@Query("speed") String speed);*/

        /*Location Update after 5 min*/
        /*Post Format */
        @FormUrlEncoded
        @POST("user/location_update/?")
        Call<LocationUpdateBeans> userLocationUpdate(@Field("ref_id") String ref_id, @Field("lat") String lat, @Field("long") String lng, @Field("datetime") String datetime, @Field("imei") String imei, @Field("number") String number, @Field("messageType") String messageType, @Field("posdatatime") String posdatatime, @Field("postype") String postype, @Field("status") String status, @Field("interval") String interval, @Field("speed") String speed);

        /*Setting*/
        @POST("user/get_setting_lwd/?")
        Call<SettingBeans> setting(@Query("ref") String ref);

        /*Kill Signal*/
        @POST("user/check_signal/?")
        Call<KillSignalBeans> killSignal(@Query("ref") String ref);

        /*Esclation APi Get*/
        @POST("user/profile_download/?")
        Call<EsclationBeans> EsclationDetail(@Query("ref") String ref);

        /*GEt Escalation Detail======*/
       /* @FormUrlEncoded
        @POST("user/get_escalation/?")
        Call<EscalationDetail> esclationGetData(@Field("lindex") String lindex);
*/

        @FormUrlEncoded
        @POST("user/get_escalation/?")
        Call<EscalationDetail> escalationDetailData(@Field("lindex") String lindex);

        @Multipart
        @POST("user/escalation_mail")
        Call<EscalationMain> escalationMail(@Part("parameter") String lindex,@Part("subject") String subject);

        @FormUrlEncoded
        @POST("signals/check_trigger/?")
        Call<TriggerSignalBeans> getSignal(@Field("ref_id") String ref_id, @Field("lat") String lat, @Field("long") String lng, @Field("datetime") String datetime, @Field("imei") String imei, @Field("number") String number, @Field("messageType") String messageType, @Field("posdatatime") String posdatatime, @Field("postype") String postype, @Field("status") String status, @Field("interval") String interval, @Field("speed") String speed, @Field("trigger_from") String trigger_from);

    }
}