package com.orbis.Util;

import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.app.AlertDialog;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.orbis.Activity.GlobalConstants;
import com.orbis.Model.SignalBeans;
import com.orbis.net.GPSTracker;
import com.orbis.net.TriggerSignal;
import com.orbis.net.WebRequest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class ServiceCall {
    static String date, time;
    static WebRequest mWebrequest;
    static Call<SignalBeans> signal_ResponseCall;
    static SignalBeans signal_otpresponse;
    static String checksum = "";
    static String messagechck = "";
    static TelephonyManager tManager;
    static String datetime, imei, number, messageType, lat, lng, posdatatime, postype, status = "", interval, speed;
    static String messagesend = "";
    static String phoneNumber = "";
    static String fcmstatus = "", fcmmessage = "";
    static GPSTracker gps;


    public static void sendSignal(Context context) {
        mWebrequest = WebRequest.getSingleton(context);
        SharedPreferences preferences = context.getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        try {
            date = get_current_date();
            time = get_current_time();

            tManager = (TelephonyManager) context
                    .getSystemService(Context.TELEPHONY_SERVICE);
            datetime = date + time;
            imei = tManager.getDeviceId();
            number = preferences.getString("number", "");
            messageType = "FDA";
           /* lat = preferences.getString("currentLATTITUDE", "");
            lng = preferences.getString("currentLONGITUDE", "");*/
            posdatatime = preferences.getString("posdatatime", "");
            fcmstatus = preferences.getString("FCMSignalStatus", "");
            fcmmessage = preferences.getString("FCMSignalmessage", "");
            phoneNumber = preferences.getString("redalertsmsnumber", "");

            try {
                gps = new GPSTracker(context);
                lat = String.valueOf(gps.getLatitude());
                lng = String.valueOf(gps.getLongitude());
                Log.e("SetAMber", lat);
                Log.e("Setamberlong", lng);
                if (lat.equalsIgnoreCase("0.0")) {
                    lat = preferences.getString("currentLATTITUDE", "");

                } else {
                    Log.e("*****", "lat");
                }
                if (lng.equalsIgnoreCase("0.0")) {
                    lng = preferences.getString("currentLONGITUDE", "");
                } else {
                    Log.e("*****", "long");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            if (phoneNumber.equalsIgnoreCase("")) {
                phoneNumber = "07786200129";
            }

            SharedPreferences.Editor editor = preferences.edit();
            editor.putString("Triggerfrom", "FallDetect");
            editor.commit();

            TriggerSignal.sendTriggerSignal(context, "", "","");
            if (isNetworkAvailable(context)) {
                datetime = date + time;
                date = get_current_date();
                time = get_current_time();
               /* if (posdatatime==""){
                    posdatatime=date+time;
                }*/


                postype = "GPS";
                // interval = "";
                speed =GlobalConstants.SPEED;
/*
                if (status.equalsIgnoreCase("")) {
                    status = "Emergency";
                } else {
                    status = preferences.getString("messageStatus", "");
                }
                Log.e("SERVICECALL STATUS", status);*/
                if (fcmstatus.equalsIgnoreCase("0")) {

                } else {

                    if (status.equalsIgnoreCase("")) {

                    } else {
                        signal_Send(date + time, imei, number, "FDA", lat, lng, date + time, postype, status, interval, speed);

                    }

                }
            } else {

                date = get_current_date();
                time = get_current_time();

                postype = "GPS";
                // interval = "";
                speed =GlobalConstants.SPEED;

                if (status.equalsIgnoreCase("")) {
                    status = "Emergency";
                } else {
                    //status = preferences.getString("messageStatus", "");
                }
                messagechck = "PRT" + "," + datetime + "," + imei + "," + number + "," + messageType + "," + lat + "," + lng + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed;
                checksum = md5(messagechck);
                messagesend = "PRT" + "," + date + time + "," + imei + "," + number + "," + "FDA" + "," + lat + "," + lng + "," + date + time + "," + postype + "," + status + "," + interval + "," + speed + "," + checksum;
                Log.e("FDAmessage", messagesend);
                if (fcmstatus.equalsIgnoreCase("0")) {
                    showBuilder(context, "Request Failed", "Your data requests are restricted. Please contact HS2");


                } else {

                    if (status.equalsIgnoreCase("")) {

                    } else {

                        SmsManager.getDefault().sendTextMessage(phoneNumber, null, messagesend, null, null);
                    }
                }


            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //==============get curent time =========================//
    public static String get_current_time() {
        //2017-06-02 11:30:40
        Calendar c = Calendar.getInstance();
        System.out.println("Current time => " + c.getTime());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }

    //==============get curent date =========================//
    public static String get_current_date() {
        //2017-06-02 11:30:40
        Calendar c = Calendar.getInstance();
        System.out.println("Current time => " + c.getTime());

        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        String formattedDate = df.format(c.getTime());

        return formattedDate;
    }

    static void signal_Send(String datetime, String imei, String number, String messageType, String lat, String lng, String posdatatime, String postype, String status, String interval, String speed) {
        signal_ResponseCall = mWebrequest.apiInterface.signal(datetime, imei, number, messageType, lat, lng, posdatatime, postype, status, interval, speed);
        getSignalResponse(signal_ResponseCall);
    }

    //Signal API Response
    private static void getSignalResponse(final Call<SignalBeans> signalResp) {
        //  showProgressDialog(SetAmberScreen.this, "Signal Sending...");
        signalResp.enqueue(new Callback<SignalBeans>() {
            @Override
            public void onResponse(Call<SignalBeans> call, Response<SignalBeans> response) {
                // dismissProgressDialog();
                if (response.isSuccessful()) {
                    signal_otpresponse = response.body();

                    String status = response.body().getStatus().toString();
                    Log.e("ll", status);

                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In condition", "Success");
                        String message = response.body().getMessage().toString();
                        Log.e("Fall detected Messagecall", message);
                    } else {
                        Log.e("In condition", "Failed");
                    }
                }
            }

            @Override
            public void onFailure(Call<SignalBeans> call, Throwable t) {
                //  dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }


    public static boolean isNetworkAvailable(Context context) {

        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();

    }


    //checksum of value ......
    public static final String md5(final String s) {
        final String MD5 = "MD5";
        try {
            // Create MD5 Hash
            MessageDigest digest = MessageDigest
                    .getInstance(MD5);
            digest.update(s.getBytes());
            byte messageDigest[] = digest.digest();

            // Create Hex String
            StringBuilder hexString = new StringBuilder();
            for (byte aMessageDigest : messageDigest) {
                String h = Integer.toHexString(0xFF & aMessageDigest);
                while (h.length() < 2)
                    h = "0" + h;
                hexString.append(h);

            }
            Log.e("CheckSum", hexString.toString());
            return hexString.toString();

        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void showBuilder(Context context, String title, String message) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {

                dialog.dismiss();
            }
        });

        builder.show();
    }


}
