package com.orbis.Activity;

import android.Manifest;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.places.Places;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.orbis.Model.SignalBeans;
import com.orbis.R;
import com.orbis.Util.Utility;
import com.orbis.net.WebRequest;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MapViewFragment extends OrbisActivity implements View.OnClickListener, OnMapReadyCallback, LocationListener, GoogleApiClient.ConnectionCallbacks, GoogleApiClient.OnConnectionFailedListener {

    private GoogleMap mMap;
    MapView mMapView;
    View view;
    private static final String TAG = "LocationActivity";
    private static final long INTERVAL = 1000;
    private static final long FASTEST_INTERVAL = 1000;
    LocationRequest mLocationRequest;
    Location mCurrentLocation, PrevLoc;
    String mLastUpdateTime;
    Location location;
    //Google ApiClient
    private GoogleApiClient googleApiClient;
    ImageView iv_update_location;
    String strAdd = "";
    String cityName = "";
    TextView tv_bottom_last_location_time, tv_map_location, tv_location_get, tv_Title;
    public static String currentLat = "", currentLong = "";
    Address returnedAddress;
    private final Map<String, MarkerOptions> mMarkers = new ConcurrentHashMap<String, MarkerOptions>();
    private float zoomLevel = 13.2f;
    WebRequest mWebrequest;
    Call<SignalBeans> signal_ResponseCall;
    SignalBeans signal_otpresponse;
    String datetime1, imei1, number1, messageType1, posdatatime, postype, status1, interval, speed;
    TelephonyManager tManager;
    String formattime = "", refid1 = "";
    SimpleDateFormat simpleDateFormat;
    Calendar c;
    String date, time;
    LocationManager locationManager;
    String fcmstatus = "";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_location_screen);

        mWebrequest = WebRequest.getSingleton(MapViewFragment.this);
        locationManager = (LocationManager) this.getSystemService(LOCATION_SERVICE);
        c = Calendar.getInstance();
        simpleDateFormat = new SimpleDateFormat("HH:mm");
        date = get_current_date();
        time = get_current_time();
        tManager = (TelephonyManager) getBaseContext()
                .getSystemService(Context.TELEPHONY_SERVICE);
        fcmstatus = preferences.getString("FCMSignalStatus", "");

        postype = "GPS";
        interval = "";
        speed = "";
        imei1 = tManager.getDeviceId();
        refid1 = preferences.getString("REF_ID", "");
        status1 = preferences.getString("messageStatus", "");
        number1 = preferences.getString("number", "");
        messageType1 = "PUD";
        datetime1 = date + time;
        tv_Title = (TextView) findViewById(R.id.tv_Title);
        Utility.text_font_helvetica(this, tv_Title);
        tv_location_get = (TextView) findViewById(R.id.tv_location_get);
        Utility.text_font_helvetica(this, tv_location_get);
        tv_map_location = (TextView) findViewById(R.id.tv_map_location);
        Utility.text_font_helvetica(this, tv_map_location);
        if (cityName == null) {
            tv_map_location.setText("");
            tv_location_get.setText("");
        }
        tv_bottom_last_location_time = (TextView) findViewById(R.id.tv_bottom_last_location_time);
        Utility.text_font_helvetica(this, tv_bottom_last_location_time);
        if (formattime == null) {
            tv_bottom_last_location_time.setText("");
        }
        iv_update_location = (ImageView) findViewById(R.id.iv_update_location);
        iv_update_location.setOnClickListener(this);

        mMapView = (MapView) findViewById(R.id.map);
        mMapView.onCreate(savedInstanceState);
        mMapView.onResume(); // needed to get the map to display immediately
        try {
            MapsInitializer.initialize(MapViewFragment.this.getApplicationContext());
        } catch (Exception e) {
            e.printStackTrace();
        }
        mMapView.getMapAsync(this);
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            // TODO: Consider calling
            //    ActivityCompat#requestPermissions
            // here to request the missing permissions, and then overriding
            //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
            //                                          int[] grantResults)
            // to handle the case where the user grants the permission. See the documentation
            // for ActivityCompat#requestPermissions for more details.
            return;
        }
        createLocationRequest();

        //Set On Click Listener
//=============== Initialize Google Api Client ===============//
        googleApiClient = new GoogleApiClient.Builder(getApplicationContext())
                .addApi(LocationServices.API)
                .addApi(Places.GEO_DATA_API)
                .addConnectionCallbacks(this)//connection listeners  (connected, suspended)
                .addOnConnectionFailedListener(this) // connection failed listener
                .build();

        googleApiClient.connect();
        if (isNetworkAvailable()) {
        } else {
            date = get_current_date();
            time = get_current_time();
            String phoneNumber = "07786200129";
            String update_message = "PRT" + "," + date + time + "," + imei1 + "," + number1 + "," + "PUD" + "," + currentLat + "," + currentLong + "," + posdatatime + "," + postype + "," + status1 + "," + interval + "," + speed;
            SmsManager.getDefault().sendTextMessage(phoneNumber, null, update_message, null, null);
        }

    }

    @Override
    public void onMapReady(GoogleMap googleMap) {
        mMap = googleMap;
        MapStyleOptions style = MapStyleOptions.loadRawResourceStyle(MapViewFragment.this, R.raw.mapstyle_retro);
        googleMap.setMapStyle(style);

        if (ActivityCompat.checkSelfPermission(MapViewFragment.this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(MapViewFragment.this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            // TODO: Consider calling
            //    ActivityCompat#requestPermissions
            // here to request the missing permissions, and then overriding
            //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
            //                                          int[] grantResults)
            // to handle the case where the user grants the permission. See the documentation
            // for ActivityCompat#requestPermissions for more details.
            return;
        }
        mMap.getUiSettings().setCompassEnabled(false);
        mMap.getUiSettings().setRotateGesturesEnabled(false);
        mMap.getUiSettings().setTiltGesturesEnabled(false);
        mMap.setMyLocationEnabled(true); // false to disable
    }

    protected void createLocationRequest() {
        mLocationRequest = new LocationRequest();
        mLocationRequest.setInterval(INTERVAL);
        mLocationRequest.setFastestInterval(FASTEST_INTERVAL);
        mLocationRequest.setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (googleApiClient.isConnected()) {
            startLocationUpdates();
            Log.d(TAG, "Location update resumed .....................");
        }
        //locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 1000, 10, this);
    }

    @Override
    public void onPause() {
        super.onPause();
        //locationManager.removeUpdates(this);
//        stopLocationUpdates();
    }

    @Override
    public void onStart() {
        googleApiClient.connect();
        super.onStart();
    }

    @Override
    public void onStop() {
        googleApiClient.disconnect();
        super.onStop();
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {
        getCurrentLocation();
        startLocationUpdates();
    }

    @Override
    public void onConnectionSuspended(int i) {
    }

    @Override
    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
    }

    private String getCompleteAddressString(double LATITUDE, double LONGITUDE) {
        // String cityName="";
        Geocoder geocoder = new Geocoder(this, Locale.getDefault());
        try {

            List<Address> addresses = geocoder.getFromLocation(LATITUDE, LONGITUDE, 1);
            if (addresses != null) {
                returnedAddress = addresses.get(0);
                StringBuilder strReturnedAddress = new StringBuilder("");

                for (int i = 0; i < returnedAddress.getMaxAddressLineIndex(); i++) {
                    strReturnedAddress.append(returnedAddress.getAddressLine(i)).append("\n");
                    cityName = returnedAddress.getAddressLine(2);
                }
                strAdd = strReturnedAddress.toString();
                tv_map_location.setText(cityName);
                tv_location_get.setText(returnedAddress.getLocality() + " , " + returnedAddress.getCountryName());

                //Toast.makeText(getApplicationContext(),"Current Address is:"+"- "+strAdd,Toast.LENGTH_LONG).show();
                Log.e("Current loction address", "" + strReturnedAddress.toString());
            } else {
                Log.e("Current loction address", "No Address returned!");
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.e("Current loction address", "Canont get Address!");
        }
        return strAdd;
    }

    // check google play services are available or not
    private boolean isGooglePlayServicesAvailable() {
        int status = GooglePlayServicesUtil.isGooglePlayServicesAvailable(MapViewFragment.this);
        if (ConnectionResult.SUCCESS == status) {
            return true;
        } else {
            GooglePlayServicesUtil.getErrorDialog(status, MapViewFragment.this, 0).show();
            return false;
        }
    }

    @Override
    public void onLocationChanged(Location location) {
        Log.e("Location", "" + location.getLatitude() + " " + location.getLongitude());
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("currentLATTITUDE", String.valueOf(location.getLatitude()));
        editor.putString("currentLONGITUDE", String.valueOf(location.getLongitude()));
        editor.commit();
        mCurrentLocation = location;
        updateUI();

    }

    private void updateUI() {
        Log.d(TAG, "UI update initiated .............");
        if (null != mCurrentLocation) {
            String lat = String.valueOf(mCurrentLocation.getLatitude());
            String lng = String.valueOf(mCurrentLocation.getLongitude());
            String status = ("At Time: " + mLastUpdateTime + "\n" +
                    "Latitude: " + lat + "\n" +
                    "Longitude: " + lng + "\n" +
                    "Accuracy: " + mCurrentLocation.getAccuracy() + "\n" +
                    "Provider: " + mCurrentLocation.getProvider());
            Log.d(TAG, "location update :- " + status);
            LatLng latLng = new LatLng(mCurrentLocation.getLatitude(), mCurrentLocation.getLongitude());
            if (PrevLoc == null) {
                PrevLoc = mCurrentLocation;
            }
            add("currentLoc", new LatLng(latLng.latitude, latLng.longitude));
            currentLat = String.valueOf(latLng.latitude);
            currentLong = String.valueOf(latLng.longitude);


            getCompleteAddressString(latLng.latitude, latLng.longitude);
            posdatatime = date + time;
            SharedPreferences.Editor editor1 = preferences.edit();
            editor1.putString("posdatatime", posdatatime);
            editor1.commit();


            //update location api
            //startRepeatingTask();
            //addmarker(latLng, mCurrentLocation);
        } else {
            Log.d(TAG, "location is null ...............");
        }
    }

    //Getting current location
    public void getCurrentLocation() {
        //mMap.clear();
        //Creating a location object
        if (ActivityCompat.checkSelfPermission(MapViewFragment.this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(MapViewFragment.this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            // TODO: Consider calling
            //    ActivityCompat#requestPermissions
            // here to request the missing permissions, and then overriding
            //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
            //                                          int[] grantResults)
            // to handle the case where the user grants the permission. See the documentation
            // for ActivityCompat#requestPermissions for more details.
            return;
        }
        location = LocationServices.FusedLocationApi.getLastLocation(googleApiClient);
        // LatLng latLng=new LatLng(location.getLatitude(), location.getLongitude());
        if (location != null) {
            //Move Camera to Current Location
            //mMap.moveCamera(CameraUpdateFactory.newLatLngZoom(new LatLng(location.getLatitude(), location.getLongitude()), 14));
            mMap.animateCamera(CameraUpdateFactory.newLatLngZoom(new LatLng(location.getLatitude(), location.getLongitude()), 15));


        }
    }

    protected void startLocationUpdates() {
        if (ActivityCompat.checkSelfPermission(MapViewFragment.this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(MapViewFragment.this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            // TODO: Consider calling
            //    ActivityCompat#requestPermissions
            // here to request the missing permissions, and then overriding
            //   public void onRequestPermissionsResult(int requestCode, String[] permissions,
            //                                          int[] grantResults)
            // to handle the case where the user grants the permission. See the documentation
            // for ActivityCompat#requestPermissions for more details.
            return;
        }
        PendingResult<Status> pendingResult = LocationServices.FusedLocationApi.requestLocationUpdates(googleApiClient, mLocationRequest, this);
        Log.d(TAG, "Location update started ..............: ");
    }

    protected void stopLocationUpdates() {
        LocationServices.FusedLocationApi.removeLocationUpdates(googleApiClient, this);
        Log.d(TAG, "Location update stopped .......................");
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_update_location:
                //  SharedPreferences.Editor editor = getredPreferences(MY_PREFS_NAME, MODE_PRIVATE).edit();
                formattime = simpleDateFormat.format(c.getTime());
                tv_bottom_last_location_time.setText(formattime);

                SharedPreferences.Editor editor = preferences.edit();
                editor.putString("City", cityName);
                editor.putString("UpdateLocationTime", formattime);
                editor.commit();

                date = get_current_date();
                time = get_current_time();
                String messagesend = date + time + "," + imei1 + "," + number1 + "," + messageType1 + "," + currentLat + "," + currentLong + "," + posdatatime + "," + postype + "," + status1 + "," + interval + "," + speed;

                if (isNetworkAvailable()) {
                    if (fcmstatus.equalsIgnoreCase("0")) {
                        Log.e("ENTER SIGNAL NOT ALLOWED", "====");
                        showBuilder(MapViewFragment.this, "Request Failed", "Your data requests are restricted. Please contact HS2");
                    } else {
                        signal_Send(date + time, imei1, number1, messageType1, currentLat, currentLong, posdatatime, postype, status1, interval, speed);
                        // showToast("Location Updateded and Sent to ARC");
                    }
                } else {
                    date = get_current_date();
                    time = get_current_time();
                    datetime1 = date + time;
                    String phoneNumber = "07786200129";
                    String update_message = "PRT" + "," + datetime1 + "," + imei1 + "," + number1 + "," + "PUD" + "," + currentLat + "," + currentLong + "," + posdatatime + "," + postype + "," + status1 + "," + interval + "," + speed;
                    if (fcmstatus.equalsIgnoreCase("0")) {
                        Log.e("ENTER SIGNAL NOT ALLOWED", "====");
                        showBuilder(MapViewFragment.this, "Request Failed", "Your data requests are restricted. Please contact HS2");
                    } else {
                        SmsManager.getDefault().sendTextMessage(phoneNumber, null, update_message, null, null);
                    }
                }
        }
    }

    private void signal_Send(String datetime, String imei, String number, String messageType, String lat, String lng, String posdatatime, String postype, String status, String interval, String speed) {
        signal_ResponseCall = mWebrequest.apiInterface.signal(datetime, imei, number, messageType, lat, lng, posdatatime, postype, status, interval, speed);
        getSignalResponse(signal_ResponseCall);
    }

    //Signal API Response
    private void getSignalResponse(final Call<SignalBeans> signalResp) {
        showProgressDialog(MapViewFragment.this, "Signal Sending...");
        signalResp.enqueue(new Callback<SignalBeans>() {
            @Override
            public void onResponse(Call<SignalBeans> call, Response<SignalBeans> response) {
                dismissProgressDialog();
                if (response.isSuccessful()) {
                    signal_otpresponse = response.body();

                    String status = response.body().getStatus().toString();
                    Log.e("ll", status);

                    if (status.equalsIgnoreCase("1")) {
                        Log.e("In condition", "Success");
                        String message = response.body().getMessage().toString();
                        showToast("Location updated and sent to HS2");
                    } else {
                        Log.e("In condition", "Failed");
                    }
                }
            }

            @Override
            public void onFailure(Call<SignalBeans> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }

    private void add(String name, LatLng ll) {
        final MarkerOptions marker;
        mMap.clear();
        if (name.toString().trim().equals("source")) {
            marker = new MarkerOptions().position(ll).title(name).icon(BitmapDescriptorFactory.defaultMarker(BitmapDescriptorFactory.HUE_ORANGE));
        } else if (name.toString().trim().equals("currentLoc")) {
            marker = new MarkerOptions().position(ll).title(name);
        } else {
            marker = new MarkerOptions().position(ll).title(name).icon(BitmapDescriptorFactory.defaultMarker(BitmapDescriptorFactory.HUE_GREEN));
        }

        mMarkers.put(name, marker);

        for (MarkerOptions item : mMarkers.values()) {
            if (item.getTitle().toString().equals("currentLoc")) {
                Bitmap bitmap;
                int px = getResources().getDimensionPixelSize(R.dimen.margin_top_10);
                bitmap = Bitmap.createBitmap(px, px, Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);

                Drawable shape = getResources().getDrawable(R.drawable.ic_brightness_1_black_24dp);
                shape.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
                shape.draw(canvas);

//                Bitmap bitmap = BitmapFactory.decodeResource(getResources(), R.drawable.current_location_icon);
                Marker mmarker = mMap.addMarker(new MarkerOptions()
                        .position(item.getPosition())
                        .icon(BitmapDescriptorFactory.fromBitmap(bitmap)));

                CircleOptions circleOptions = new CircleOptions()
                        .center(item.getPosition())
                        .strokeWidth(1.0f)
                        .strokeColor(getResources().getColor(R.color.circleBoundry))
                        .fillColor(getResources().getColor(R.color.circleColor))
                        .radius(200); // In meters
                // Get back the mutable Circle
                Circle circle = mMap.addCircle(circleOptions);


            } else {
                mMap.addMarker(item);
            }
        }
    }
}