package com.orbisalert.notifications;

import android.os.CountDownTimer;
import android.util.Log;

import java.util.concurrent.TimeUnit;



public class FallDetectCounter  extends CountDownTimer {

    private static String fhms;
    private static FallDetectCounter fallinstance;
    private static long fallremaining;

    private FallDetectCounter(long millisInFuture, long countDownInterval){
        super(millisInFuture,countDownInterval);
    }



    public static FallDetectCounter  initInstance(long millisInFuture, long countDownInterval){
        fallinstance=null;
        if(fallinstance==null){
            fallinstance =  new FallDetectCounter(millisInFuture,countDownInterval);
        }
        return fallinstance;
    }

    public static FallDetectCounter  extendinitInstance(long millisInFuture, long countDownInterval){
        fallinstance=null;
        if(fallinstance==null){
            fallinstance =  new FallDetectCounter(millisInFuture,countDownInterval);
        }
        return fallinstance;
    }




    public static FallDetectCounter  getInstance() throws Exception{
        if(fallinstance==null){

            throw new Exception("Parameters not initialized. Initiate with initInstance");
        }else{
            return fallinstance;
        }
    }

    public void clear()
    {
        fallinstance=null;
        if (fallinstance!=null) {
            fallinstance = null;
        }
    }


    public static String getFallFormatedTime(){
        return fhms;
    }


    public static void setFallFormatedTime(){

        fhms=null;
        fallremaining=0;

    }
    @Override
    public void onTick(long fl) {
        fallremaining= fl;
       /* fhms= String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(fallremaining),
                TimeUnit.MILLISECONDS.toMinutes(fallremaining) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(fallremaining)),
                TimeUnit.MILLISECONDS.toSeconds(fallremaining) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(fallremaining))
        );*/
         fhms = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(fallremaining), TimeUnit.MILLISECONDS.toMinutes(fallremaining) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(fallremaining)), TimeUnit.MILLISECONDS.toSeconds(fallremaining) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(fallremaining)));
      //  Log.e("FAAAAA",fhms);
    }
    @Override

    public void onFinish() {
        fallremaining=0;
        fhms=null;


    }

}