package com.orbisalert.notifications;

import android.content.Context;
import android.os.PowerManager;

/**
 * Created by nancy on 15/9/17.
 */

public class AmberWakeLock {

    private static PowerManager.WakeLock amberwakeLock;

    public static void acquire(Context context) {
        if (amberwakeLock != null) amberwakeLock.release();

        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        amberwakeLock = pm.newWakeLock(PowerManager.SCREEN_DIM_WAKE_LOCK |
                PowerManager.ACQUIRE_CAUSES_WAKEUP |
                PowerManager.ON_AFTER_RELEASE, "WakeLock");
        amberwakeLock.acquire();

    }

    public static void release() {
        if (amberwakeLock != null) amberwakeLock.release(); amberwakeLock = null;
    }
}
