package com.orbisalert.Activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Address;
import android.location.Geocoder;
import android.location.LocationManager;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.orbisalert.Model.SignalBeans;
import com.orbisalert.R;
import com.orbisalert.Util.Utility;
import com.orbisalert.net.GPSTracker;
import com.orbisalert.net.TriggerSignal;
import com.orbisalert.net.WebRequest;


import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class MapboxActivity extends OrbisActivity implements View.OnClickListener {
    GPSTracker gps;
    private MapView mapView;
    private MapboxMap map=null;
    double latitude,longitude;

    //Google ApiClient
    ImageView iv_update_location;
    String strAdd = "";
    String cityName = "";
    TextView tv_bottom_last_location_time, tv_map_location, tv_location_get, tv_Title;
    public static String currentLat = "", currentLong = "";
    Address returnedAddress;
    WebRequest mWebrequest;
    Call<SignalBeans> signal_ResponseCall;
    SignalBeans signal_otpresponse;
    String datetime1, imei1, number1, messageType1, posdatatime, postype, status1="", interval, speed;
    TelephonyManager tManager;
    String formattime = "", refid1 = "";
    SimpleDateFormat simpleDateFormat1;
    Calendar c1;
    String date, time;
    LocationManager locationManager;
    String fcmstatus="",fcmmessage="";
    String redalertsmsnumber="";

    @SuppressLint("MissingPermission")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        mapView = (MapView) findViewById(R.id.mapView);
        mapView.onCreate(savedInstanceState);

        gps = new GPSTracker(MapboxActivity.this);

        try {
            latitude = gps.getLatitude();
            longitude = gps.getLongitude();
            if (latitude==0.0){
                latitude = Double.parseDouble(preferences.getString("currentLATTITUDE", ""));
            }else{
                latitude = gps.getLatitude();

            }

            if (longitude==0.0){
                longitude = Double.parseDouble(preferences.getString("currentLONGITUDE",""));
            }else{
                latitude = gps.getLatitude();

            }




        }catch (Exception e){
            e.printStackTrace();
        }

        fcmstatus = preferences.getString("FCMSignalStatus", "");
        fcmmessage = preferences.getString("FCMSignalmessage", "");

        /*Setting data*/
        redalertsmsnumber=preferences.getString("redalertsmsnumber", "");
        if (redalertsmsnumber.equalsIgnoreCase("")){
            redalertsmsnumber = "07786200129";
        }

        /*Signal data*/
        mWebrequest = WebRequest.getSingleton(MapboxActivity.this);
        locationManager = (LocationManager) this.getSystemService(LOCATION_SERVICE);
        c1 = Calendar.getInstance();
       simpleDateFormat1 = new SimpleDateFormat("HH:mm");
        date = get_current_date();
        time = get_current_time();
        tManager = (TelephonyManager) getBaseContext()
                .getSystemService(Context.TELEPHONY_SERVICE);
        postype = "GPS";
        interval = "";

        speed = GlobalConstants.SPEED;
        imei1 = tManager.getDeviceId();
        refid1 = preferences.getString("REF_ID", "");
      //  status1 = preferences.getString("messageStatus", "");
        number1 = preferences.getString("number", "");
        messageType1 = "PUDM";
        datetime1 = date + time;
        tv_Title = (TextView) findViewById(R.id.tv_Title);
        Utility.text_font_helvetica(this, tv_Title);
        tv_location_get = (TextView) findViewById(R.id.tv_location_get);
        Utility.text_font_helvetica(this, tv_location_get);
        /*tv_map_location = (TextView) findViewById(R.id.tv_map_location);
        Utility.text_font_helvetica(this, tv_map_location);
        if (cityName == null) {
            tv_map_location.setText("");
            tv_location_get.setText("");
        }*/
        tv_bottom_last_location_time = (TextView) findViewById(R.id.tv_bottom_last_location_time);
        Utility.text_font_helvetica(this, tv_bottom_last_location_time);
        if (formattime == null) {
            tv_bottom_last_location_time.setText("");
        }
        iv_update_location = (ImageView) findViewById(R.id.iv_update_location);
        iv_update_location.setOnClickListener(this);

        try{

            currentLat =String.valueOf(gps.getLatitude());
            currentLong=String.valueOf(gps.getLongitude());
            Log.e("TRIGGER========",currentLat);
            Log.e("TRIGGEER========",currentLong);

            if (currentLat.equalsIgnoreCase("0.0")){

                currentLat = preferences.getString("currentLATTITUDE", "");
                Log.e("+++++++",currentLat);

            }
            else{

            }

            if (currentLong.equalsIgnoreCase("0.0")){


                currentLong = preferences.getString("currentLONGITUDE","");

                Log.e("+++++++",currentLong);
                ;

            }
            else{

                Log.e("+++++++",currentLong);
            }





        }catch (Exception e){
            e.printStackTrace();

        }

//        if(status1.equalsIgnoreCase("")){
//            status1 = "Emergency";
//        }
//        else{
//            status1 = preferences.getString("messageStatus", "");
//        }


        mapView.getMapAsync(new OnMapReadyCallback() {
            @Override
            public void onMapReady(MapboxMap mapboxMap) {

                map = mapboxMap;

                mapboxMap.moveCamera(CameraUpdateFactory.newLatLngZoom(new LatLng(gps.getLatitude(), gps.getLongitude()), 9));

                try {
                        mapboxMap.addMarker(new MarkerOptions()
                                .position(new LatLng(latitude, longitude))
                                .title("Marker!")
                                .snippet("Current position"));

                    }catch(Exception e){
                        e.printStackTrace();
                    }


                 // mapboxMap.setMyLocationEnabled(true);
                 if (isNetworkAvailable()) {

                     getCompleteAddressString(gps.getLatitude(), gps.getLongitude());
                 }else{
                     //tv_map_location.setText("Unable to get location");
                     tv_location_get.setText("Unable to get location");
                 }



                if (longitude==0.0){

                    //currentLong = preferences.getString("currentLONGITUDE","");
                    Log.e("+++++long", String.valueOf(currentLong));
                }
                else{

                   // currentLong = String.valueOf(longitude);
                }

                if (latitude==0.0){

                  //  currentLat = preferences.getString("currentLATTITUDE", "");
                    Log.e("+++++lat1", String.valueOf(currentLat));

                }
                else{
                   // currentLat = String.valueOf(latitude);
                    Log.e("++call+++lat", String.valueOf(currentLat));

                }

                posdatatime = date + time;
                SharedPreferences.Editor editor1 = preferences.edit();
                editor1.putString("posdatatime", posdatatime);
                editor1.commit();

            }
        });

    }


    @Override
    public void onStart() {
        super.onStart();
        if (mapView!=null) {
            mapView.onStart();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (mapView!=null) {
            mapView.onResume();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (mapView!=null) {
            mapView.onPause();
            mapView = null;
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        if (mapView!=null) {
            mapView.onStop();

        }
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        mapView.onLowMemory();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mapView!=null) {
            mapView.onDestroy();
            mapView = null;
        }
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (mapView!=null) {
            mapView.onSaveInstanceState(outState);
        }
    }


    private String getCompleteAddressString(double LATITUDE, double LONGITUDE) {

        Geocoder geocoder = new Geocoder(this, Locale.ENGLISH);
        try {

            List<Address> addresses = geocoder.getFromLocation(LATITUDE, LONGITUDE, 1);
            if (addresses != null) {
                returnedAddress = addresses.get(0);
                StringBuilder strReturnedAddress = new StringBuilder("");

                for (int i = 0; i < returnedAddress.getMaxAddressLineIndex(); i++) {
                    strReturnedAddress.append(returnedAddress.getAddressLine(i)).append("\n");
                    cityName = returnedAddress.getAddressLine(2);
                }
                strAdd = strReturnedAddress.toString();
               // tv_map_location.setText(cityName);

                if(returnedAddress.getLocality().equalsIgnoreCase("") && returnedAddress.getCountryName().equalsIgnoreCase("")){
                    //tv_map_location.setText("Unable to get location");
                    tv_location_get.setText("Unable to get location");
                }
                else{
                   // tv_map_location.setText(cityName);
                    tv_location_get.setText(cityName + " , " + returnedAddress.getCountryName());

                    SharedPreferences.Editor editor = preferences.edit();
                    editor.putString("City", cityName);
                    editor.putString("UpdateLocationTime", formattime);
                    editor.commit();
                }


            } else {
              //  tv_map_location.setText("Unable to get location");
                tv_location_get.setText("Unable to get location");
            }
        } catch (Exception e) {
            e.printStackTrace();
            //tv_map_location.setText("Unable to get location");
            tv_location_get.setText("Unable to get location");
        }
        return strAdd;
    }


    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.iv_update_location:
                //  SharedPreferences.Editor editor = getredPreferences(MY_PREFS_NAME, MODE_PRIVATE).edit();
                formattime = simpleDateFormat1.format(c1.getTime());
                tv_bottom_last_location_time.setText(formattime);
                date = get_current_date();
                time = get_current_time();
                SharedPreferences.Editor editor3 = preferences.edit();
                editor3.putString("Triggerfrom","PUDM");
                editor3.commit();

                TriggerSignal.sendTriggerSignal(MapboxActivity.this,"","");

                if (isNetworkAvailable()) {
                    if (fcmstatus.equalsIgnoreCase("0")) {

                        showBuilder(MapboxActivity.this,"Request Failed","Your data requests are restricted. Please contact Orbis");


                    } else {
                        String updatedtime = get_locationcurrent_time();

                        if (updatedtime!=null) {
                            SharedPreferences.Editor editor2 = preferences.edit();
                            editor2.remove("locationupdate");
                            editor2.apply();
                        }
                        SharedPreferences.Editor editor = preferences.edit();
                        editor.putString("locationupdate", updatedtime);
                        editor.putString("posdatatime", posdatatime);
                        editor.commit();
                        posdatatime =date+time;
                        signal_Send(date + time, imei1, number1, "PUDM", currentLat, currentLong, date + time, postype, status1, interval, "v1.7");

                } }else {
                    if (fcmstatus.equalsIgnoreCase("0")) {

                        showBuilder(MapboxActivity.this,"Request Failed","Your data requests are restricted. Please contact Orbis");


                    } else {
                    date = get_current_date();
                    time = get_current_time();
                    datetime1 = date + time;
                    posdatatime=date+time;
                    String update_message = "PRT" + "," + datetime1 + "," + imei1 + "," + number1 + "," + "PUDM" + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status1 + "," + interval + "," + speed;
                       String checksum = md5(update_message);

                       String message_send= "PRT" + "," + datetime1 + "," + imei1 + "," + number1 + "," + "PUDM" + "," + currentLat + "," + currentLong + "," + date + time + "," + postype + "," + status1 + "," + interval + "," + "v1.7"+","+checksum;
                        String msgupdatedtime = get_locationcurrent_time();

                        if (msgupdatedtime!=null) {
                            SharedPreferences.Editor editor2 = preferences.edit();
                            editor2.remove("locationupdate");
                            editor2.apply();
                        }
                        SharedPreferences.Editor editor22 = preferences.edit();
                        editor22.putString("locationupdate", msgupdatedtime);
                        editor22.putString("posdatatime", posdatatime);
                        editor22.commit();
                        Log.e("Manual Update Message ",message_send.toString());

                       // redalertsmsnumber="07860047514";
                        SmsManager.getDefault().sendTextMessage(redalertsmsnumber, null, message_send, null, null);
                }}
        }
    }
    public static String get_locationcurrent_time() {

        Calendar c = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa");
        String formattime = simpleDateFormat.format(c.getTime());
        return formattime;
    }

    private void signal_Send(String datetime, String imei, String number, String messageType, String lat, String lng, String posdatatime, String postype, String status, String interval, String speed) {
        signal_ResponseCall = mWebrequest.apiInterface.signal(datetime, imei, number, messageType, lat, lng, posdatatime, postype, status, interval, speed);
        getSignalResponse(signal_ResponseCall);
    }

    //Signal API Response
    private void getSignalResponse(final Call<SignalBeans> signalResp) {
        showProgressDialog(MapboxActivity.this, "Signal Sending...");
        signalResp.enqueue(new Callback<SignalBeans>() {
            @Override
            public void onResponse(Call<SignalBeans> call, Response<SignalBeans> response) {
                dismissProgressDialog();
                if (response.isSuccessful()) {
                    signal_otpresponse = response.body();

                    String status = response.body().getStatus().toString();

                    if (status.equalsIgnoreCase("1")) {

                        String message = response.body().getMessage().toString();
                        showToast("Location updated and sent to Orbis");


                    } else {

                    }
                }
            }

            @Override
            public void onFailure(Call<SignalBeans> call, Throwable t) {
                dismissProgressDialog();
                t.printStackTrace();
            }
        });
    }



}