package com.orbisalert.Activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.orbisalert.BluetoothDevices.BluetoothLeService;
import com.orbisalert.BluetoothDevices.ProcessQueueExecutor;
import com.orbisalert.BluetoothDevices.ScannedDevice;
import com.orbisalert.BluetoothDevices.ScannedDeviceAdapter;
import com.orbisalert.R;

import java.util.ArrayList;
import java.util.Set;

/**
 * Created by admin on 21/9/17.
 */

public class DeviceListActivity extends OrbisActivity implements View.OnClickListener {

    private ScannedDeviceAdapter scannedDeviceAdapter;
    private BluetoothAdapter mBluetoothAdapter;
    private boolean mScanning;
    private Handler mHandler;
    RelativeLayout listitem;
    TextView tv_title;
    private static final int REQUEST_ENABLE_BT = 1;
    // Stops scanning after 10 seconds.
    private static final long SCAN_PERIOD = 10000;
    private ListView scanningDeviceListView;
    boolean clicked_value = false;
    //Device control

    public static final String EXTRAS_DEVICE_NAME = "DEVICE_NAME";
    public static final String EXTRAS_DEVICE_ADDRESS = "DEVICE_ADDRESS";

    private TextView mConnectionState;
    private TextView mDataField;
    private String mDeviceName;
    private String mDeviceAddress;
    private BluetoothLeService mBluetoothLeService;

    private boolean mConnected = false;
    ImageView iv_back;
    String devicename, devicemacaddress;
    int count = 0;
    private BluetoothAdapter mBTAdapter;
    TextView device_status, device_address, device_name;
    //
    Boolean Cliked;
    private Set<BluetoothDevice> mPairedDevices;
    public ProcessQueueExecutor processQueueExecutor = new ProcessQueueExecutor();


    /// // Code to manage Service lifecycle.
    private final ServiceConnection mServiceConnection = new ServiceConnection() {

        @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            mBluetoothLeService = ((BluetoothLeService.LocalBinder) service).getService();
            if (!mBluetoothLeService.initialize()) {
                Log.e("8888888888888", "Unable to initialize Bluetooth");
                finish();
            }
            // Automatically connects to the device upon successful start-up initialization.
            mBluetoothLeService.connect(mDeviceAddress);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            mBluetoothLeService = null;
        }
    };

    private final BroadcastReceiver mGattUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            final String action = intent.getAction();
            if (BluetoothLeService.ACTION_GATT_CONNECTED.equals(action)) {
                //Log.e("ACTION_GATT_CONNECTED *********", "Device Control");
                mConnected = true;
                updateConnectionState(R.string.connected);
                scannedDeviceAdapter.updateStatus("Connected", devicename, devicemacaddress);
                scannedDeviceAdapter.notifyDataSetChanged();
                invalidateOptionsMenu();
            } else if (BluetoothLeService.ACTION_GATT_DISCONNECTED.equals(action)) {
                // Log.e("ACTION_GATT_DISCONNECTED *********", " Disconnect Control");
                mConnected = false;
                updateConnectionState(R.string.disconnected);
                invalidateOptionsMenu();
                processQueueExecutor.interrupt();
                //clearUI();
            } else if (BluetoothLeService.ACTION_DATA_RESPONSE.equals(action)) {
                //Log.e(" ACTION_DATA_RESPONSE*********", "Device Control");
                displayData(intent.getStringExtra(BluetoothLeService.EXTRA_DATA));
            } else if (BluetoothDevice.ACTION_ACL_CONNECTED.equals(action)) {

                // Log.e("Already====ACTION_ACL_CONNECTED===========", "");
                BluetoothDevice device11 = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);

                try {
                    String devicename = device11.getName().toString();
                    String macaddress = device11.getAddress().toString();

                    scannedDeviceAdapter.updateStatus("Connected", devicename, macaddress);
                    scannedDeviceAdapter.notifyDataSetChanged();
                    scannedDeviceAdapter.updateStatus("Connected", devicename, macaddress);
                    scannedDeviceAdapter.notifyDataSetChanged();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (BluetoothDevice.ACTION_ACL_DISCONNECTED.equals(action)) {

                Log.e("===============", "Device Disconnect");

                try {
                    processQueueExecutor.interrupt();
                    // mBluetoothLeService.disconnect(mBluetoothLeService.bluetoothGattMap.get(mDeviceAddress));
                    unbindService(mServiceConnection);
                    mBluetoothLeService = null;
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("Connected_Item");
                    editor.remove("Connected_Item_DisplayName");
                    editor.remove("Connected_Item_Device");
                    editor.remove("Connectivity_Status");
                    editor.apply();

                } catch (Exception e) {
                    e.printStackTrace();
                }

                //... //Device has disconnected
            } else if (BluetoothDevice.ACTION_ACL_DISCONNECT_REQUESTED.equals(action)) {
                //Log.e("===============", "Device Disconnect");
                try {
                    processQueueExecutor.interrupt();
                    // mBluetoothLeService.disconnect(mBluetoothLeService.bluetoothGattMap.get(mDeviceAddress));
                    unbindService(mServiceConnection);
                    mBluetoothLeService = null;
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("Connected_Item");
                    editor.remove("Connected_Item_DisplayName");
                    editor.remove("Connected_Item_Device");
                    editor.remove("Connectivity_Status");
                    editor.apply();

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }
    };


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_devicescan);
        // getActionBar().setTitle(R.string.app_name);
        mHandler = new Handler();
        scanningDeviceListView = (ListView) findViewById(R.id.managedevices_scanning_device_listview);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayShowTitleEnabled(false);
        tv_title = (TextView) findViewById(R.id.tv_title);
        listitem = (RelativeLayout) findViewById(R.id.listitem);
        listitem.setOnClickListener(this);
        device_name = (TextView) findViewById(R.id.device_name);
        device_address = (TextView) findViewById(R.id.device_address);
        device_status = (TextView) findViewById(R.id.device_status);

        iv_back = (ImageView) findViewById(R.id.iv_back_devicelist);
        // Use this check to determine whether BLE is supported on the device.
        // Then you can
        // selectively disable BLE-related features.
        if (!getPackageManager().hasSystemFeature(
                PackageManager.FEATURE_BLUETOOTH_LE)) {
            Toast.makeText(this, R.string.ble_not_supported, Toast.LENGTH_SHORT)
                    .show();
            finish();
        }

        // Initializes a Bluetooth adapter. For API level 18 and above, get a
        // reference to
        // BluetoothAdapter through BluetoothManager.
        final BluetoothManager bluetoothManager = (BluetoothManager) getSystemService(Context.BLUETOOTH_SERVICE);
        mBluetoothAdapter = bluetoothManager.getAdapter();
        mBTAdapter = BluetoothAdapter.getDefaultAdapter(); // get a handle on the bluetooth radio
        // Checks if Bluetooth is supported on the device.
        if (mBluetoothAdapter == null) {
            Toast.makeText(this, R.string.error_bluetooth_not_supported,
                    Toast.LENGTH_SHORT).show();
            finish();
            return;
        }

        // Initializes list view adapter.L
        scannedDeviceAdapter = new ScannedDeviceAdapter(this, R.layout.listitem_device, new ArrayList<ScannedDevice>());
        scanningDeviceListView.setAdapter(scannedDeviceAdapter);

        // Scanned Device item click listener
        scanningDeviceListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterview, View view, int position, long id) {
                ScannedDevice item = scannedDeviceAdapter.getItem(position);
                if (item != null) {
                    clicked_value = false;
                    devicename = item.getDisplayName().toString();
                    devicemacaddress = item.getDeviceMac().toString();

                    SharedPreferences preferences = getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
                    SharedPreferences.Editor editorr = preferences.edit();
                    editorr.putString("Connected_Item", String.valueOf(item));
                    editorr.commit();
                    Log.e("clicked_value", String.valueOf(clicked_value));
                    showBuilder1(DeviceListActivity.this, "Pair BT Device", "Do yo want to connect?", devicename, devicemacaddress,item);
                    try {
                        // ((ScannedDeviceAdapter)scanningDeviceListView.getAdapter()).remove(item);
                        if (clicked_value = true) {
                            Log.e("clicked_value", String.valueOf(clicked_value));
                            scannedDeviceAdapter.remove(item);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });

        Intent gattServiceIntent = new Intent(this, BluetoothLeService.class);
        bindService(gattServiceIntent, mServiceConnection, BIND_AUTO_CREATE);

        listPairedDevices();

        iv_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(DeviceListActivity.this, SettingScreen.class);
                startActivity(intent);
                finish();
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.main, menu);
        if (!mScanning) {
            menu.findItem(R.id.menu_stop).setVisible(false);
            menu.findItem(R.id.menu_scan).setVisible(true);
            menu.findItem(R.id.menu_refresh).setActionView(null);
        } else {
            menu.findItem(R.id.menu_stop).setVisible(true);
            menu.findItem(R.id.menu_scan).setVisible(false);
            menu.findItem(R.id.menu_refresh).setActionView(
                    R.layout.actionbar_indeterminate_progress);
        }
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.menu_scan:
                scannedDeviceAdapter.clear();
                scanLeDevice(true);
                break;
            case R.id.menu_stop:
                scanLeDevice(false);
                break;
        }
        return true;
    }

    @Override
    protected void onResume() {
        super.onResume();

        Log.e("Connected ", "*********");
        if (!mBluetoothAdapter.isEnabled()) {
            if (!mBluetoothAdapter.isEnabled()) {
                Intent enableBtIntent = new Intent(
                        BluetoothAdapter.ACTION_REQUEST_ENABLE);
                startActivityForResult(enableBtIntent, REQUEST_ENABLE_BT);
            }
        }
        String Connected_Item_DisplayName = preferences.getString("Connected_Item_DisplayName", "");
        if (Connected_Item_DisplayName.equalsIgnoreCase("")) {
            listitem.setVisibility(View.GONE);
//            unbindService(mServiceConnection);
        } else {

        }
        scanLeDevice(true);
        //new
        registerReceiver(mGattUpdateReceiver, makeGattUpdateIntentFilter());

        get_bluetoth_Data();
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        // User chose not to enable Bluetooth.
        if (requestCode == REQUEST_ENABLE_BT
                && resultCode == Activity.RESULT_CANCELED) {
            finish();
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    protected void onPause() {
        super.onPause();
        try {
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scanLeDevice(final boolean enable) {
        if (enable) {
            // Stops scanning after a pre-defined scan period.
            mHandler.postDelayed(new Runnable() {
                @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
                @Override
                public void run() {
                    mScanning = false;
                    mBluetoothAdapter.stopLeScan(mLeScanCallback);
                    invalidateOptionsMenu();
                }
            }, SCAN_PERIOD);

            mScanning = true;
            mBluetoothAdapter.startLeScan(mLeScanCallback);
        } else {
            mScanning = false;
            mBluetoothAdapter.stopLeScan(mLeScanCallback);
        }
        invalidateOptionsMenu();
    }

    // Device scan callback.
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback() {

        @Override
        public void onLeScan(final BluetoothDevice device, final int rssi,
                             final byte[] scanRecord) {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    scannedDeviceAdapter.update(device, rssi, scanRecord);
                    scannedDeviceAdapter.notifyDataSetChanged();
                }
            });
        }
    };

    private void updateConnectionState(final int resourceId) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {

                scannedDeviceAdapter.updateStatus("Connected", devicename, devicemacaddress);
                scannedDeviceAdapter.notifyDataSetChanged();


                // mConnectionState.setText(resourceId);
            }
        });
    }

    private void displayData(String data) {
        if (data != null) {

            // mDataField.append(data +"\n");
            Log.e("data>>>>>>>>", data);

        }
    }

    private static IntentFilter makeGattUpdateIntentFilter() {
        final IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(BluetoothLeService.ACTION_GATT_CONNECTED);
        intentFilter.addAction(BluetoothLeService.ACTION_GATT_DISCONNECTED);
        intentFilter.addAction(BluetoothLeService.ACTION_DATA_RESPONSE);
        intentFilter.addAction(BluetoothDevice.ACTION_ACL_CONNECTED);
        intentFilter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECT_REQUESTED);
        intentFilter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECTED);
        return intentFilter;
    }

    public void showBuilder1(@NonNull Context context, @NonNull String title, @NonNull String message, final String devicename, final String devicemacaddress, ScannedDevice item) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
            @Override
            public void onClick(DialogInterface dialog, int which) {
                Log.e("ENter in this alert", "********");
                mBluetoothLeService.connect(devicemacaddress);
                scannedDeviceAdapter.updateStatus("Connected", devicename, devicemacaddress);
                scannedDeviceAdapter.notifyDataSetChanged();
                scannedDeviceAdapter.remove(item);
                clicked_value = true;
                try {
                    String clicked_item = preferences.getString("Connected_Item", "");
                    scanningDeviceListView.removeViewAt(Integer.parseInt(clicked_item));
                    scannedDeviceAdapter.notifyDataSetChanged();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                if (mScanning) {
                    mBluetoothAdapter.stopLeScan(mLeScanCallback);
                    mScanning = false;
                }
                if (mBluetoothLeService != null) {
                    final boolean result = mBluetoothLeService.connect(mDeviceAddress);
                    Log.d("oooo", "Connect request result=" + result);

                    Intent newIntent = new Intent();
                    newIntent.setAction(BluetoothLeService.ACTION_GATT_CONNECTED);
                    sendBroadcast(newIntent);
                    if (devicename.toLowerCase().contains("v.alrt")) {
                        scheduleNotification(getNotification(DeviceListActivity.this, "Bluetooth Connected"), 2000);
                    }
                    shared_Data();
                    get_bluetoth_Data();
                }
                dialog.dismiss();

            }
        });
        builder.setNegativeButton("No", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                try {
                    clicked_value = false;
                    Log.e("clicked_value", String.valueOf(clicked_value));
                    // unbindService(mServiceConnection);
                    scannedDeviceAdapter.clear();
                    scanLeDevice(true);
                    //new
                    //registerReceiver(mGattUpdateReceiver, makeGattUpdateIntentFilter());

                } catch (Exception e) {
                    e.printStackTrace();

                }
                dialog.dismiss();

            }
        });
        builder.show();
    }

    private void shared_Data() {
        SharedPreferences preferences = getSharedPreferences(GlobalConstants.PREF_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor editorr = preferences.edit();
        editorr.putString("Connected_Item_DisplayName", devicename);
        editorr.putString("Connected_Item_Device", devicemacaddress);
        editorr.putString("Connectivity_Status", "Connected");
        editorr.commit();
    }

    private void get_bluetoth_Data() {
        //////*********************
        String clicked_item = preferences.getString("Connected_Item", "");
        String Connected_Item_DisplayName = preferences.getString("Connected_Item_DisplayName", "");
        String Connected_Item_Device = preferences.getString("Connected_Item_Device", "");
        String Connectivity_Status = preferences.getString("Connectivity_Status", "");


        if (Connected_Item_DisplayName.equalsIgnoreCase("")) {
            listitem.setVisibility(View.GONE);
            Log.e("*******INVISIBLE", clicked_item);
        } else {
            // registerReceiver(mGattUpdateReceiver, makeGattUpdateIntentFilter());
            if (mBluetoothLeService != null) {
                final boolean result = mBluetoothLeService.connect(mDeviceAddress);
            }
            Log.e("*******VISIBLE", clicked_item);
            listitem.setVisibility(View.VISIBLE);

            device_name.setText(Connected_Item_DisplayName);
            device_address.setText(Connected_Item_Device);
            device_status.setText(Connectivity_Status);
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            Log.e("HELLOOO", "DISTROY");
            String Connected_Item_DisplayName = preferences.getString("Connected_Item_DisplayName", "");
            if (Connected_Item_DisplayName.equalsIgnoreCase("")) {
                listitem.setVisibility(View.GONE);
                unbindService(mServiceConnection);
                unregisterReceiver(mGattUpdateReceiver);

            } else {

            }
        } catch (Exception e) {

            e.printStackTrace();
        }
    }
    //  unbindService(mServiceConnection);        //  mBluetoothLeService = null;    }

    private void listPairedDevices() {
        mPairedDevices = mBTAdapter.getBondedDevices();
        if (mBTAdapter.isEnabled()) {
            // put it's one to the adapter
            for (BluetoothDevice device : mPairedDevices)
                //  mBTArrayAdapter.add(device.getName() + "\n" + device.getAddress());
                Log.e("===========", device.getName() + "\n" + device.getAddress());
            Log.e("===========", String.valueOf(mPairedDevices));

            Toast.makeText(getApplicationContext(), "Show Paired Devices", Toast.LENGTH_SHORT).show();
        } else {
            Toast.makeText(getApplicationContext(), "Bluetooth not on", Toast.LENGTH_SHORT).show();
        }
    }


    @Override
    public void onClick(View view) {
        showBuilder2(DeviceListActivity.this, "Pair BT Device", "Do yo really want to disconnect?", tv_title.getText().toString(), device_address.getText().toString());
    }


    public void showBuilder2(@NonNull Context context, @NonNull String title, @NonNull String message, final String devicename, final String devicemacaddress) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title);
        builder.setMessage(message);
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
            @Override
            public void onClick(DialogInterface dialog, int which) {
                Log.e("ENter in this builder", "********");

                try {
                    Cliked = true;
                    if (Cliked = true) {
                        mBluetoothLeService.disconnect(mBluetoothLeService.bluetoothGattMap.get(devicemacaddress));
                        if (devicename.toLowerCase().contains("v.alrt")) {
                            scheduleNotification(getNotification(DeviceListActivity.this, "Bluetooth Connection Lost"), 2000);
                        }
                        listitem.setVisibility(View.GONE);
                        SharedPreferences.Editor editor = preferences.edit();
                        editor.remove("Connected_Item_DisplayName");
                        editor.remove("Connected_Item_Device");
                        editor.remove("Connectivity_Status");
                        editor.remove("Connected_Item");
                        editor.apply();

                        // mBluetoothAdapter.disable();
                        //scannedDeviceAdapter.clear();
                        scanLeDevice(true);

                        mConnected = false;
                        updateConnectionState(R.string.disconnected);
                        invalidateOptionsMenu();

                        Intent newIntent = new Intent();
                        newIntent.setAction(BluetoothDevice.ACTION_ACL_DISCONNECTED);
                        sendBroadcast(newIntent);

                        // scannedDeviceAdapter.clear();


/*
                    mBluetoothLeService =null;

                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("Connected_Item_DisplayName");
                    editor.remove("Connected_Item_Device");
                    editor.remove("Connectivity_Status");
                    editor.remove("Connected_Item");
                    editor.apply();
                    unbindService(mServiceConnection);
                    unregisterReceiver(mGattUpdateReceiver);*/
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                dialog.dismiss();

            }
        });
        builder.setNegativeButton("No", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {

                Cliked = false;
                dialog.dismiss();

            }
        });
        builder.show();
    }
}

